/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.Ints;
import com.google.common.primitives.ParseRequest;
import java.util.Arrays;
import java.util.Comparator;

@ElementTypesAreNonnullByDefault
@Beta
@GwtCompatible
public final class UnsignedInts {
    static final long INT_MASK = 0xFFFFFFFFL;

    private UnsignedInts() {
    }

    static int flip(int value) {
        return value ^ Integer.MIN_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(int a, int b) {
        void var1_1;
        return Ints.compare(UnsignedInts.flip(a), UnsignedInts.flip((int)var1_1));
    }

    public static long toLong(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static int checkedCast(long value) {
        long l;
        Preconditions.checkArgument(value >> 32 == 0L, "out of range: %s", value);
        return (int)l;
    }

    public static int saturatedCast(long value) {
        long l;
        if (value <= 0L) {
            return 0;
        }
        if (value >= 0x100000000L) {
            return -1;
        }
        return (int)l;
    }

    /*
     * WARNING - void declaration
     */
    public static int min(int ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        int min = UnsignedInts.flip(array[0]);
        for (int i = 1; i < array.length; ++i) {
            void var3_3;
            int next = UnsignedInts.flip(array[i]);
            if (next >= min) continue;
            min = var3_3;
        }
        return UnsignedInts.flip((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int max(int ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        int max = UnsignedInts.flip(array[0]);
        for (int i = 1; i < array.length; ++i) {
            void var3_3;
            int next = UnsignedInts.flip(array[i]);
            if (next <= max) continue;
            max = var3_3;
        }
        return UnsignedInts.flip((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(String separator, int ... array) {
        void var2_2;
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 5);
        builder.append(UnsignedInts.toString(array[0]));
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(UnsignedInts.toString(array[i]));
        }
        return var2_2.toString();
    }

    public static Comparator<int[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sort(int[] array) {
        int[] nArray;
        Preconditions.checkNotNull(array);
        UnsignedInts.sort(array, 0, nArray.length);
    }

    public static void sort(int[] array, int fromIndex, int toIndex) {
        int i;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (i = fromIndex; i < toIndex; ++i) {
            array[i] = UnsignedInts.flip(array[i]);
        }
        Arrays.sort(array, fromIndex, toIndex);
        for (i = var1_1; i < toIndex; ++i) {
            array[i] = UnsignedInts.flip(array[i]);
        }
    }

    public static void sortDescending(int[] array) {
        int[] nArray;
        Preconditions.checkNotNull(array);
        UnsignedInts.sortDescending(array, 0, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void sortDescending(int[] array, int fromIndex, int toIndex) {
        void var1_1;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        int i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array[n] = array[n] ^ Integer.MAX_VALUE;
        }
        Arrays.sort(array, fromIndex, toIndex);
        i = var1_1;
        while (i < toIndex) {
            int n = i++;
            array[n] = array[n] ^ Integer.MAX_VALUE;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int divide(int dividend, int divisor) {
        void var1_1;
        return (int)(UnsignedInts.toLong(dividend) / UnsignedInts.toLong((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static int remainder(int dividend, int divisor) {
        void var1_1;
        return (int)(UnsignedInts.toLong(dividend) % UnsignedInts.toLong((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static int decode(String stringValue) {
        ParseRequest request = ParseRequest.fromString(stringValue);
        try {
            return UnsignedInts.parseUnsignedInt(request.rawValue, request.radix);
        }
        catch (NumberFormatException e) {
            NumberFormatException numberFormatException;
            void var1_2;
            String string = String.valueOf(stringValue);
            NumberFormatException decodeException = new NumberFormatException(string.length() != 0 ? "Error parsing value: ".concat(string) : new String("Error parsing value: "));
            decodeException.initCause((Throwable)var1_2);
            throw numberFormatException;
        }
    }

    public static int parseUnsignedInt(String s) {
        return UnsignedInts.parseUnsignedInt(s, 10);
    }

    /*
     * WARNING - void declaration
     */
    public static int parseUnsignedInt(String string, int radix) {
        void var2_2;
        Preconditions.checkNotNull(string);
        long result = Long.parseLong(string, radix);
        if ((result & 0xFFFFFFFFL) != result) {
            void var1_1;
            String string2;
            throw new NumberFormatException(new StringBuilder(69 + String.valueOf(string).length()).append("Input ").append(string2).append(" in base ").append((int)var1_1).append(" is not in the range of an unsigned integer").toString());
        }
        return (int)var2_2;
    }

    public static String toString(int x) {
        return UnsignedInts.toString(x, 10);
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(int x, int radix) {
        void var1_1;
        long l = (long)x & 0xFFFFFFFFL;
        return Long.toString(l, (int)var1_1);
    }

    static enum LexicographicalComparator implements Comparator<int[]>
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(int[] left, int[] right) {
            void var2_2;
            void var1_1;
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                if (left[i] == right[i]) continue;
                return UnsignedInts.compare(left[i], right[i]);
            }
            return ((void)var1_1).length - ((void)var2_2).length;
        }

        public final String toString() {
            return "UnsignedInts.lexicographicalComparator()";
        }
    }
}

