/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.UnsignedInts;
import java.math.BigInteger;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class UnsignedInteger
extends Number
implements Comparable<UnsignedInteger> {
    public static final UnsignedInteger ZERO = UnsignedInteger.fromIntBits(0);
    public static final UnsignedInteger ONE = UnsignedInteger.fromIntBits(1);
    public static final UnsignedInteger MAX_VALUE = UnsignedInteger.fromIntBits(-1);
    private final int value;

    /*
     * WARNING - void declaration
     */
    private UnsignedInteger(int value) {
        void var1_1;
        this.value = var1_1;
    }

    public static UnsignedInteger fromIntBits(int bits) {
        int n;
        return new UnsignedInteger(n);
    }

    public static UnsignedInteger valueOf(long value) {
        long l;
        Preconditions.checkArgument((value & 0xFFFFFFFFL) == value, "value (%s) is outside the range for an unsigned integer value", value);
        return UnsignedInteger.fromIntBits((int)l);
    }

    public static UnsignedInteger valueOf(BigInteger value) {
        BigInteger bigInteger;
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(value.signum() >= 0 && value.bitLength() <= 32, "value (%s) is outside the range for an unsigned integer value", (Object)value);
        return UnsignedInteger.fromIntBits(bigInteger.intValue());
    }

    public static UnsignedInteger valueOf(String string) {
        return UnsignedInteger.valueOf(string, 10);
    }

    /*
     * WARNING - void declaration
     */
    public static UnsignedInteger valueOf(String string, int radix) {
        void var1_1;
        return UnsignedInteger.fromIntBits(UnsignedInts.parseUnsignedInt(string, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final UnsignedInteger plus(UnsignedInteger val) {
        void var1_1;
        return UnsignedInteger.fromIntBits(this.value + ((UnsignedInteger)Preconditions.checkNotNull(var1_1)).value);
    }

    /*
     * WARNING - void declaration
     */
    public final UnsignedInteger minus(UnsignedInteger val) {
        void var1_1;
        return UnsignedInteger.fromIntBits(this.value - ((UnsignedInteger)Preconditions.checkNotNull(var1_1)).value);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public final UnsignedInteger times(UnsignedInteger val) {
        void var1_1;
        return UnsignedInteger.fromIntBits(this.value * ((UnsignedInteger)Preconditions.checkNotNull(var1_1)).value);
    }

    /*
     * WARNING - void declaration
     */
    public final UnsignedInteger dividedBy(UnsignedInteger val) {
        void var1_1;
        return UnsignedInteger.fromIntBits(UnsignedInts.divide(this.value, ((UnsignedInteger)Preconditions.checkNotNull(var1_1)).value));
    }

    /*
     * WARNING - void declaration
     */
    public final UnsignedInteger mod(UnsignedInteger val) {
        void var1_1;
        return UnsignedInteger.fromIntBits(UnsignedInts.remainder(this.value, ((UnsignedInteger)Preconditions.checkNotNull(var1_1)).value));
    }

    @Override
    public final int intValue() {
        return this.value;
    }

    @Override
    public final long longValue() {
        return UnsignedInts.toLong(this.value);
    }

    @Override
    public final float floatValue() {
        return this.longValue();
    }

    @Override
    public final double doubleValue() {
        return this.longValue();
    }

    public final BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(UnsignedInteger other) {
        void var1_1;
        Preconditions.checkNotNull(other);
        return UnsignedInts.compare(this.value, var1_1.value);
    }

    public final int hashCode() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        if (obj instanceof UnsignedInteger) {
            void var1_1;
            UnsignedInteger other = (UnsignedInteger)obj;
            return this.value == var1_1.value;
        }
        return false;
    }

    public final String toString() {
        return this.toString(10);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString(int radix) {
        void var1_1;
        return UnsignedInts.toString(this.value, (int)var1_1);
    }
}

