/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import java.util.Arrays;
import java.util.Comparator;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class SignedBytes {
    public static final byte MAX_POWER_OF_TWO = 64;

    private SignedBytes() {
    }

    /*
     * WARNING - void declaration
     */
    public static byte checkedCast(long value) {
        void var2_1;
        long l;
        byte result = (byte)value;
        Preconditions.checkArgument((long)result == value, "Out of range: %s", l);
        return (byte)var2_1;
    }

    public static byte saturatedCast(long value) {
        long l;
        if (value > 127L) {
            return 127;
        }
        if (value < -128L) {
            return -128;
        }
        return (byte)l;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(byte a, byte b) {
        void var1_1;
        return a - var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static byte min(byte ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        byte min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
        }
        return (byte)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static byte max(byte ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        byte max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return (byte)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String join(String separator, byte ... array) {
        void var2_2;
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 5);
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(array[i]);
        }
        return var2_2.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(byte[] array) {
        byte[] byArray;
        Preconditions.checkNotNull(array);
        SignedBytes.sortDescending(array, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void sortDescending(byte[] array, int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        Arrays.sort(array, fromIndex, toIndex);
        Bytes.reverse(byArray, (int)var1_1, (int)var2_2);
    }

    private static enum LexicographicalComparator implements Comparator<byte[]>
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(byte[] left, byte[] right) {
            void var2_2;
            void var1_1;
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = SignedBytes.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return ((void)var1_1).length - ((void)var2_2).length;
        }

        public final String toString() {
            return "SignedBytes.lexicographicalComparator()";
        }
    }
}

