/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.ShortsMethodsForWeb;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Shorts
extends ShortsMethodsForWeb {
    public static final int BYTES = 2;
    public static final short MAX_POWER_OF_TWO = 16384;

    private Shorts() {
    }

    public static int hashCode(short value) {
        return value;
    }

    /*
     * WARNING - void declaration
     */
    public static short checkedCast(long value) {
        void var2_1;
        long l;
        short result = (short)value;
        Preconditions.checkArgument((long)result == value, "Out of range: %s", l);
        return (short)var2_1;
    }

    public static short saturatedCast(long value) {
        long l;
        if (value > 32767L) {
            return Short.MAX_VALUE;
        }
        if (value < -32768L) {
            return Short.MIN_VALUE;
        }
        return (short)l;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(short a, short b) {
        void var1_1;
        return a - var1_1;
    }

    public static boolean contains(short[] array, short target) {
        short[] sArray = array;
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            short s = sArray[i];
            if (s != target) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(short[] array, short target) {
        short[] sArray;
        void var1_1;
        return Shorts.indexOf(array, (short)var1_1, 0, sArray.length);
    }

    private static int indexOf(short[] array, short target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short[] array, short[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(short[] array, short target) {
        short[] sArray;
        void var1_1;
        return Shorts.lastIndexOf(array, (short)var1_1, 0, sArray.length);
    }

    private static int lastIndexOf(short[] array, short target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static short min(short ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        short min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
        }
        return (short)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static short max(short ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        short max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return (short)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static short constrainToRange(short value, short min, short max) {
        void var2_2;
        Preconditions.checkArgument(min <= max, "min (%s) must be less than or equal to max (%s)", (int)min, (int)max);
        if (value < min) {
            void var1_1;
            return (short)var1_1;
        }
        if (value < max) {
            short s;
            return s;
        }
        return (short)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] concat(short[] ... arrays) {
        short[][] sArray;
        int length = 0;
        short[][] sArray2 = arrays;
        int n = arrays.length;
        for (int i = 0; i < n; ++i) {
            short[] array = sArray2[i];
            length += array.length;
        }
        short[] result = new short[length];
        int pos = 0;
        short[][] sArray3 = sArray;
        int n2 = sArray.length;
        for (int i = 0; i < n2; ++i) {
            void var1_3;
            short[] array = sArray3[i];
            System.arraycopy(array, 0, result, pos, array.length);
            pos += ((void)var1_3).length;
        }
        return sArray2;
    }

    @GwtIncompatible
    public static byte[] toByteArray(short value) {
        short s;
        return new byte[]{(byte)(value >> 8), (byte)s};
    }

    @GwtIncompatible
    public static short fromByteArray(byte[] bytes) {
        byte[] byArray;
        Preconditions.checkArgument(bytes.length >= 2, "array too small: %s < %s", bytes.length, 2);
        return Shorts.fromBytes(bytes[0], byArray[1]);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static short fromBytes(byte b1, byte b2) {
        void var1_1;
        return (short)(b1 << 8 | var1_1 & 0xFF);
    }

    @Beta
    public static Converter<String, Short> stringConverter() {
        return ShortConverter.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] ensureCapacity(short[] array, int minLength, int padding) {
        short[] sArray;
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        if (array.length < minLength) {
            void var2_2;
            void var1_1;
            return Arrays.copyOf(array, (int)(var1_1 + var2_2));
        }
        return sArray;
    }

    /*
     * WARNING - void declaration
     */
    public static String join(String separator, short ... array) {
        void var2_2;
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 6);
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(array[i]);
        }
        return var2_2.toString();
    }

    public static Comparator<short[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(short[] array) {
        short[] sArray;
        Preconditions.checkNotNull(array);
        Shorts.sortDescending(array, 0, sArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void sortDescending(short[] array, int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        short[] sArray;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        Arrays.sort(array, fromIndex, toIndex);
        Shorts.reverse(sArray, (int)var1_1, (int)var2_2);
    }

    public static void reverse(short[] array) {
        short[] sArray;
        Preconditions.checkNotNull(array);
        Shorts.reverse(array, 0, sArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(short[] array, int fromIndex, int toIndex) {
        void i;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (int j = toIndex - 1; i < j; ++i, --j) {
            void var3_3;
            short tmp = array[i];
            array[i] = array[j];
            array[j] = var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static short[] toArray(Collection<? extends Number> collection) {
        void var2_2;
        if (collection instanceof ShortArrayAsList) {
            return ((ShortArrayAsList)collection).toShortArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        short[] array = new short[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ((Number)Preconditions.checkNotNull(boxedArray[i])).shortValue();
        }
        return var2_2;
    }

    public static List<Short> asList(short ... backingArray) {
        short[] sArray;
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new ShortArrayAsList(sArray);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$000(short[] x0, short x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Shorts.indexOf(x0, (short)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$100(short[] x0, short x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Shorts.lastIndexOf(x0, (short)var1_1, (int)var2_2, (int)var3_3);
    }

    @GwtCompatible
    private static class ShortArrayAsList
    extends AbstractList<Short>
    implements Serializable,
    RandomAccess {
        final short[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        ShortArrayAsList(short[] array) {
            this(array, 0, ((void)var1_1).length);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        ShortArrayAsList(short[] array, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.array = var1_1;
            this.start = var2_2;
            this.end = var3_3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Short get(int index) {
            void var1_1;
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + var1_1];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object target) {
            void var1_1;
            return target instanceof Short && Shorts.access$000(this.array, (Short)var1_1, this.start, this.end) != -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Object target) {
            int i;
            if (target instanceof Short && (i = Shorts.access$000(this.array, (Short)target, this.start, this.end)) >= 0) {
                void var1_2;
                return (int)(var1_2 - this.start);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int lastIndexOf(Object target) {
            int i;
            if (target instanceof Short && (i = Shorts.access$100(this.array, (Short)target, this.start, this.end)) >= 0) {
                void var1_2;
                return (int)(var1_2 - this.start);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Short set(int index, Short element) {
            void var3_3;
            void var2_2;
            Preconditions.checkElementIndex(index, this.size());
            short oldValue = this.array[this.start + index];
            this.array[this.start + var1_1] = (Short)Preconditions.checkNotNull(var2_2);
            return (short)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<Short> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            void var3_3;
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, (int)var3_3);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new ShortArrayAsList(this.array, this.start + var1_1, this.start + var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            void var1_1;
            if (object == this) {
                return true;
            }
            if (object instanceof ShortArrayAsList) {
                ShortArrayAsList that = (ShortArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int hashCode() {
            void var1_1;
            int result = 1;
            for (int i = this.start; i < this.end; ++i) {
                result = result * 31 + Shorts.hashCode(this.array[i]);
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String toString() {
            void var1_1;
            StringBuilder builder = new StringBuilder(this.size() * 6);
            builder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append(", ").append(this.array[i]);
            }
            return var1_1.append(']').toString();
        }

        short[] toShortArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<short[]>
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(short[] left, short[] right) {
            void var2_2;
            void var1_1;
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Shorts.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return ((void)var1_1).length - ((void)var2_2).length;
        }

        public final String toString() {
            return "Shorts.lexicographicalComparator()";
        }
    }

    private static final class ShortConverter
    extends Converter<String, Short>
    implements Serializable {
        static final ShortConverter INSTANCE = new ShortConverter();
        private static final long serialVersionUID = 1L;

        private ShortConverter() {
        }

        @Override
        protected final Short doForward(String value) {
            return Short.decode(value);
        }

        @Override
        protected final String doBackward(Short value) {
            return value.toString();
        }

        public final String toString() {
            return "Shorts.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

