/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class ParseRequest {
    final String rawValue;
    final int radix;

    /*
     * WARNING - void declaration
     */
    private ParseRequest(String rawValue, int radix) {
        void var2_2;
        void var1_1;
        this.rawValue = var1_1;
        this.radix = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static ParseRequest fromString(String stringValue) {
        void var1_1;
        String string;
        int radix;
        String rawValue;
        if (stringValue.length() == 0) {
            throw new NumberFormatException("empty string");
        }
        char firstChar = stringValue.charAt(0);
        if (stringValue.startsWith("0x") || stringValue.startsWith("0X")) {
            rawValue = stringValue.substring(2);
            radix = 16;
        } else if (radix == 35) {
            rawValue = rawValue.substring(1);
            radix = 16;
        } else if (radix == 48 && rawValue.length() > 1) {
            rawValue = rawValue.substring(1);
            radix = 8;
        } else {
            radix = 10;
        }
        return new ParseRequest(string, (int)var1_1);
    }
}

