/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Longs {
    public static final int BYTES = 8;
    public static final long MAX_POWER_OF_TWO = 0x4000000000000000L;

    private Longs() {
    }

    public static int hashCode(long value) {
        long l = value;
        return (int)(l ^ l >>> 32);
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(long a, long b) {
        void var2_1;
        long l;
        if (a < b) {
            return -1;
        }
        if (l > var2_1) {
            return 1;
        }
        return 0;
    }

    public static boolean contains(long[] array, long target) {
        long[] lArray = array;
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            if (l != target) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(long[] array, long target) {
        long[] lArray;
        void var1_1;
        return Longs.indexOf(array, (long)var1_1, 0, lArray.length);
    }

    private static int indexOf(long[] array, long target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] array, long[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(long[] array, long target) {
        long[] lArray;
        void var1_1;
        return Longs.lastIndexOf(array, (long)var1_1, 0, lArray.length);
    }

    private static int lastIndexOf(long[] array, long target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static long min(long ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        long min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static long max(long ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        long max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static long constrainToRange(long value, long min, long max) {
        void var2_2;
        long l;
        Preconditions.checkArgument(min <= max, "min (%s) must be less than or equal to max (%s)", min, max);
        return Math.min(Math.max(l, (long)var2_2), max);
    }

    /*
     * WARNING - void declaration
     */
    public static long[] concat(long[] ... arrays) {
        long[][] lArray;
        int length = 0;
        long[][] lArray2 = arrays;
        int n = arrays.length;
        for (int i = 0; i < n; ++i) {
            long[] array = lArray2[i];
            length += array.length;
        }
        long[] result = new long[length];
        int pos = 0;
        long[][] lArray3 = lArray;
        int n2 = lArray.length;
        for (int i = 0; i < n2; ++i) {
            void var1_3;
            long[] array = lArray3[i];
            System.arraycopy(array, 0, result, pos, array.length);
            pos += ((void)var1_3).length;
        }
        return lArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toByteArray(long value) {
        void var2_1;
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return var2_1;
    }

    public static long fromByteArray(byte[] bytes) {
        byte[] byArray;
        Preconditions.checkArgument(bytes.length >= 8, "array too small: %s < %s", bytes.length, 8);
        return Longs.fromBytes(bytes[0], bytes[1], bytes[2], bytes[3], bytes[4], bytes[5], bytes[6], byArray[7]);
    }

    /*
     * WARNING - void declaration
     */
    public static long fromBytes(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7, byte b8) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ((long)b1 & 0xFFL) << 56 | ((long)var1_1 & 0xFFL) << 48 | ((long)var2_2 & 0xFFL) << 40 | ((long)var3_3 & 0xFFL) << 32 | ((long)b5 & 0xFFL) << 24 | ((long)b6 & 0xFFL) << 16 | ((long)b7 & 0xFFL) << 8 | (long)b8 & 0xFFL;
    }

    @Beta
    public static Long tryParse(String string) {
        return Longs.tryParse(string, 10);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static Long tryParse(String string, int radix) {
        void var2_2;
        int digit;
        if (Preconditions.checkNotNull(string).isEmpty()) {
            return null;
        }
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException(new StringBuilder(65).append("radix must be between MIN_RADIX and MAX_RADIX but was ").append(radix).toString());
        }
        boolean negative = string.charAt(0) == '-';
        int index = negative ? 1 : 0;
        if (index == string.length()) {
            return null;
        }
        if ((digit = AsciiDigits.digit(string.charAt(index++))) < 0 || digit >= radix) {
            return null;
        }
        long accum = -digit;
        long cap = Long.MIN_VALUE / (long)radix;
        while (index < string.length()) {
            if ((digit = AsciiDigits.digit(string.charAt(index++))) < 0 || digit >= radix || accum < cap) {
                return null;
            }
            if ((accum *= (long)radix) < Long.MIN_VALUE + (long)digit) {
                return null;
            }
            accum -= (long)digit;
        }
        if (var2_2 != false) {
            return accum;
        }
        if (accum == Long.MIN_VALUE) {
            return null;
        }
        return -accum;
    }

    @Beta
    public static Converter<String, Long> stringConverter() {
        return LongConverter.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public static long[] ensureCapacity(long[] array, int minLength, int padding) {
        long[] lArray;
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        if (array.length < minLength) {
            void var2_2;
            void var1_1;
            return Arrays.copyOf(array, (int)(var1_1 + var2_2));
        }
        return lArray;
    }

    /*
     * WARNING - void declaration
     */
    public static String join(String separator, long ... array) {
        void var2_2;
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 10);
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(array[i]);
        }
        return var2_2.toString();
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(long[] array) {
        long[] lArray;
        Preconditions.checkNotNull(array);
        Longs.sortDescending(array, 0, lArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void sortDescending(long[] array, int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        long[] lArray;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        Arrays.sort(array, fromIndex, toIndex);
        Longs.reverse(lArray, (int)var1_1, (int)var2_2);
    }

    public static void reverse(long[] array) {
        long[] lArray;
        Preconditions.checkNotNull(array);
        Longs.reverse(array, 0, lArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(long[] array, int fromIndex, int toIndex) {
        void i;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (int j = toIndex - 1; i < j; ++i, --j) {
            long tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static long[] toArray(Collection<? extends Number> collection) {
        void var2_2;
        if (collection instanceof LongArrayAsList) {
            return ((LongArrayAsList)collection).toLongArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        long[] array = new long[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ((Number)Preconditions.checkNotNull(boxedArray[i])).longValue();
        }
        return var2_2;
    }

    public static List<Long> asList(long ... backingArray) {
        long[] lArray;
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new LongArrayAsList(lArray);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$000(long[] x0, long x1, int x2, int x3) {
        void var3_2;
        void var1_1;
        return Longs.indexOf(x0, (long)var1_1, (int)var3_2, x3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$100(long[] x0, long x1, int x2, int x3) {
        void var3_2;
        void var1_1;
        return Longs.lastIndexOf(x0, (long)var1_1, (int)var3_2, x3);
    }

    @GwtCompatible
    private static class LongArrayAsList
    extends AbstractList<Long>
    implements Serializable,
    RandomAccess {
        final long[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        LongArrayAsList(long[] array) {
            this(array, 0, ((void)var1_1).length);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        LongArrayAsList(long[] array, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.array = var1_1;
            this.start = var2_2;
            this.end = var3_3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Long get(int index) {
            void var1_1;
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + var1_1];
        }

        public Spliterator.OfLong spliterator() {
            return Spliterators.spliterator(this.array, this.start, this.end, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object target) {
            void var1_1;
            return target instanceof Long && Longs.access$000(this.array, (Long)var1_1, this.start, this.end) != -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Object target) {
            int i;
            if (target instanceof Long && (i = Longs.access$000(this.array, (Long)target, this.start, this.end)) >= 0) {
                void var1_2;
                return (int)(var1_2 - this.start);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int lastIndexOf(Object target) {
            int i;
            if (target instanceof Long && (i = Longs.access$100(this.array, (Long)target, this.start, this.end)) >= 0) {
                void var1_2;
                return (int)(var1_2 - this.start);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Long set(int index, Long element) {
            void var3_3;
            void var2_2;
            Preconditions.checkElementIndex(index, this.size());
            long oldValue = this.array[this.start + index];
            this.array[this.start + var1_1] = (Long)Preconditions.checkNotNull(var2_2);
            return (long)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<Long> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            void var3_3;
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, (int)var3_3);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new LongArrayAsList(this.array, this.start + var1_1, this.start + var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            void var1_1;
            if (object == this) {
                return true;
            }
            if (object instanceof LongArrayAsList) {
                LongArrayAsList that = (LongArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int hashCode() {
            void var1_1;
            int result = 1;
            for (int i = this.start; i < this.end; ++i) {
                result = result * 31 + Longs.hashCode(this.array[i]);
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String toString() {
            void var1_1;
            StringBuilder builder = new StringBuilder(this.size() * 10);
            builder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append(", ").append(this.array[i]);
            }
            return var1_1.append(']').toString();
        }

        long[] toLongArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(long[] left, long[] right) {
            void var2_2;
            void var1_1;
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Longs.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return ((void)var1_1).length - ((void)var2_2).length;
        }

        public final String toString() {
            return "Longs.lexicographicalComparator()";
        }
    }

    private static final class LongConverter
    extends Converter<String, Long>
    implements Serializable {
        static final LongConverter INSTANCE = new LongConverter();
        private static final long serialVersionUID = 1L;

        private LongConverter() {
        }

        @Override
        protected final Long doForward(String value) {
            return Long.decode(value);
        }

        @Override
        protected final String doBackward(Long value) {
            return value.toString();
        }

        public final String toString() {
            return "Longs.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    static final class AsciiDigits {
        private static final byte[] asciiDigits;

        private AsciiDigits() {
        }

        static int digit(char c) {
            if (c < '\u0080') {
                char c2;
                return asciiDigits[c2];
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var0;
            int i;
            byte[] result = new byte[128];
            Arrays.fill(result, (byte)-1);
            for (i = 0; i < 10; ++i) {
                result[i + 48] = (byte)i;
            }
            for (i = 0; i < 26; ++i) {
                result[i + 65] = (byte)(i + 10);
                result[i + 97] = (byte)(i + 10);
            }
            asciiDigits = var0;
        }
    }
}

