/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.IntsMethodsForWeb;
import com.google.common.primitives.Longs;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Ints
extends IntsMethodsForWeb {
    public static final int BYTES = 4;
    public static final int MAX_POWER_OF_TWO = 0x40000000;

    private Ints() {
    }

    public static int hashCode(int value) {
        return value;
    }

    /*
     * WARNING - void declaration
     */
    public static int checkedCast(long value) {
        void var2_1;
        long l;
        int result = (int)value;
        Preconditions.checkArgument((long)result == value, "Out of range: %s", l);
        return (int)var2_1;
    }

    public static int saturatedCast(long value) {
        long l;
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(int a, int b) {
        void var1_1;
        int n;
        if (a < b) {
            return -1;
        }
        if (n > var1_1) {
            return 1;
        }
        return 0;
    }

    public static boolean contains(int[] array, int target) {
        int[] nArray = array;
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 != target) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(int[] array, int target) {
        int[] nArray;
        void var1_1;
        return Ints.indexOf(array, (int)var1_1, 0, nArray.length);
    }

    private static int indexOf(int[] array, int target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(int[] array, int target) {
        int[] nArray;
        void var1_1;
        return Ints.lastIndexOf(array, (int)var1_1, 0, nArray.length);
    }

    private static int lastIndexOf(int[] array, int target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static int min(int ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        int min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static int max(int ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        int max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static int constrainToRange(int value, int min, int max) {
        void var2_2;
        void var1_1;
        int n;
        Preconditions.checkArgument(min <= max, "min (%s) must be less than or equal to max (%s)", min, max);
        return Math.min(Math.max(n, (int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] concat(int[] ... arrays) {
        int[][] nArray;
        int length = 0;
        int[][] nArray2 = arrays;
        int n = arrays.length;
        for (int i = 0; i < n; ++i) {
            int[] array = nArray2[i];
            length += array.length;
        }
        int[] result = new int[length];
        int pos = 0;
        int[][] nArray3 = nArray;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            void var1_3;
            int[] array = nArray3[i];
            System.arraycopy(array, 0, result, pos, array.length);
            pos += ((void)var1_3).length;
        }
        return nArray2;
    }

    public static byte[] toByteArray(int value) {
        int n;
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)n};
    }

    public static int fromByteArray(byte[] bytes) {
        byte[] byArray;
        Preconditions.checkArgument(bytes.length >= 4, "array too small: %s < %s", bytes.length, 4);
        return Ints.fromBytes(bytes[0], bytes[1], bytes[2], byArray[3]);
    }

    /*
     * WARNING - void declaration
     */
    public static int fromBytes(byte b1, byte b2, byte b3, byte b4) {
        void var3_3;
        void var2_2;
        void var1_1;
        return b1 << 24 | (var1_1 & 0xFF) << 16 | (var2_2 & 0xFF) << 8 | var3_3 & 0xFF;
    }

    @Beta
    public static Converter<String, Integer> stringConverter() {
        return IntConverter.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] ensureCapacity(int[] array, int minLength, int padding) {
        int[] nArray;
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        if (array.length < minLength) {
            void var2_2;
            void var1_1;
            return Arrays.copyOf(array, (int)(var1_1 + var2_2));
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    public static String join(String separator, int ... array) {
        void var2_2;
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 5);
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(array[i]);
        }
        return var2_2.toString();
    }

    public static Comparator<int[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(int[] array) {
        int[] nArray;
        Preconditions.checkNotNull(array);
        Ints.sortDescending(array, 0, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void sortDescending(int[] array, int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        int[] nArray;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        Arrays.sort(array, fromIndex, toIndex);
        Ints.reverse(nArray, (int)var1_1, (int)var2_2);
    }

    public static void reverse(int[] array) {
        int[] nArray;
        Preconditions.checkNotNull(array);
        Ints.reverse(array, 0, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(int[] array, int fromIndex, int toIndex) {
        void i;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (int j = toIndex - 1; i < j; ++i, --j) {
            void var3_3;
            int tmp = array[i];
            array[i] = array[j];
            array[j] = var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int[] toArray(Collection<? extends Number> collection) {
        void var2_2;
        if (collection instanceof IntArrayAsList) {
            return ((IntArrayAsList)collection).toIntArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        int[] array = new int[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ((Number)Preconditions.checkNotNull(boxedArray[i])).intValue();
        }
        return var2_2;
    }

    public static List<Integer> asList(int ... backingArray) {
        int[] nArray;
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new IntArrayAsList(nArray);
    }

    @Beta
    public static Integer tryParse(String string) {
        return Ints.tryParse(string, 10);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static Integer tryParse(String string, int radix) {
        Long l;
        void var1_1;
        Long result = Longs.tryParse(string, (int)var1_1);
        if (result == null || result != (long)result.intValue()) {
            return null;
        }
        return l.intValue();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$000(int[] x0, int x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Ints.indexOf(x0, (int)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$100(int[] x0, int x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Ints.lastIndexOf(x0, (int)var1_1, (int)var2_2, (int)var3_3);
    }

    @GwtCompatible
    private static class IntArrayAsList
    extends AbstractList<Integer>
    implements Serializable,
    RandomAccess {
        final int[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        IntArrayAsList(int[] array) {
            this(array, 0, ((void)var1_1).length);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        IntArrayAsList(int[] array, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.array = var1_1;
            this.start = var2_2;
            this.end = var3_3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Integer get(int index) {
            void var1_1;
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + var1_1];
        }

        public Spliterator.OfInt spliterator() {
            return Spliterators.spliterator(this.array, this.start, this.end, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object target) {
            void var1_1;
            return target instanceof Integer && Ints.access$000(this.array, (Integer)var1_1, this.start, this.end) != -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Object target) {
            int i;
            if (target instanceof Integer && (i = Ints.access$000(this.array, (Integer)target, this.start, this.end)) >= 0) {
                void var1_2;
                return (int)(var1_2 - this.start);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int lastIndexOf(Object target) {
            int i;
            if (target instanceof Integer && (i = Ints.access$100(this.array, (Integer)target, this.start, this.end)) >= 0) {
                void var1_2;
                return (int)(var1_2 - this.start);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Integer set(int index, Integer element) {
            void var3_3;
            void var2_2;
            Preconditions.checkElementIndex(index, this.size());
            int oldValue = this.array[this.start + index];
            this.array[this.start + var1_1] = (Integer)Preconditions.checkNotNull(var2_2);
            return (int)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<Integer> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            void var3_3;
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, (int)var3_3);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new IntArrayAsList(this.array, this.start + var1_1, this.start + var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            void var1_1;
            if (object == this) {
                return true;
            }
            if (object instanceof IntArrayAsList) {
                IntArrayAsList that = (IntArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int hashCode() {
            void var1_1;
            int result = 1;
            for (int i = this.start; i < this.end; ++i) {
                result = result * 31 + Ints.hashCode(this.array[i]);
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String toString() {
            void var1_1;
            StringBuilder builder = new StringBuilder(this.size() * 5);
            builder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append(", ").append(this.array[i]);
            }
            return var1_1.append(']').toString();
        }

        int[] toIntArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<int[]>
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(int[] left, int[] right) {
            void var2_2;
            void var1_1;
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Ints.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return ((void)var1_1).length - ((void)var2_2).length;
        }

        public final String toString() {
            return "Ints.lexicographicalComparator()";
        }
    }

    private static final class IntConverter
    extends Converter<String, Integer>
    implements Serializable {
        static final IntConverter INSTANCE = new IntConverter();
        private static final long serialVersionUID = 1L;

        private IntConverter() {
        }

        @Override
        protected final Integer doForward(String value) {
            return Integer.decode(value);
        }

        @Override
        protected final String doBackward(Integer value) {
            return value.toString();
        }

        public final String toString() {
            return "Ints.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

