/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.LongConsumer;
import java.util.stream.LongStream;

@ElementTypesAreNonnullByDefault
@Beta
@GwtCompatible
public final class ImmutableLongArray
implements Serializable {
    private static final ImmutableLongArray EMPTY = new ImmutableLongArray(new long[0]);
    private final long[] array;
    private final transient int start;
    private final int end;

    public static ImmutableLongArray of() {
        return EMPTY;
    }

    public static ImmutableLongArray of(long e0) {
        long l;
        return new ImmutableLongArray(new long[]{l});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableLongArray of(long e0, long e1) {
        void var2_1;
        long l;
        return new ImmutableLongArray(new long[]{l, var2_1});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableLongArray of(long e0, long e1, long e2) {
        void var2_2;
        long l;
        return new ImmutableLongArray(new long[]{l, var2_2, e2});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableLongArray of(long e0, long e1, long e2, long e3) {
        void var2_1;
        long l;
        return new ImmutableLongArray(new long[]{l, var2_1, e2, e3});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableLongArray of(long e0, long e1, long e2, long e3, long e4) {
        void var2_2;
        long l;
        return new ImmutableLongArray(new long[]{l, var2_2, e2, e3, e4});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableLongArray of(long e0, long e1, long e2, long e3, long e4, long e5) {
        void var2_2;
        long l;
        return new ImmutableLongArray(new long[]{l, var2_2, e2, e3, e4, e5});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableLongArray of(long first, long ... rest) {
        void var3_2;
        void var2_1;
        long l;
        Preconditions.checkArgument(rest.length <= 0x7FFFFFFE, "the total number of elements must fit in an int");
        long[] lArray = new long[rest.length + 1];
        long[] array = lArray;
        lArray[0] = l;
        System.arraycopy(rest, 0, array, 1, ((void)var2_1).length);
        return new ImmutableLongArray((long[])var3_2);
    }

    public static ImmutableLongArray copyOf(long[] values) {
        long[] lArray;
        if (values.length == 0) {
            return EMPTY;
        }
        return new ImmutableLongArray(Arrays.copyOf(lArray, lArray.length));
    }

    public static ImmutableLongArray copyOf(Collection<Long> values) {
        Collection<Long> collection;
        if (values.isEmpty()) {
            return EMPTY;
        }
        return new ImmutableLongArray(Longs.toArray(collection));
    }

    public static ImmutableLongArray copyOf(Iterable<Long> values) {
        Iterable<Long> iterable;
        if (values instanceof Collection) {
            return ImmutableLongArray.copyOf((Collection)values);
        }
        return ImmutableLongArray.builder().addAll(iterable).build();
    }

    public static ImmutableLongArray copyOf(LongStream stream) {
        Object object;
        long[] lArray = stream.toArray();
        Object array = lArray;
        if (lArray.length == 0) {
            return EMPTY;
        }
        return new ImmutableLongArray((long[])object);
    }

    public static Builder builder(int initialCapacity) {
        int n;
        Preconditions.checkArgument(initialCapacity >= 0, "Invalid initialCapacity: %s", initialCapacity);
        return new Builder(n);
    }

    public static Builder builder() {
        return new Builder(10);
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableLongArray(long[] array) {
        this(array, 0, ((void)var1_1).length);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableLongArray(long[] array, int start, int end) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.array = var1_1;
        this.start = var2_2;
        this.end = var3_3;
    }

    public final int length() {
        return this.end - this.start;
    }

    public final boolean isEmpty() {
        return this.end == this.start;
    }

    /*
     * WARNING - void declaration
     */
    public final long get(int index) {
        void var1_1;
        Preconditions.checkElementIndex(index, this.length());
        return this.array[this.start + var1_1];
    }

    public final int indexOf(long target) {
        for (int i = this.start; i < this.end; ++i) {
            if (this.array[i] != target) continue;
            return i - this.start;
        }
        return -1;
    }

    public final int lastIndexOf(long target) {
        for (int i = this.end - 1; i >= this.start; --i) {
            if (this.array[i] != target) continue;
            return i - this.start;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(long target) {
        void var1_1;
        return this.indexOf((long)var1_1) >= 0;
    }

    public final void forEach(LongConsumer consumer) {
        Preconditions.checkNotNull(consumer);
        for (int i = this.start; i < this.end; ++i) {
            consumer.accept(this.array[i]);
        }
    }

    public final LongStream stream() {
        return Arrays.stream(this.array, this.start, this.end);
    }

    public final long[] toArray() {
        return Arrays.copyOfRange(this.array, this.start, this.end);
    }

    /*
     * WARNING - void declaration
     */
    public final ImmutableLongArray subArray(int startIndex, int endIndex) {
        void var2_2;
        void var1_1;
        Preconditions.checkPositionIndexes(startIndex, endIndex, this.length());
        if (startIndex == endIndex) {
            return EMPTY;
        }
        return new ImmutableLongArray(this.array, this.start + var1_1, this.start + var2_2);
    }

    private Spliterator.OfLong spliterator() {
        return Spliterators.spliterator(this.array, this.start, this.end, 1040);
    }

    public final List<Long> asList() {
        return new AsList(this);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImmutableLongArray)) {
            return false;
        }
        ImmutableLongArray that = (ImmutableLongArray)object;
        if (this.length() != that.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (this.get(i) == that.get(i)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int hash = 1;
        for (int i = this.start; i < this.end; ++i) {
            hash *= 31;
            hash += Longs.hashCode(this.array[i]);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder(this.length() * 5);
        builder.append('[').append(this.array[this.start]);
        for (int i = this.start + 1; i < this.end; ++i) {
            builder.append(", ").append(this.array[i]);
        }
        builder.append(']');
        return var1_1.toString();
    }

    public final ImmutableLongArray trimmed() {
        if (this.isPartialView()) {
            return new ImmutableLongArray(this.toArray());
        }
        return this;
    }

    private boolean isPartialView() {
        return this.start > 0 || this.end < this.array.length;
    }

    final Object writeReplace() {
        return this.trimmed();
    }

    final Object readResolve() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return this;
    }

    static class AsList
    extends AbstractList<Long>
    implements Serializable,
    RandomAccess {
        private final ImmutableLongArray parent;

        /*
         * WARNING - void declaration
         */
        private AsList(ImmutableLongArray parent) {
            void var1_1;
            this.parent = var1_1;
        }

        @Override
        public int size() {
            return this.parent.length();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Long get(int index) {
            void var1_1;
            return this.parent.get((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object target) {
            void var1_1;
            return this.indexOf(var1_1) >= 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Object target) {
            if (target instanceof Long) {
                void var1_1;
                return this.parent.indexOf((Long)var1_1);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int lastIndexOf(Object target) {
            if (target instanceof Long) {
                void var1_1;
                return this.parent.lastIndexOf((Long)var1_1);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<Long> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            return this.parent.subArray((int)var1_1, (int)var2_2).asList();
        }

        @Override
        public Spliterator<Long> spliterator() {
            return this.parent.spliterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            Iterator iterator;
            List<Long> that;
            if (object instanceof AsList) {
                that = (AsList)object;
                return this.parent.equals(((AsList)that).parent);
            }
            if (!(that instanceof List)) {
                return false;
            }
            that = that;
            if (this.size() != that.size()) {
                return false;
            }
            int i = this.parent.start;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                Object element = iterator.next();
                if (element instanceof Long && this.parent.array[i++] == (Long)var3_3) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.parent.hashCode();
        }

        @Override
        public String toString() {
            return this.parent.toString();
        }
    }

    public static final class Builder {
        private long[] array;
        private int count = 0;

        /*
         * WARNING - void declaration
         */
        Builder(int initialCapacity) {
            void var1_1;
            this.array = new long[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        public final Builder add(long value) {
            void var1_1;
            this.ensureRoomFor(1);
            this.array[this.count] = var1_1;
            ++this.count;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAll(long[] values) {
            void var1_1;
            this.ensureRoomFor(values.length);
            System.arraycopy(values, 0, this.array, this.count, values.length);
            this.count += ((void)var1_1).length;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAll(Iterable<Long> values) {
            Iterator iterator;
            if (values instanceof Collection) {
                return this.addAll((Collection)values);
            }
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Long value = (Long)iterator.next();
                this.add(var2_2.longValue());
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAll(Collection<Long> values) {
            Iterator iterator;
            this.ensureRoomFor(values.size());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Long value = (Long)iterator.next();
                this.array[this.count++] = var2_2.longValue();
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAll(LongStream stream) {
            void var1_1;
            Spliterator.OfLong spliterator = stream.spliterator();
            long size = spliterator.getExactSizeIfKnown();
            if (size > 0L) {
                void var3_2;
                this.ensureRoomFor(Ints.saturatedCast((long)var3_2));
            }
            var1_1.forEachRemaining(this::add);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAll(ImmutableLongArray values) {
            void var1_1;
            this.ensureRoomFor(values.length());
            System.arraycopy(values.array, values.start, this.array, this.count, values.length());
            this.count += var1_1.length();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private void ensureRoomFor(int numberToAdd) {
            int newCount = this.count + numberToAdd;
            if (newCount > this.array.length) {
                void var1_1;
                this.array = Arrays.copyOf(this.array, Builder.expandedCapacity(this.array.length, (int)var1_1));
            }
        }

        /*
         * WARNING - void declaration
         */
        private static int expandedCapacity(int oldCapacity, int minCapacity) {
            int n;
            if (minCapacity < 0) {
                throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
            }
            int n2 = oldCapacity;
            int newCapacity = n2 + (n2 >> 1) + 1;
            if (newCapacity < minCapacity) {
                void var1_1;
                newCapacity = Integer.highestOneBit((int)(var1_1 - true)) << 1;
            }
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            return n;
        }

        public final ImmutableLongArray build() {
            if (this.count == 0) {
                return EMPTY;
            }
            return new ImmutableLongArray(this.array, 0, this.count);
        }
    }
}

