/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;

@ElementTypesAreNonnullByDefault
@Beta
@GwtCompatible
public final class ImmutableIntArray
implements Serializable {
    private static final ImmutableIntArray EMPTY = new ImmutableIntArray(new int[0]);
    private final int[] array;
    private final transient int start;
    private final int end;

    public static ImmutableIntArray of() {
        return EMPTY;
    }

    public static ImmutableIntArray of(int e0) {
        int n;
        return new ImmutableIntArray(new int[]{n});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableIntArray of(int e0, int e1) {
        void var1_1;
        int n;
        return new ImmutableIntArray(new int[]{n, var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableIntArray of(int e0, int e1, int e2) {
        void var2_2;
        void var1_1;
        int n;
        return new ImmutableIntArray(new int[]{n, var1_1, var2_2});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableIntArray of(int e0, int e1, int e2, int e3) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        return new ImmutableIntArray(new int[]{n, var1_1, var2_2, var3_3});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableIntArray of(int e0, int e1, int e2, int e3, int e4) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        return new ImmutableIntArray(new int[]{n, var1_1, var2_2, var3_3, e4});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableIntArray of(int e0, int e1, int e2, int e3, int e4, int e5) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        return new ImmutableIntArray(new int[]{n, var1_1, var2_2, var3_3, e4, e5});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableIntArray of(int first, int ... rest) {
        void var2_2;
        void var1_1;
        int n;
        Preconditions.checkArgument(rest.length <= 0x7FFFFFFE, "the total number of elements must fit in an int");
        int[] nArray = new int[rest.length + 1];
        int[] array = nArray;
        nArray[0] = n;
        System.arraycopy(rest, 0, array, 1, ((void)var1_1).length);
        return new ImmutableIntArray((int[])var2_2);
    }

    public static ImmutableIntArray copyOf(int[] values) {
        int[] nArray;
        if (values.length == 0) {
            return EMPTY;
        }
        return new ImmutableIntArray(Arrays.copyOf(nArray, nArray.length));
    }

    public static ImmutableIntArray copyOf(Collection<Integer> values) {
        Collection<Integer> collection;
        if (values.isEmpty()) {
            return EMPTY;
        }
        return new ImmutableIntArray(Ints.toArray(collection));
    }

    public static ImmutableIntArray copyOf(Iterable<Integer> values) {
        Iterable<Integer> iterable;
        if (values instanceof Collection) {
            return ImmutableIntArray.copyOf((Collection)values);
        }
        return ImmutableIntArray.builder().addAll(iterable).build();
    }

    public static ImmutableIntArray copyOf(IntStream stream) {
        Object object;
        int[] nArray = stream.toArray();
        Object array = nArray;
        if (nArray.length == 0) {
            return EMPTY;
        }
        return new ImmutableIntArray((int[])object);
    }

    public static Builder builder(int initialCapacity) {
        int n;
        Preconditions.checkArgument(initialCapacity >= 0, "Invalid initialCapacity: %s", initialCapacity);
        return new Builder(n);
    }

    public static Builder builder() {
        return new Builder(10);
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableIntArray(int[] array) {
        this(array, 0, ((void)var1_1).length);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableIntArray(int[] array, int start, int end) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.array = var1_1;
        this.start = var2_2;
        this.end = var3_3;
    }

    public final int length() {
        return this.end - this.start;
    }

    public final boolean isEmpty() {
        return this.end == this.start;
    }

    /*
     * WARNING - void declaration
     */
    public final int get(int index) {
        void var1_1;
        Preconditions.checkElementIndex(index, this.length());
        return this.array[this.start + var1_1];
    }

    public final int indexOf(int target) {
        for (int i = this.start; i < this.end; ++i) {
            if (this.array[i] != target) continue;
            return i - this.start;
        }
        return -1;
    }

    public final int lastIndexOf(int target) {
        for (int i = this.end - 1; i >= this.start; --i) {
            if (this.array[i] != target) continue;
            return i - this.start;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(int target) {
        void var1_1;
        return this.indexOf((int)var1_1) >= 0;
    }

    public final void forEach(IntConsumer consumer) {
        Preconditions.checkNotNull(consumer);
        for (int i = this.start; i < this.end; ++i) {
            consumer.accept(this.array[i]);
        }
    }

    public final IntStream stream() {
        return Arrays.stream(this.array, this.start, this.end);
    }

    public final int[] toArray() {
        return Arrays.copyOfRange(this.array, this.start, this.end);
    }

    /*
     * WARNING - void declaration
     */
    public final ImmutableIntArray subArray(int startIndex, int endIndex) {
        void var2_2;
        void var1_1;
        Preconditions.checkPositionIndexes(startIndex, endIndex, this.length());
        if (startIndex == endIndex) {
            return EMPTY;
        }
        return new ImmutableIntArray(this.array, this.start + var1_1, this.start + var2_2);
    }

    private Spliterator.OfInt spliterator() {
        return Spliterators.spliterator(this.array, this.start, this.end, 1040);
    }

    public final List<Integer> asList() {
        return new AsList(this);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImmutableIntArray)) {
            return false;
        }
        ImmutableIntArray that = (ImmutableIntArray)object;
        if (this.length() != that.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (this.get(i) == that.get(i)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int hash = 1;
        for (int i = this.start; i < this.end; ++i) {
            hash *= 31;
            hash += Ints.hashCode(this.array[i]);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder(this.length() * 5);
        builder.append('[').append(this.array[this.start]);
        for (int i = this.start + 1; i < this.end; ++i) {
            builder.append(", ").append(this.array[i]);
        }
        builder.append(']');
        return var1_1.toString();
    }

    public final ImmutableIntArray trimmed() {
        if (this.isPartialView()) {
            return new ImmutableIntArray(this.toArray());
        }
        return this;
    }

    private boolean isPartialView() {
        return this.start > 0 || this.end < this.array.length;
    }

    final Object writeReplace() {
        return this.trimmed();
    }

    final Object readResolve() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return this;
    }

    static class AsList
    extends AbstractList<Integer>
    implements Serializable,
    RandomAccess {
        private final ImmutableIntArray parent;

        /*
         * WARNING - void declaration
         */
        private AsList(ImmutableIntArray parent) {
            void var1_1;
            this.parent = var1_1;
        }

        @Override
        public int size() {
            return this.parent.length();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Integer get(int index) {
            void var1_1;
            return this.parent.get((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object target) {
            void var1_1;
            return this.indexOf(var1_1) >= 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Object target) {
            if (target instanceof Integer) {
                void var1_1;
                return this.parent.indexOf((Integer)var1_1);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int lastIndexOf(Object target) {
            if (target instanceof Integer) {
                void var1_1;
                return this.parent.lastIndexOf((Integer)var1_1);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<Integer> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            return this.parent.subArray((int)var1_1, (int)var2_2).asList();
        }

        @Override
        public Spliterator<Integer> spliterator() {
            return this.parent.spliterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            Iterator iterator;
            List<Integer> that;
            if (object instanceof AsList) {
                that = (AsList)object;
                return this.parent.equals(((AsList)that).parent);
            }
            if (!(that instanceof List)) {
                return false;
            }
            that = that;
            if (this.size() != that.size()) {
                return false;
            }
            int i = this.parent.start;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                Object element = iterator.next();
                if (element instanceof Integer && this.parent.array[i++] == (Integer)var3_3) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.parent.hashCode();
        }

        @Override
        public String toString() {
            return this.parent.toString();
        }
    }

    public static final class Builder {
        private int[] array;
        private int count = 0;

        /*
         * WARNING - void declaration
         */
        Builder(int initialCapacity) {
            void var1_1;
            this.array = new int[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        public final Builder add(int value) {
            void var1_1;
            this.ensureRoomFor(1);
            this.array[this.count] = var1_1;
            ++this.count;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAll(int[] values) {
            void var1_1;
            this.ensureRoomFor(values.length);
            System.arraycopy(values, 0, this.array, this.count, values.length);
            this.count += ((void)var1_1).length;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAll(Iterable<Integer> values) {
            Iterator iterator;
            if (values instanceof Collection) {
                return this.addAll((Collection)values);
            }
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Integer value = (Integer)iterator.next();
                this.add(var2_2.intValue());
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAll(Collection<Integer> values) {
            Iterator iterator;
            this.ensureRoomFor(values.size());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Integer value = (Integer)iterator.next();
                this.array[this.count++] = var2_2.intValue();
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAll(IntStream stream) {
            void var1_1;
            Spliterator.OfInt spliterator = stream.spliterator();
            long size = spliterator.getExactSizeIfKnown();
            if (size > 0L) {
                void var3_2;
                this.ensureRoomFor(Ints.saturatedCast((long)var3_2));
            }
            var1_1.forEachRemaining(this::add);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAll(ImmutableIntArray values) {
            void var1_1;
            this.ensureRoomFor(values.length());
            System.arraycopy(values.array, values.start, this.array, this.count, values.length());
            this.count += var1_1.length();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private void ensureRoomFor(int numberToAdd) {
            int newCount = this.count + numberToAdd;
            if (newCount > this.array.length) {
                void var1_1;
                this.array = Arrays.copyOf(this.array, Builder.expandedCapacity(this.array.length, (int)var1_1));
            }
        }

        /*
         * WARNING - void declaration
         */
        private static int expandedCapacity(int oldCapacity, int minCapacity) {
            int n;
            if (minCapacity < 0) {
                throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
            }
            int n2 = oldCapacity;
            int newCapacity = n2 + (n2 >> 1) + 1;
            if (newCapacity < minCapacity) {
                void var1_1;
                newCapacity = Integer.highestOneBit((int)(var1_1 - true)) << 1;
            }
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            return n;
        }

        public final ImmutableIntArray build() {
            if (this.count == 0) {
                return EMPTY;
            }
            return new ImmutableIntArray(this.array, 0, this.count);
        }
    }
}

