/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.DoubleConsumer;
import java.util.stream.DoubleStream;

@ElementTypesAreNonnullByDefault
@Beta
@GwtCompatible
public final class ImmutableDoubleArray
implements Serializable {
    private static final ImmutableDoubleArray EMPTY = new ImmutableDoubleArray(new double[0]);
    private final double[] array;
    private final transient int start;
    private final int end;

    public static ImmutableDoubleArray of() {
        return EMPTY;
    }

    public static ImmutableDoubleArray of(double e0) {
        double d;
        return new ImmutableDoubleArray(new double[]{d});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableDoubleArray of(double e0, double e1) {
        void var2_1;
        double d;
        return new ImmutableDoubleArray(new double[]{d, var2_1});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableDoubleArray of(double e0, double e1, double e2) {
        void var2_2;
        double d;
        return new ImmutableDoubleArray(new double[]{d, var2_2, e2});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableDoubleArray of(double e0, double e1, double e2, double e3) {
        void var2_1;
        double d;
        return new ImmutableDoubleArray(new double[]{d, var2_1, e2, e3});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableDoubleArray of(double e0, double e1, double e2, double e3, double e4) {
        void var2_2;
        double d;
        return new ImmutableDoubleArray(new double[]{d, var2_2, e2, e3, e4});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableDoubleArray of(double e0, double e1, double e2, double e3, double e4, double e5) {
        void var2_2;
        double d;
        return new ImmutableDoubleArray(new double[]{d, var2_2, e2, e3, e4, e5});
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableDoubleArray of(double first, double ... rest) {
        void var3_2;
        void var2_1;
        double d;
        Preconditions.checkArgument(rest.length <= 0x7FFFFFFE, "the total number of elements must fit in an int");
        double[] dArray = new double[rest.length + 1];
        double[] array = dArray;
        dArray[0] = d;
        System.arraycopy(rest, 0, array, 1, ((void)var2_1).length);
        return new ImmutableDoubleArray((double[])var3_2);
    }

    public static ImmutableDoubleArray copyOf(double[] values) {
        double[] dArray;
        if (values.length == 0) {
            return EMPTY;
        }
        return new ImmutableDoubleArray(Arrays.copyOf(dArray, dArray.length));
    }

    public static ImmutableDoubleArray copyOf(Collection<Double> values) {
        Collection<Double> collection;
        if (values.isEmpty()) {
            return EMPTY;
        }
        return new ImmutableDoubleArray(Doubles.toArray(collection));
    }

    public static ImmutableDoubleArray copyOf(Iterable<Double> values) {
        Iterable<Double> iterable;
        if (values instanceof Collection) {
            return ImmutableDoubleArray.copyOf((Collection)values);
        }
        return ImmutableDoubleArray.builder().addAll(iterable).build();
    }

    public static ImmutableDoubleArray copyOf(DoubleStream stream) {
        Object object;
        double[] dArray = stream.toArray();
        Object array = dArray;
        if (dArray.length == 0) {
            return EMPTY;
        }
        return new ImmutableDoubleArray((double[])object);
    }

    public static Builder builder(int initialCapacity) {
        int n;
        Preconditions.checkArgument(initialCapacity >= 0, "Invalid initialCapacity: %s", initialCapacity);
        return new Builder(n);
    }

    public static Builder builder() {
        return new Builder(10);
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableDoubleArray(double[] array) {
        this(array, 0, ((void)var1_1).length);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableDoubleArray(double[] array, int start, int end) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.array = var1_1;
        this.start = var2_2;
        this.end = var3_3;
    }

    public final int length() {
        return this.end - this.start;
    }

    public final boolean isEmpty() {
        return this.end == this.start;
    }

    /*
     * WARNING - void declaration
     */
    public final double get(int index) {
        void var1_1;
        Preconditions.checkElementIndex(index, this.length());
        return this.array[this.start + var1_1];
    }

    public final int indexOf(double target) {
        for (int i = this.start; i < this.end; ++i) {
            if (!ImmutableDoubleArray.areEqual(this.array[i], target)) continue;
            return i - this.start;
        }
        return -1;
    }

    public final int lastIndexOf(double target) {
        for (int i = this.end - 1; i >= this.start; --i) {
            if (!ImmutableDoubleArray.areEqual(this.array[i], target)) continue;
            return i - this.start;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(double target) {
        void var1_1;
        return this.indexOf((double)var1_1) >= 0;
    }

    public final void forEach(DoubleConsumer consumer) {
        Preconditions.checkNotNull(consumer);
        for (int i = this.start; i < this.end; ++i) {
            consumer.accept(this.array[i]);
        }
    }

    public final DoubleStream stream() {
        return Arrays.stream(this.array, this.start, this.end);
    }

    public final double[] toArray() {
        return Arrays.copyOfRange(this.array, this.start, this.end);
    }

    /*
     * WARNING - void declaration
     */
    public final ImmutableDoubleArray subArray(int startIndex, int endIndex) {
        void var2_2;
        void var1_1;
        Preconditions.checkPositionIndexes(startIndex, endIndex, this.length());
        if (startIndex == endIndex) {
            return EMPTY;
        }
        return new ImmutableDoubleArray(this.array, this.start + var1_1, this.start + var2_2);
    }

    private Spliterator.OfDouble spliterator() {
        return Spliterators.spliterator(this.array, this.start, this.end, 1040);
    }

    public final List<Double> asList() {
        return new AsList(this);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImmutableDoubleArray)) {
            return false;
        }
        ImmutableDoubleArray that = (ImmutableDoubleArray)object;
        if (this.length() != that.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (ImmutableDoubleArray.areEqual(this.get(i), that.get(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean areEqual(double a, double b) {
        void var2_1;
        return Double.doubleToLongBits(a) == Double.doubleToLongBits((double)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int hash = 1;
        for (int i = this.start; i < this.end; ++i) {
            hash *= 31;
            hash += Doubles.hashCode(this.array[i]);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder(this.length() * 5);
        builder.append('[').append(this.array[this.start]);
        for (int i = this.start + 1; i < this.end; ++i) {
            builder.append(", ").append(this.array[i]);
        }
        builder.append(']');
        return var1_1.toString();
    }

    public final ImmutableDoubleArray trimmed() {
        if (this.isPartialView()) {
            return new ImmutableDoubleArray(this.toArray());
        }
        return this;
    }

    private boolean isPartialView() {
        return this.start > 0 || this.end < this.array.length;
    }

    final Object writeReplace() {
        return this.trimmed();
    }

    final Object readResolve() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$600(double x0, double x1) {
        void var2_1;
        return ImmutableDoubleArray.areEqual(x0, (double)var2_1);
    }

    static class AsList
    extends AbstractList<Double>
    implements Serializable,
    RandomAccess {
        private final ImmutableDoubleArray parent;

        /*
         * WARNING - void declaration
         */
        private AsList(ImmutableDoubleArray parent) {
            void var1_1;
            this.parent = var1_1;
        }

        @Override
        public int size() {
            return this.parent.length();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Double get(int index) {
            void var1_1;
            return this.parent.get((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object target) {
            void var1_1;
            return this.indexOf(var1_1) >= 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Object target) {
            if (target instanceof Double) {
                void var1_1;
                return this.parent.indexOf((Double)var1_1);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int lastIndexOf(Object target) {
            if (target instanceof Double) {
                void var1_1;
                return this.parent.lastIndexOf((Double)var1_1);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<Double> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            return this.parent.subArray((int)var1_1, (int)var2_2).asList();
        }

        @Override
        public Spliterator<Double> spliterator() {
            return this.parent.spliterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            Iterator iterator;
            List<Double> that;
            if (object instanceof AsList) {
                that = (AsList)object;
                return this.parent.equals(((AsList)that).parent);
            }
            if (!(that instanceof List)) {
                return false;
            }
            that = that;
            if (this.size() != that.size()) {
                return false;
            }
            int i = this.parent.start;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                Object element = iterator.next();
                if (element instanceof Double && ImmutableDoubleArray.access$600(this.parent.array[i++], (Double)var3_3)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.parent.hashCode();
        }

        @Override
        public String toString() {
            return this.parent.toString();
        }
    }

    public static final class Builder {
        private double[] array;
        private int count = 0;

        /*
         * WARNING - void declaration
         */
        Builder(int initialCapacity) {
            void var1_1;
            this.array = new double[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        public final Builder add(double value) {
            void var1_1;
            this.ensureRoomFor(1);
            this.array[this.count] = var1_1;
            ++this.count;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAll(double[] values) {
            void var1_1;
            this.ensureRoomFor(values.length);
            System.arraycopy(values, 0, this.array, this.count, values.length);
            this.count += ((void)var1_1).length;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAll(Iterable<Double> values) {
            Iterator iterator;
            if (values instanceof Collection) {
                return this.addAll((Collection)values);
            }
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Double value = (Double)iterator.next();
                this.add(var2_2.doubleValue());
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAll(Collection<Double> values) {
            Iterator iterator;
            this.ensureRoomFor(values.size());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Double value = (Double)iterator.next();
                this.array[this.count++] = var2_2.doubleValue();
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAll(DoubleStream stream) {
            void var1_1;
            Spliterator.OfDouble spliterator = stream.spliterator();
            long size = spliterator.getExactSizeIfKnown();
            if (size > 0L) {
                void var3_2;
                this.ensureRoomFor(Ints.saturatedCast((long)var3_2));
            }
            var1_1.forEachRemaining(this::add);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addAll(ImmutableDoubleArray values) {
            void var1_1;
            this.ensureRoomFor(values.length());
            System.arraycopy(values.array, values.start, this.array, this.count, values.length());
            this.count += var1_1.length();
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private void ensureRoomFor(int numberToAdd) {
            int newCount = this.count + numberToAdd;
            if (newCount > this.array.length) {
                void var1_1;
                this.array = Arrays.copyOf(this.array, Builder.expandedCapacity(this.array.length, (int)var1_1));
            }
        }

        /*
         * WARNING - void declaration
         */
        private static int expandedCapacity(int oldCapacity, int minCapacity) {
            int n;
            if (minCapacity < 0) {
                throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
            }
            int n2 = oldCapacity;
            int newCapacity = n2 + (n2 >> 1) + 1;
            if (newCapacity < minCapacity) {
                void var1_1;
                newCapacity = Integer.highestOneBit((int)(var1_1 - true)) << 1;
            }
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            return n;
        }

        public final ImmutableDoubleArray build() {
            if (this.count == 0) {
                return EMPTY;
            }
            return new ImmutableDoubleArray(this.array, 0, this.count);
        }
    }
}

