/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.FloatsMethodsForWeb;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Floats
extends FloatsMethodsForWeb {
    public static final int BYTES = 4;

    private Floats() {
    }

    public static int hashCode(float value) {
        return Float.valueOf(value).hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(float a, float b) {
        void var1_1;
        return Float.compare(a, (float)var1_1);
    }

    public static boolean isFinite(float value) {
        float f;
        return Float.NEGATIVE_INFINITY < value && f < Float.POSITIVE_INFINITY;
    }

    public static boolean contains(float[] array, float target) {
        float[] fArray = array;
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            float f = fArray[i];
            if (f != target) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(float[] array, float target) {
        float[] fArray;
        void var1_1;
        return Floats.indexOf(array, (float)var1_1, 0, fArray.length);
    }

    private static int indexOf(float[] array, float target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float[] array, float[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(float[] array, float target) {
        float[] fArray;
        void var1_1;
        return Floats.lastIndexOf(array, (float)var1_1, 0, fArray.length);
    }

    private static int lastIndexOf(float[] array, float target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static float min(float ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        float min = array[0];
        for (int i = 1; i < array.length; ++i) {
            min = Math.min(min, array[i]);
        }
        return (float)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static float max(float ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        float max = array[0];
        for (int i = 1; i < array.length; ++i) {
            max = Math.max(max, array[i]);
        }
        return (float)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static float constrainToRange(float value, float min, float max) {
        void var2_2;
        void var1_1;
        if (min <= max) {
            float f;
            return Math.min(Math.max(f, min), max);
        }
        throw new IllegalArgumentException(Strings.lenientFormat("min (%s) must be less than or equal to max (%s)", Float.valueOf((float)var1_1), Float.valueOf((float)var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    public static float[] concat(float[] ... arrays) {
        float[][] fArray;
        int length = 0;
        float[][] fArray2 = arrays;
        int n = arrays.length;
        for (int i = 0; i < n; ++i) {
            float[] array = fArray2[i];
            length += array.length;
        }
        float[] result = new float[length];
        int pos = 0;
        float[][] fArray3 = fArray;
        int n2 = fArray.length;
        for (int i = 0; i < n2; ++i) {
            void var1_3;
            float[] array = fArray3[i];
            System.arraycopy(array, 0, result, pos, array.length);
            pos += ((void)var1_3).length;
        }
        return fArray2;
    }

    @Beta
    public static Converter<String, Float> stringConverter() {
        return FloatConverter.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] ensureCapacity(float[] array, int minLength, int padding) {
        float[] fArray;
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        if (array.length < minLength) {
            void var2_2;
            void var1_1;
            return Arrays.copyOf(array, (int)(var1_1 + var2_2));
        }
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    public static String join(String separator, float ... array) {
        void var2_2;
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 12);
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(array[i]);
        }
        return var2_2.toString();
    }

    public static Comparator<float[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(float[] array) {
        float[] fArray;
        Preconditions.checkNotNull(array);
        Floats.sortDescending(array, 0, fArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void sortDescending(float[] array, int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        float[] fArray;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        Arrays.sort(array, fromIndex, toIndex);
        Floats.reverse(fArray, (int)var1_1, (int)var2_2);
    }

    public static void reverse(float[] array) {
        float[] fArray;
        Preconditions.checkNotNull(array);
        Floats.reverse(array, 0, fArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(float[] array, int fromIndex, int toIndex) {
        void i;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (int j = toIndex - 1; i < j; ++i, --j) {
            void var3_3;
            float tmp = array[i];
            array[i] = array[j];
            array[j] = var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static float[] toArray(Collection<? extends Number> collection) {
        void var2_2;
        if (collection instanceof FloatArrayAsList) {
            return ((FloatArrayAsList)collection).toFloatArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        float[] array = new float[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ((Number)Preconditions.checkNotNull(boxedArray[i])).floatValue();
        }
        return var2_2;
    }

    public static List<Float> asList(float ... backingArray) {
        float[] fArray;
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new FloatArrayAsList(fArray);
    }

    @Beta
    @GwtIncompatible
    public static Float tryParse(String string) {
        if (Doubles.FLOATING_POINT_PATTERN.matcher(string).matches()) {
            try {
                String string2;
                return Float.valueOf(Float.parseFloat(string2));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$000(float[] x0, float x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Floats.indexOf(x0, (float)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$100(float[] x0, float x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Floats.lastIndexOf(x0, (float)var1_1, (int)var2_2, (int)var3_3);
    }

    @GwtCompatible
    private static class FloatArrayAsList
    extends AbstractList<Float>
    implements Serializable,
    RandomAccess {
        final float[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        FloatArrayAsList(float[] array) {
            this(array, 0, ((void)var1_1).length);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        FloatArrayAsList(float[] array, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.array = var1_1;
            this.start = var2_2;
            this.end = var3_3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Float get(int index) {
            void var1_1;
            Preconditions.checkElementIndex(index, this.size());
            return Float.valueOf(this.array[this.start + var1_1]);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object target) {
            void var1_1;
            return target instanceof Float && Floats.access$000(this.array, ((Float)var1_1).floatValue(), this.start, this.end) != -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Object target) {
            int i;
            if (target instanceof Float && (i = Floats.access$000(this.array, ((Float)target).floatValue(), this.start, this.end)) >= 0) {
                void var1_2;
                return (int)(var1_2 - this.start);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int lastIndexOf(Object target) {
            int i;
            if (target instanceof Float && (i = Floats.access$100(this.array, ((Float)target).floatValue(), this.start, this.end)) >= 0) {
                void var1_2;
                return (int)(var1_2 - this.start);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Float set(int index, Float element) {
            void var3_3;
            void var2_2;
            Preconditions.checkElementIndex(index, this.size());
            float oldValue = this.array[this.start + index];
            this.array[this.start + var1_1] = ((Float)Preconditions.checkNotNull(var2_2)).floatValue();
            return Float.valueOf((float)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<Float> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            void var3_3;
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, (int)var3_3);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new FloatArrayAsList(this.array, this.start + var1_1, this.start + var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            void var1_1;
            if (object == this) {
                return true;
            }
            if (object instanceof FloatArrayAsList) {
                FloatArrayAsList that = (FloatArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int hashCode() {
            void var1_1;
            int result = 1;
            for (int i = this.start; i < this.end; ++i) {
                result = result * 31 + Floats.hashCode(this.array[i]);
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String toString() {
            void var1_1;
            StringBuilder builder = new StringBuilder(this.size() * 12);
            builder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append(", ").append(this.array[i]);
            }
            return var1_1.append(']').toString();
        }

        float[] toFloatArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<float[]>
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(float[] left, float[] right) {
            void var2_2;
            void var1_1;
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Float.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return ((void)var1_1).length - ((void)var2_2).length;
        }

        public final String toString() {
            return "Floats.lexicographicalComparator()";
        }
    }

    private static final class FloatConverter
    extends Converter<String, Float>
    implements Serializable {
        static final FloatConverter INSTANCE = new FloatConverter();
        private static final long serialVersionUID = 1L;

        private FloatConverter() {
        }

        @Override
        protected final Float doForward(String value) {
            return Float.valueOf(value);
        }

        @Override
        protected final String doBackward(Float value) {
            return value.toString();
        }

        public final String toString() {
            return "Floats.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

