/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.DoublesMethodsForWeb;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.regex.Pattern;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Doubles
extends DoublesMethodsForWeb {
    public static final int BYTES = 8;
    @GwtIncompatible
    static final Pattern FLOATING_POINT_PATTERN = Doubles.fpPattern();

    private Doubles() {
    }

    public static int hashCode(double value) {
        return Double.valueOf(value).hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(double a, double b) {
        void var2_1;
        return Double.compare(a, (double)var2_1);
    }

    public static boolean isFinite(double value) {
        double d;
        return Double.NEGATIVE_INFINITY < value && d < Double.POSITIVE_INFINITY;
    }

    public static boolean contains(double[] array, double target) {
        double[] dArray = array;
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            if (d != target) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(double[] array, double target) {
        double[] dArray;
        void var1_1;
        return Doubles.indexOf(array, (double)var1_1, 0, dArray.length);
    }

    private static int indexOf(double[] array, double target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(double[] array, double target) {
        double[] dArray;
        void var1_1;
        return Doubles.lastIndexOf(array, (double)var1_1, 0, dArray.length);
    }

    private static int lastIndexOf(double[] array, double target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static double min(double ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        double min = array[0];
        for (int i = 1; i < array.length; ++i) {
            min = Math.min(min, array[i]);
        }
        return (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static double max(double ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        double max = array[0];
        for (int i = 1; i < array.length; ++i) {
            max = Math.max(max, array[i]);
        }
        return (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static double constrainToRange(double value, double min, double max) {
        void var2_2;
        if (min <= max) {
            double d;
            return Math.min(Math.max(d, min), max);
        }
        throw new IllegalArgumentException(Strings.lenientFormat("min (%s) must be less than or equal to max (%s)", (double)var2_2, max));
    }

    /*
     * WARNING - void declaration
     */
    public static double[] concat(double[] ... arrays) {
        double[][] dArray;
        int length = 0;
        double[][] dArray2 = arrays;
        int n = arrays.length;
        for (int i = 0; i < n; ++i) {
            double[] array = dArray2[i];
            length += array.length;
        }
        double[] result = new double[length];
        int pos = 0;
        double[][] dArray3 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            void var1_3;
            double[] array = dArray3[i];
            System.arraycopy(array, 0, result, pos, array.length);
            pos += ((void)var1_3).length;
        }
        return dArray2;
    }

    @Beta
    public static Converter<String, Double> stringConverter() {
        return DoubleConverter.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public static double[] ensureCapacity(double[] array, int minLength, int padding) {
        double[] dArray;
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        if (array.length < minLength) {
            void var2_2;
            void var1_1;
            return Arrays.copyOf(array, (int)(var1_1 + var2_2));
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    public static String join(String separator, double ... array) {
        void var2_2;
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 12);
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(array[i]);
        }
        return var2_2.toString();
    }

    public static Comparator<double[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(double[] array) {
        double[] dArray;
        Preconditions.checkNotNull(array);
        Doubles.sortDescending(array, 0, dArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void sortDescending(double[] array, int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        double[] dArray;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        Arrays.sort(array, fromIndex, toIndex);
        Doubles.reverse(dArray, (int)var1_1, (int)var2_2);
    }

    public static void reverse(double[] array) {
        double[] dArray;
        Preconditions.checkNotNull(array);
        Doubles.reverse(array, 0, dArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(double[] array, int fromIndex, int toIndex) {
        void i;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (int j = toIndex - 1; i < j; ++i, --j) {
            double tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static double[] toArray(Collection<? extends Number> collection) {
        void var2_2;
        if (collection instanceof DoubleArrayAsList) {
            return ((DoubleArrayAsList)collection).toDoubleArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        double[] array = new double[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ((Number)Preconditions.checkNotNull(boxedArray[i])).doubleValue();
        }
        return var2_2;
    }

    public static List<Double> asList(double ... backingArray) {
        double[] dArray;
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new DoubleArrayAsList(dArray);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private static Pattern fpPattern() {
        void var1_1;
        String string = "(?:\\d+#(?:\\.\\d*#)?|\\.\\d+#)";
        String completeDec = String.valueOf("(?:\\d+#(?:\\.\\d*#)?|\\.\\d+#)").concat("(?:[eE][+-]?\\d+#)?[fFdD]?");
        String hex = "(?:[0-9a-fA-F]+#(?:\\.[0-9a-fA-F]*#)?|\\.[0-9a-fA-F]+#)";
        String completeHex = new StringBuilder(25 + String.valueOf(hex).length()).append("0[xX]").append(hex).append("[pP][+-]?\\d+#[fFdD]?").toString();
        string = new StringBuilder(23 + String.valueOf(completeDec).length() + String.valueOf(completeHex).length()).append("[+-]?(?:NaN|Infinity|").append(string).append("|").append((String)var1_1).append(")").toString();
        string = string.replace("#", "+");
        return Pattern.compile(string);
    }

    @Beta
    @GwtIncompatible
    public static Double tryParse(String string) {
        if (FLOATING_POINT_PATTERN.matcher(string).matches()) {
            try {
                String string2;
                return Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$000(double[] x0, double x1, int x2, int x3) {
        void var3_2;
        void var1_1;
        return Doubles.indexOf(x0, (double)var1_1, (int)var3_2, x3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$100(double[] x0, double x1, int x2, int x3) {
        void var3_2;
        void var1_1;
        return Doubles.lastIndexOf(x0, (double)var1_1, (int)var3_2, x3);
    }

    @GwtCompatible
    private static class DoubleArrayAsList
    extends AbstractList<Double>
    implements Serializable,
    RandomAccess {
        final double[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        DoubleArrayAsList(double[] array) {
            this(array, 0, ((void)var1_1).length);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        DoubleArrayAsList(double[] array, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.array = var1_1;
            this.start = var2_2;
            this.end = var3_3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Double get(int index) {
            void var1_1;
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + var1_1];
        }

        public Spliterator.OfDouble spliterator() {
            return Spliterators.spliterator(this.array, this.start, this.end, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object target) {
            void var1_1;
            return target instanceof Double && Doubles.access$000(this.array, (Double)var1_1, this.start, this.end) != -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Object target) {
            int i;
            if (target instanceof Double && (i = Doubles.access$000(this.array, (Double)target, this.start, this.end)) >= 0) {
                void var1_2;
                return (int)(var1_2 - this.start);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int lastIndexOf(Object target) {
            int i;
            if (target instanceof Double && (i = Doubles.access$100(this.array, (Double)target, this.start, this.end)) >= 0) {
                void var1_2;
                return (int)(var1_2 - this.start);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Double set(int index, Double element) {
            void var3_3;
            void var2_2;
            Preconditions.checkElementIndex(index, this.size());
            double oldValue = this.array[this.start + index];
            this.array[this.start + var1_1] = (Double)Preconditions.checkNotNull(var2_2);
            return (double)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<Double> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            void var3_3;
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, (int)var3_3);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new DoubleArrayAsList(this.array, this.start + var1_1, this.start + var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            void var1_1;
            if (object == this) {
                return true;
            }
            if (object instanceof DoubleArrayAsList) {
                DoubleArrayAsList that = (DoubleArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int hashCode() {
            void var1_1;
            int result = 1;
            for (int i = this.start; i < this.end; ++i) {
                result = result * 31 + Doubles.hashCode(this.array[i]);
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String toString() {
            void var1_1;
            StringBuilder builder = new StringBuilder(this.size() * 12);
            builder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append(", ").append(this.array[i]);
            }
            return var1_1.append(']').toString();
        }

        double[] toDoubleArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<double[]>
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(double[] left, double[] right) {
            void var2_2;
            void var1_1;
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Double.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return ((void)var1_1).length - ((void)var2_2).length;
        }

        public final String toString() {
            return "Doubles.lexicographicalComparator()";
        }
    }

    private static final class DoubleConverter
    extends Converter<String, Double>
    implements Serializable {
        static final DoubleConverter INSTANCE = new DoubleConverter();
        private static final long serialVersionUID = 1L;

        private DoubleConverter() {
        }

        @Override
        protected final Double doForward(String value) {
            return Double.valueOf(value);
        }

        @Override
        protected final String doBackward(Double value) {
            return value.toString();
        }

        public final String toString() {
            return "Doubles.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

