/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Chars {
    public static final int BYTES = 2;

    private Chars() {
    }

    public static int hashCode(char value) {
        return value;
    }

    /*
     * WARNING - void declaration
     */
    public static char checkedCast(long value) {
        void var2_1;
        long l;
        char result = (char)value;
        Preconditions.checkArgument((long)result == value, "Out of range: %s", l);
        return (char)var2_1;
    }

    public static char saturatedCast(long value) {
        long l;
        if (value > 65535L) {
            return '\uffff';
        }
        if (value < 0L) {
            return '\u0000';
        }
        return (char)l;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(char a, char b) {
        void var1_1;
        return a - var1_1;
    }

    public static boolean contains(char[] array, char target) {
        char[] cArray = array;
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c != target) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(char[] array, char target) {
        char[] cArray;
        void var1_1;
        return Chars.indexOf(array, (char)var1_1, 0, cArray.length);
    }

    private static int indexOf(char[] array, char target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] array, char[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(char[] array, char target) {
        char[] cArray;
        void var1_1;
        return Chars.lastIndexOf(array, (char)var1_1, 0, cArray.length);
    }

    private static int lastIndexOf(char[] array, char target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static char min(char ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        char min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
        }
        return (char)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static char max(char ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        char max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return (char)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static char constrainToRange(char value, char min, char max) {
        void var2_2;
        Preconditions.checkArgument(min <= max, "min (%s) must be less than or equal to max (%s)", min, max);
        if (value < min) {
            void var1_1;
            return (char)var1_1;
        }
        if (value < max) {
            char c;
            return c;
        }
        return (char)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static char[] concat(char[] ... arrays) {
        char[][] cArray;
        int length = 0;
        char[][] cArray2 = arrays;
        int n = arrays.length;
        for (int i = 0; i < n; ++i) {
            char[] array = cArray2[i];
            length += array.length;
        }
        char[] result = new char[length];
        int pos = 0;
        char[][] cArray3 = cArray;
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            void var1_3;
            char[] array = cArray3[i];
            System.arraycopy(array, 0, result, pos, array.length);
            pos += ((void)var1_3).length;
        }
        return cArray2;
    }

    @GwtIncompatible
    public static byte[] toByteArray(char value) {
        char c;
        return new byte[]{(byte)(value >> 8), (byte)c};
    }

    @GwtIncompatible
    public static char fromByteArray(byte[] bytes) {
        byte[] byArray;
        Preconditions.checkArgument(bytes.length >= 2, "array too small: %s < %s", bytes.length, 2);
        return Chars.fromBytes(bytes[0], byArray[1]);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static char fromBytes(byte b1, byte b2) {
        void var1_1;
        return (char)(b1 << 8 | var1_1 & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] ensureCapacity(char[] array, int minLength, int padding) {
        char[] cArray;
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        if (array.length < minLength) {
            void var2_2;
            void var1_1;
            return Arrays.copyOf(array, (int)(var1_1 + var2_2));
        }
        return cArray;
    }

    /*
     * WARNING - void declaration
     */
    public static String join(String separator, char ... array) {
        void var3_3;
        Preconditions.checkNotNull(separator);
        int len = array.length;
        if (len == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(len + separator.length() * (len - 1));
        builder.append(array[0]);
        for (int i = 1; i < len; ++i) {
            builder.append(separator).append(array[i]);
        }
        return var3_3.toString();
    }

    public static Comparator<char[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public static char[] toArray(Collection<Character> collection) {
        void var2_2;
        if (collection instanceof CharArrayAsList) {
            return ((CharArrayAsList)collection).toCharArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        char[] array = new char[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ((Character)Preconditions.checkNotNull(boxedArray[i])).charValue();
        }
        return var2_2;
    }

    public static void sortDescending(char[] array) {
        char[] cArray;
        Preconditions.checkNotNull(array);
        Chars.sortDescending(array, 0, cArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void sortDescending(char[] array, int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        char[] cArray;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        Arrays.sort(array, fromIndex, toIndex);
        Chars.reverse(cArray, (int)var1_1, (int)var2_2);
    }

    public static void reverse(char[] array) {
        char[] cArray;
        Preconditions.checkNotNull(array);
        Chars.reverse(array, 0, cArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(char[] array, int fromIndex, int toIndex) {
        void i;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (int j = toIndex - 1; i < j; ++i, --j) {
            void var3_3;
            char tmp = array[i];
            array[i] = array[j];
            array[j] = var3_3;
        }
    }

    public static List<Character> asList(char ... backingArray) {
        char[] cArray;
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new CharArrayAsList(cArray);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$000(char[] x0, char x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Chars.indexOf(x0, (char)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$100(char[] x0, char x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Chars.lastIndexOf(x0, (char)var1_1, (int)var2_2, (int)var3_3);
    }

    @GwtCompatible
    private static class CharArrayAsList
    extends AbstractList<Character>
    implements Serializable,
    RandomAccess {
        final char[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        CharArrayAsList(char[] array) {
            this(array, 0, ((void)var1_1).length);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        CharArrayAsList(char[] array, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.array = var1_1;
            this.start = var2_2;
            this.end = var3_3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Character get(int index) {
            void var1_1;
            Preconditions.checkElementIndex(index, this.size());
            return Character.valueOf(this.array[this.start + var1_1]);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object target) {
            void var1_1;
            return target instanceof Character && Chars.access$000(this.array, ((Character)var1_1).charValue(), this.start, this.end) != -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Object target) {
            int i;
            if (target instanceof Character && (i = Chars.access$000(this.array, ((Character)target).charValue(), this.start, this.end)) >= 0) {
                void var1_2;
                return (int)(var1_2 - this.start);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int lastIndexOf(Object target) {
            int i;
            if (target instanceof Character && (i = Chars.access$100(this.array, ((Character)target).charValue(), this.start, this.end)) >= 0) {
                void var1_2;
                return (int)(var1_2 - this.start);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Character set(int index, Character element) {
            void var3_3;
            void var2_2;
            Preconditions.checkElementIndex(index, this.size());
            char oldValue = this.array[this.start + index];
            this.array[this.start + var1_1] = ((Character)Preconditions.checkNotNull(var2_2)).charValue();
            return Character.valueOf((char)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<Character> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            void var3_3;
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, (int)var3_3);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new CharArrayAsList(this.array, this.start + var1_1, this.start + var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            void var1_1;
            if (object == this) {
                return true;
            }
            if (object instanceof CharArrayAsList) {
                CharArrayAsList that = (CharArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int hashCode() {
            void var1_1;
            int result = 1;
            for (int i = this.start; i < this.end; ++i) {
                result = result * 31 + Chars.hashCode(this.array[i]);
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String toString() {
            void var1_1;
            StringBuilder builder = new StringBuilder(this.size() * 3);
            builder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append(", ").append(this.array[i]);
            }
            return var1_1.append(']').toString();
        }

        char[] toCharArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<char[]>
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(char[] left, char[] right) {
            void var2_2;
            void var1_1;
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Chars.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return ((void)var1_1).length - ((void)var2_2).length;
        }

        public final String toString() {
            return "Chars.lexicographicalComparator()";
        }
    }
}

