/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Bytes {
    private Bytes() {
    }

    public static int hashCode(byte value) {
        return value;
    }

    public static boolean contains(byte[] array, byte target) {
        byte[] byArray = array;
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            if (by != target) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(byte[] array, byte target) {
        byte[] byArray;
        void var1_1;
        return Bytes.indexOf(array, (byte)var1_1, 0, byArray.length);
    }

    private static int indexOf(byte[] array, byte target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(byte[] array, byte target) {
        byte[] byArray;
        void var1_1;
        return Bytes.lastIndexOf(array, (byte)var1_1, 0, byArray.length);
    }

    private static int lastIndexOf(byte[] array, byte target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] concat(byte[] ... arrays) {
        byte[][] byArray;
        int length = 0;
        byte[][] byArray2 = arrays;
        int n = arrays.length;
        for (int i = 0; i < n; ++i) {
            byte[] array = byArray2[i];
            length += array.length;
        }
        byte[] result = new byte[length];
        int pos = 0;
        byte[][] byArray3 = byArray;
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            void var1_3;
            byte[] array = byArray3[i];
            System.arraycopy(array, 0, result, pos, array.length);
            pos += ((void)var1_3).length;
        }
        return byArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] ensureCapacity(byte[] array, int minLength, int padding) {
        byte[] byArray;
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        if (array.length < minLength) {
            void var2_2;
            void var1_1;
            return Arrays.copyOf(array, (int)(var1_1 + var2_2));
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toArray(Collection<? extends Number> collection) {
        void var2_2;
        if (collection instanceof ByteArrayAsList) {
            return ((ByteArrayAsList)collection).toByteArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        byte[] array = new byte[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ((Number)Preconditions.checkNotNull(boxedArray[i])).byteValue();
        }
        return var2_2;
    }

    public static List<Byte> asList(byte ... backingArray) {
        byte[] byArray;
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new ByteArrayAsList(byArray);
    }

    public static void reverse(byte[] array) {
        byte[] byArray;
        Preconditions.checkNotNull(array);
        Bytes.reverse(array, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(byte[] array, int fromIndex, int toIndex) {
        void i;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (int j = toIndex - 1; i < j; ++i, --j) {
            void var3_3;
            byte tmp = array[i];
            array[i] = array[j];
            array[j] = var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$000(byte[] x0, byte x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Bytes.indexOf(x0, (byte)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$100(byte[] x0, byte x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Bytes.lastIndexOf(x0, (byte)var1_1, (int)var2_2, (int)var3_3);
    }

    @GwtCompatible
    private static class ByteArrayAsList
    extends AbstractList<Byte>
    implements Serializable,
    RandomAccess {
        final byte[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        ByteArrayAsList(byte[] array) {
            this(array, 0, ((void)var1_1).length);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        ByteArrayAsList(byte[] array, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.array = var1_1;
            this.start = var2_2;
            this.end = var3_3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Byte get(int index) {
            void var1_1;
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + var1_1];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object target) {
            void var1_1;
            return target instanceof Byte && Bytes.access$000(this.array, (Byte)var1_1, this.start, this.end) != -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Object target) {
            int i;
            if (target instanceof Byte && (i = Bytes.access$000(this.array, (Byte)target, this.start, this.end)) >= 0) {
                void var1_2;
                return (int)(var1_2 - this.start);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int lastIndexOf(Object target) {
            int i;
            if (target instanceof Byte && (i = Bytes.access$100(this.array, (Byte)target, this.start, this.end)) >= 0) {
                void var1_2;
                return (int)(var1_2 - this.start);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Byte set(int index, Byte element) {
            void var3_3;
            void var2_2;
            Preconditions.checkElementIndex(index, this.size());
            byte oldValue = this.array[this.start + index];
            this.array[this.start + var1_1] = (Byte)Preconditions.checkNotNull(var2_2);
            return (byte)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<Byte> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            void var3_3;
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, (int)var3_3);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new ByteArrayAsList(this.array, this.start + var1_1, this.start + var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            void var1_1;
            if (object == this) {
                return true;
            }
            if (object instanceof ByteArrayAsList) {
                ByteArrayAsList that = (ByteArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int hashCode() {
            void var1_1;
            int result = 1;
            for (int i = this.start; i < this.end; ++i) {
                result = result * 31 + Bytes.hashCode(this.array[i]);
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String toString() {
            void var1_1;
            StringBuilder builder = new StringBuilder(this.size() * 5);
            builder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append(", ").append(this.array[i]);
            }
            return var1_1.append(']').toString();
        }

        byte[] toByteArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }
}

