/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Booleans {
    private Booleans() {
    }

    @Beta
    public static Comparator<Boolean> trueFirst() {
        return BooleanComparator.TRUE_FIRST;
    }

    @Beta
    public static Comparator<Boolean> falseFirst() {
        return BooleanComparator.FALSE_FIRST;
    }

    public static int hashCode(boolean value) {
        if (value) {
            return 1231;
        }
        return 1237;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(boolean a, boolean b) {
        boolean bl;
        void var1_1;
        if (a == var1_1) {
            return 0;
        }
        if (bl) {
            return 1;
        }
        return -1;
    }

    public static boolean contains(boolean[] array, boolean target) {
        boolean[] blArray = array;
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            boolean bl = blArray[i];
            if (bl != target) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(boolean[] array, boolean target) {
        boolean[] blArray;
        void var1_1;
        return Booleans.indexOf(array, (boolean)var1_1, 0, blArray.length);
    }

    private static int indexOf(boolean[] array, boolean target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(boolean[] array, boolean[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(boolean[] array, boolean target) {
        boolean[] blArray;
        void var1_1;
        return Booleans.lastIndexOf(array, (boolean)var1_1, 0, blArray.length);
    }

    private static int lastIndexOf(boolean[] array, boolean target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] concat(boolean[] ... arrays) {
        boolean[][] blArray;
        int length = 0;
        boolean[][] blArray2 = arrays;
        int n = arrays.length;
        for (int i = 0; i < n; ++i) {
            boolean[] array = blArray2[i];
            length += array.length;
        }
        boolean[] result = new boolean[length];
        int pos = 0;
        boolean[][] blArray3 = blArray;
        int n2 = blArray.length;
        for (int i = 0; i < n2; ++i) {
            void var1_3;
            boolean[] array = blArray3[i];
            System.arraycopy(array, 0, result, pos, array.length);
            pos += ((void)var1_3).length;
        }
        return blArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] ensureCapacity(boolean[] array, int minLength, int padding) {
        boolean[] blArray;
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        if (array.length < minLength) {
            void var2_2;
            void var1_1;
            return Arrays.copyOf(array, (int)(var1_1 + var2_2));
        }
        return blArray;
    }

    /*
     * WARNING - void declaration
     */
    public static String join(String separator, boolean ... array) {
        void var2_2;
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 7);
        builder.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(array[i]);
        }
        return var2_2.toString();
    }

    public static Comparator<boolean[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] toArray(Collection<Boolean> collection) {
        void var2_2;
        if (collection instanceof BooleanArrayAsList) {
            return ((BooleanArrayAsList)collection).toBooleanArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        boolean[] array = new boolean[len];
        for (int i = 0; i < len; ++i) {
            array[i] = (Boolean)Preconditions.checkNotNull(boxedArray[i]);
        }
        return var2_2;
    }

    public static List<Boolean> asList(boolean ... backingArray) {
        boolean[] blArray;
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new BooleanArrayAsList(blArray);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static int countTrue(boolean ... values) {
        void var1_1;
        boolean[] blArray;
        int count = 0;
        for (boolean bl : blArray) {
            if (!bl) continue;
            ++count;
        }
        return (int)var1_1;
    }

    public static void reverse(boolean[] array) {
        boolean[] blArray;
        Preconditions.checkNotNull(array);
        Booleans.reverse(array, 0, blArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(boolean[] array, int fromIndex, int toIndex) {
        void i;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (int j = toIndex - 1; i < j; ++i, --j) {
            void var3_3;
            boolean tmp = array[i];
            array[i] = array[j];
            array[j] = var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$000(boolean[] x0, boolean x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Booleans.indexOf(x0, (boolean)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$100(boolean[] x0, boolean x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Booleans.lastIndexOf(x0, (boolean)var1_1, (int)var2_2, (int)var3_3);
    }

    @GwtCompatible
    private static class BooleanArrayAsList
    extends AbstractList<Boolean>
    implements Serializable,
    RandomAccess {
        final boolean[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        BooleanArrayAsList(boolean[] array) {
            this(array, 0, ((void)var1_1).length);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        BooleanArrayAsList(boolean[] array, int start, int end) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.array = var1_1;
            this.start = var2_2;
            this.end = var3_3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Boolean get(int index) {
            void var1_1;
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + var1_1];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object target) {
            void var1_1;
            return target instanceof Boolean && Booleans.access$000(this.array, (Boolean)var1_1, this.start, this.end) != -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Object target) {
            int i;
            if (target instanceof Boolean && (i = Booleans.access$000(this.array, (Boolean)target, this.start, this.end)) >= 0) {
                void var1_2;
                return (int)(var1_2 - this.start);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int lastIndexOf(Object target) {
            int i;
            if (target instanceof Boolean && (i = Booleans.access$100(this.array, (Boolean)target, this.start, this.end)) >= 0) {
                void var1_2;
                return (int)(var1_2 - this.start);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Boolean set(int index, Boolean element) {
            void var3_3;
            void var2_2;
            Preconditions.checkElementIndex(index, this.size());
            boolean oldValue = this.array[this.start + index];
            this.array[this.start + var1_1] = (Boolean)Preconditions.checkNotNull(var2_2);
            return (boolean)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<Boolean> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            void var3_3;
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, (int)var3_3);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new BooleanArrayAsList(this.array, this.start + var1_1, this.start + var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            void var1_1;
            if (object == this) {
                return true;
            }
            if (object instanceof BooleanArrayAsList) {
                BooleanArrayAsList that = (BooleanArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int hashCode() {
            void var1_1;
            int result = 1;
            for (int i = this.start; i < this.end; ++i) {
                result = result * 31 + Booleans.hashCode(this.array[i]);
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String toString() {
            void var1_1;
            StringBuilder builder = new StringBuilder(this.size() * 7);
            builder.append(this.array[this.start] ? "[true" : "[false");
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append(this.array[i] ? ", true" : ", false");
            }
            return var1_1.append(']').toString();
        }

        boolean[] toBooleanArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<boolean[]>
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(boolean[] left, boolean[] right) {
            void var2_2;
            void var1_1;
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Booleans.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return ((void)var1_1).length - ((void)var2_2).length;
        }

        public final String toString() {
            return "Booleans.lexicographicalComparator()";
        }
    }

    private static enum BooleanComparator implements Comparator<Boolean>
    {
        TRUE_FIRST(1, "Booleans.trueFirst()"),
        FALSE_FIRST(-1, "Booleans.falseFirst()");

        private final int trueValue;
        private final String toString;

        /*
         * WARNING - void declaration
         */
        private BooleanComparator(int trueValue, String toString) {
            void var3_3;
            this.trueValue = var3_3;
            this.toString = toString;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(Boolean a, Boolean b) {
            void var1_2;
            void var2_3;
            int aVal = a != false ? this.trueValue : 0;
            int n = var2_3.booleanValue() ? this.trueValue : 0;
            return n - var1_2;
        }

        public final String toString() {
            return this.toString;
        }
    }
}

