/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.UnicodeEscaper;
import com.google.common.net.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class PercentEscaper
extends UnicodeEscaper {
    private static final char[] PLUS_SIGN = new char[]{'+'};
    private static final char[] UPPER_HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private final boolean plusForSpace;
    private final boolean[] safeOctets;

    /*
     * WARNING - void declaration
     */
    public PercentEscaper(String safeChars, boolean plusForSpace) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(safeChars);
        if (safeChars.matches(".*[0-9A-Za-z].*")) {
            throw new IllegalArgumentException("Alphanumeric characters are always 'safe' and should not be explicitly specified");
        }
        safeChars = String.valueOf(safeChars).concat("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789");
        if (plusForSpace && safeChars.contains(" ")) {
            throw new IllegalArgumentException("plusForSpace cannot be specified when space is a 'safe' character");
        }
        this.plusForSpace = var2_2;
        this.safeOctets = PercentEscaper.createSafeOctets((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean[] createSafeOctets(String safeChars) {
        void var1_2;
        int maxChar = -1;
        char[] cArray = safeChars.toCharArray();
        Object safeCharArray = cArray;
        char[] cArray2 = cArray;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = cArray2[i];
            maxChar = Math.max(n2, maxChar);
        }
        boolean[] octets = new boolean[var1_2 + true];
        for (Object c : safeCharArray) {
            octets[var0_1] = true;
        }
        return cArray2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int nextEscapeIndex(CharSequence csq, int index, int end) {
        void var2_2;
        char c;
        Preconditions.checkNotNull(csq);
        while (index < end && (c = csq.charAt(index)) < this.safeOctets.length && this.safeOctets[c]) {
            ++index;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String escape(String s) {
        void var1_1;
        Preconditions.checkNotNull(s);
        int slen = s.length();
        for (int index = 0; index < slen; ++index) {
            char c = s.charAt(index);
            if (c < this.safeOctets.length && this.safeOctets[c]) continue;
            return this.escapeSlow(s, index);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final char[] escape(int cp) {
        void var1_1;
        if (cp < this.safeOctets.length && this.safeOctets[cp]) {
            return null;
        }
        if (cp == 32 && this.plusForSpace) {
            return PLUS_SIGN;
        }
        if (cp <= 127) {
            char[] cArray = new char[3];
            char[] dest = cArray;
            cArray[0] = 37;
            dest[2] = UPPER_HEX_DIGITS[cp & 0xF];
            dest[1] = UPPER_HEX_DIGITS[cp >>> 4];
            return dest;
        }
        if (cp <= 2047) {
            char[] cArray = new char[6];
            char[] dest = cArray;
            cArray[0] = 37;
            dest[3] = 37;
            dest[5] = UPPER_HEX_DIGITS[cp & 0xF];
            dest[4] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[2] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[1] = UPPER_HEX_DIGITS[0xC | (cp >>>= 4)];
            return dest;
        }
        if (cp <= 65535) {
            char[] cArray = new char[9];
            char[] dest = cArray;
            cArray[0] = 37;
            dest[1] = 69;
            dest[3] = 37;
            dest[6] = 37;
            dest[8] = UPPER_HEX_DIGITS[cp & 0xF];
            dest[7] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[5] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[4] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[2] = UPPER_HEX_DIGITS[cp >>>= 2];
            return dest;
        }
        if (cp <= 0x10FFFF) {
            void var2_5;
            char[] cArray = new char[12];
            char[] dest = cArray;
            cArray[0] = 37;
            dest[1] = 70;
            dest[3] = 37;
            dest[6] = 37;
            dest[9] = 37;
            dest[11] = UPPER_HEX_DIGITS[cp & 0xF];
            dest[10] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[8] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[7] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[5] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[4] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[2] = UPPER_HEX_DIGITS[(cp >>>= 2) & 7];
            return var2_5;
        }
        void var2_6 = var1_1;
        throw new IllegalArgumentException(new StringBuilder(43).append("Invalid unicode character value ").append((int)var2_6).toString());
    }
}

