/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.net.ElementTypesAreNonnullByDefault;
import java.nio.charset.Charset;
import java.util.AbstractCollection;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class MediaType {
    private static final String CHARSET_ATTRIBUTE = "charset";
    private static final ImmutableListMultimap<String, String> UTF_8_CONSTANT_PARAMETERS = ImmutableListMultimap.of("charset", Ascii.toLowerCase(Charsets.UTF_8.name()));
    private static final CharMatcher TOKEN_MATCHER = CharMatcher.ascii().and(CharMatcher.javaIsoControl().negate()).and(CharMatcher.isNot(' ')).and(CharMatcher.noneOf("()<>@,;:\\\"/[]?="));
    private static final CharMatcher QUOTED_TEXT_MATCHER = CharMatcher.ascii().and(CharMatcher.noneOf("\"\\\r"));
    private static final CharMatcher LINEAR_WHITE_SPACE = CharMatcher.anyOf(" \t\r\n");
    private static final String APPLICATION_TYPE = "application";
    private static final String AUDIO_TYPE = "audio";
    private static final String IMAGE_TYPE = "image";
    private static final String TEXT_TYPE = "text";
    private static final String VIDEO_TYPE = "video";
    private static final String FONT_TYPE = "font";
    private static final String WILDCARD = "*";
    private static final Map<MediaType, MediaType> KNOWN_TYPES = Maps.newHashMap();
    public static final MediaType ANY_TYPE = MediaType.createConstant("*", "*");
    public static final MediaType ANY_TEXT_TYPE = MediaType.createConstant("text", "*");
    public static final MediaType ANY_IMAGE_TYPE = MediaType.createConstant("image", "*");
    public static final MediaType ANY_AUDIO_TYPE = MediaType.createConstant("audio", "*");
    public static final MediaType ANY_VIDEO_TYPE = MediaType.createConstant("video", "*");
    public static final MediaType ANY_APPLICATION_TYPE = MediaType.createConstant("application", "*");
    public static final MediaType ANY_FONT_TYPE = MediaType.createConstant("font", "*");
    public static final MediaType CACHE_MANIFEST_UTF_8 = MediaType.createConstantUtf8("text", "cache-manifest");
    public static final MediaType CSS_UTF_8 = MediaType.createConstantUtf8("text", "css");
    public static final MediaType CSV_UTF_8 = MediaType.createConstantUtf8("text", "csv");
    public static final MediaType HTML_UTF_8 = MediaType.createConstantUtf8("text", "html");
    public static final MediaType I_CALENDAR_UTF_8 = MediaType.createConstantUtf8("text", "calendar");
    public static final MediaType PLAIN_TEXT_UTF_8 = MediaType.createConstantUtf8("text", "plain");
    public static final MediaType TEXT_JAVASCRIPT_UTF_8 = MediaType.createConstantUtf8("text", "javascript");
    public static final MediaType TSV_UTF_8 = MediaType.createConstantUtf8("text", "tab-separated-values");
    public static final MediaType VCARD_UTF_8 = MediaType.createConstantUtf8("text", "vcard");
    public static final MediaType WML_UTF_8 = MediaType.createConstantUtf8("text", "vnd.wap.wml");
    public static final MediaType XML_UTF_8 = MediaType.createConstantUtf8("text", "xml");
    public static final MediaType VTT_UTF_8 = MediaType.createConstantUtf8("text", "vtt");
    public static final MediaType BMP = MediaType.createConstant("image", "bmp");
    public static final MediaType CRW = MediaType.createConstant("image", "x-canon-crw");
    public static final MediaType GIF = MediaType.createConstant("image", "gif");
    public static final MediaType ICO = MediaType.createConstant("image", "vnd.microsoft.icon");
    public static final MediaType JPEG = MediaType.createConstant("image", "jpeg");
    public static final MediaType PNG = MediaType.createConstant("image", "png");
    public static final MediaType PSD = MediaType.createConstant("image", "vnd.adobe.photoshop");
    public static final MediaType SVG_UTF_8 = MediaType.createConstantUtf8("image", "svg+xml");
    public static final MediaType TIFF = MediaType.createConstant("image", "tiff");
    public static final MediaType WEBP = MediaType.createConstant("image", "webp");
    public static final MediaType HEIF = MediaType.createConstant("image", "heif");
    public static final MediaType JP2K = MediaType.createConstant("image", "jp2");
    public static final MediaType MP4_AUDIO = MediaType.createConstant("audio", "mp4");
    public static final MediaType MPEG_AUDIO = MediaType.createConstant("audio", "mpeg");
    public static final MediaType OGG_AUDIO = MediaType.createConstant("audio", "ogg");
    public static final MediaType WEBM_AUDIO = MediaType.createConstant("audio", "webm");
    public static final MediaType L16_AUDIO = MediaType.createConstant("audio", "l16");
    public static final MediaType L24_AUDIO = MediaType.createConstant("audio", "l24");
    public static final MediaType BASIC_AUDIO = MediaType.createConstant("audio", "basic");
    public static final MediaType AAC_AUDIO = MediaType.createConstant("audio", "aac");
    public static final MediaType VORBIS_AUDIO = MediaType.createConstant("audio", "vorbis");
    public static final MediaType WMA_AUDIO = MediaType.createConstant("audio", "x-ms-wma");
    public static final MediaType WAX_AUDIO = MediaType.createConstant("audio", "x-ms-wax");
    public static final MediaType VND_REAL_AUDIO = MediaType.createConstant("audio", "vnd.rn-realaudio");
    public static final MediaType VND_WAVE_AUDIO = MediaType.createConstant("audio", "vnd.wave");
    public static final MediaType MP4_VIDEO = MediaType.createConstant("video", "mp4");
    public static final MediaType MPEG_VIDEO = MediaType.createConstant("video", "mpeg");
    public static final MediaType OGG_VIDEO = MediaType.createConstant("video", "ogg");
    public static final MediaType QUICKTIME = MediaType.createConstant("video", "quicktime");
    public static final MediaType WEBM_VIDEO = MediaType.createConstant("video", "webm");
    public static final MediaType WMV = MediaType.createConstant("video", "x-ms-wmv");
    public static final MediaType FLV_VIDEO = MediaType.createConstant("video", "x-flv");
    public static final MediaType THREE_GPP_VIDEO = MediaType.createConstant("video", "3gpp");
    public static final MediaType THREE_GPP2_VIDEO = MediaType.createConstant("video", "3gpp2");
    public static final MediaType APPLICATION_XML_UTF_8 = MediaType.createConstantUtf8("application", "xml");
    public static final MediaType ATOM_UTF_8 = MediaType.createConstantUtf8("application", "atom+xml");
    public static final MediaType BZIP2 = MediaType.createConstant("application", "x-bzip2");
    public static final MediaType DART_UTF_8 = MediaType.createConstantUtf8("application", "dart");
    public static final MediaType APPLE_PASSBOOK = MediaType.createConstant("application", "vnd.apple.pkpass");
    public static final MediaType EOT = MediaType.createConstant("application", "vnd.ms-fontobject");
    public static final MediaType EPUB = MediaType.createConstant("application", "epub+zip");
    public static final MediaType FORM_DATA = MediaType.createConstant("application", "x-www-form-urlencoded");
    public static final MediaType KEY_ARCHIVE = MediaType.createConstant("application", "pkcs12");
    public static final MediaType APPLICATION_BINARY = MediaType.createConstant("application", "binary");
    public static final MediaType GEO_JSON = MediaType.createConstant("application", "geo+json");
    public static final MediaType GZIP = MediaType.createConstant("application", "x-gzip");
    public static final MediaType HAL_JSON = MediaType.createConstant("application", "hal+json");
    public static final MediaType JAVASCRIPT_UTF_8 = MediaType.createConstantUtf8("application", "javascript");
    public static final MediaType JOSE = MediaType.createConstant("application", "jose");
    public static final MediaType JOSE_JSON = MediaType.createConstant("application", "jose+json");
    public static final MediaType JSON_UTF_8 = MediaType.createConstantUtf8("application", "json");
    public static final MediaType MANIFEST_JSON_UTF_8 = MediaType.createConstantUtf8("application", "manifest+json");
    public static final MediaType KML = MediaType.createConstant("application", "vnd.google-earth.kml+xml");
    public static final MediaType KMZ = MediaType.createConstant("application", "vnd.google-earth.kmz");
    public static final MediaType MBOX = MediaType.createConstant("application", "mbox");
    public static final MediaType APPLE_MOBILE_CONFIG = MediaType.createConstant("application", "x-apple-aspen-config");
    public static final MediaType MICROSOFT_EXCEL = MediaType.createConstant("application", "vnd.ms-excel");
    public static final MediaType MICROSOFT_OUTLOOK = MediaType.createConstant("application", "vnd.ms-outlook");
    public static final MediaType MICROSOFT_POWERPOINT = MediaType.createConstant("application", "vnd.ms-powerpoint");
    public static final MediaType MICROSOFT_WORD = MediaType.createConstant("application", "msword");
    public static final MediaType MEDIA_PRESENTATION_DESCRIPTION = MediaType.createConstant("application", "dash+xml");
    public static final MediaType WASM_APPLICATION = MediaType.createConstant("application", "wasm");
    public static final MediaType NACL_APPLICATION = MediaType.createConstant("application", "x-nacl");
    public static final MediaType NACL_PORTABLE_APPLICATION = MediaType.createConstant("application", "x-pnacl");
    public static final MediaType OCTET_STREAM = MediaType.createConstant("application", "octet-stream");
    public static final MediaType OGG_CONTAINER = MediaType.createConstant("application", "ogg");
    public static final MediaType OOXML_DOCUMENT = MediaType.createConstant("application", "vnd.openxmlformats-officedocument.wordprocessingml.document");
    public static final MediaType OOXML_PRESENTATION = MediaType.createConstant("application", "vnd.openxmlformats-officedocument.presentationml.presentation");
    public static final MediaType OOXML_SHEET = MediaType.createConstant("application", "vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    public static final MediaType OPENDOCUMENT_GRAPHICS = MediaType.createConstant("application", "vnd.oasis.opendocument.graphics");
    public static final MediaType OPENDOCUMENT_PRESENTATION = MediaType.createConstant("application", "vnd.oasis.opendocument.presentation");
    public static final MediaType OPENDOCUMENT_SPREADSHEET = MediaType.createConstant("application", "vnd.oasis.opendocument.spreadsheet");
    public static final MediaType OPENDOCUMENT_TEXT = MediaType.createConstant("application", "vnd.oasis.opendocument.text");
    public static final MediaType OPENSEARCH_DESCRIPTION_UTF_8 = MediaType.createConstantUtf8("application", "opensearchdescription+xml");
    public static final MediaType PDF = MediaType.createConstant("application", "pdf");
    public static final MediaType POSTSCRIPT = MediaType.createConstant("application", "postscript");
    public static final MediaType PROTOBUF = MediaType.createConstant("application", "protobuf");
    public static final MediaType RDF_XML_UTF_8 = MediaType.createConstantUtf8("application", "rdf+xml");
    public static final MediaType RTF_UTF_8 = MediaType.createConstantUtf8("application", "rtf");
    public static final MediaType SFNT = MediaType.createConstant("application", "font-sfnt");
    public static final MediaType SHOCKWAVE_FLASH = MediaType.createConstant("application", "x-shockwave-flash");
    public static final MediaType SKETCHUP = MediaType.createConstant("application", "vnd.sketchup.skp");
    public static final MediaType SOAP_XML_UTF_8 = MediaType.createConstantUtf8("application", "soap+xml");
    public static final MediaType TAR = MediaType.createConstant("application", "x-tar");
    public static final MediaType WOFF = MediaType.createConstant("application", "font-woff");
    public static final MediaType WOFF2 = MediaType.createConstant("application", "font-woff2");
    public static final MediaType XHTML_UTF_8 = MediaType.createConstantUtf8("application", "xhtml+xml");
    public static final MediaType XRD_UTF_8 = MediaType.createConstantUtf8("application", "xrd+xml");
    public static final MediaType ZIP = MediaType.createConstant("application", "zip");
    public static final MediaType FONT_COLLECTION = MediaType.createConstant("font", "collection");
    public static final MediaType FONT_OTF = MediaType.createConstant("font", "otf");
    public static final MediaType FONT_SFNT = MediaType.createConstant("font", "sfnt");
    public static final MediaType FONT_TTF = MediaType.createConstant("font", "ttf");
    public static final MediaType FONT_WOFF = MediaType.createConstant("font", "woff");
    public static final MediaType FONT_WOFF2 = MediaType.createConstant("font", "woff2");
    private final String type;
    private final String subtype;
    private final ImmutableListMultimap<String, String> parameters;
    private String toString;
    private int hashCode;
    private Optional<Charset> parsedCharset;
    private static final Joiner.MapJoiner PARAMETER_JOINER = Joiner.on("; ").withKeyValueSeparator("=");

    /*
     * WARNING - void declaration
     */
    private static MediaType createConstant(String type, String subtype) {
        MediaType mediaType;
        void var1_1;
        MediaType mediaType2 = MediaType.addKnownType(new MediaType(type, (String)var1_1, ImmutableListMultimap.of()));
        MediaType.addKnownType(new MediaType(type, (String)var1_1, ImmutableListMultimap.of())).parsedCharset = Optional.absent();
        return mediaType;
    }

    /*
     * WARNING - void declaration
     */
    private static MediaType createConstantUtf8(String type, String subtype) {
        MediaType mediaType;
        void var1_1;
        MediaType mediaType2 = MediaType.addKnownType(new MediaType(type, (String)var1_1, UTF_8_CONSTANT_PARAMETERS));
        MediaType.addKnownType(new MediaType(type, (String)var1_1, UTF_8_CONSTANT_PARAMETERS)).parsedCharset = Optional.of(Charsets.UTF_8);
        return mediaType;
    }

    private static MediaType addKnownType(MediaType mediaType) {
        MediaType mediaType2;
        MediaType mediaType3 = mediaType;
        KNOWN_TYPES.put(mediaType3, mediaType3);
        return mediaType2;
    }

    /*
     * WARNING - void declaration
     */
    private MediaType(String type, String subtype, ImmutableListMultimap<String, String> parameters) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.type = var1_1;
        this.subtype = var2_2;
        this.parameters = var3_3;
    }

    public final String type() {
        return this.type;
    }

    public final String subtype() {
        return this.subtype;
    }

    public final ImmutableListMultimap<String, String> parameters() {
        return this.parameters;
    }

    private Map<String, ImmutableMultiset<String>> parametersAsMap() {
        return Maps.transformValues(this.parameters.asMap(), ImmutableMultiset::copyOf);
    }

    /*
     * WARNING - void declaration
     */
    public final Optional<Charset> charset() {
        void var1_1;
        Optional<Charset> local = this.parsedCharset;
        if (local == null) {
            String value = null;
            local = Optional.absent();
            for (String currentValue : this.parameters.get((Object)CHARSET_ATTRIBUTE)) {
                if (value == null) {
                    value = currentValue;
                    local = Optional.of(Charset.forName(value));
                    continue;
                }
                if (value.equals(currentValue)) continue;
                local = value;
                throw new IllegalStateException(new StringBuilder(35 + String.valueOf(local).length() + String.valueOf(currentValue).length()).append("Multiple charset values defined: ").append((String)((Object)local)).append(", ").append(currentValue).toString());
            }
            this.parsedCharset = local;
        }
        return var1_1;
    }

    public final MediaType withoutParameters() {
        if (this.parameters.isEmpty()) {
            return this;
        }
        return MediaType.create(this.type, this.subtype);
    }

    /*
     * WARNING - void declaration
     */
    public final MediaType withParameters(Multimap<String, String> parameters) {
        void var1_1;
        return MediaType.create(this.type, this.subtype, (Multimap<String, String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final MediaType withParameters(String attribute, Iterable<String> values) {
        void var1_1;
        void var3_3;
        void var2_2;
        Preconditions.checkNotNull(attribute);
        Preconditions.checkNotNull(values);
        String normalizedAttribute = MediaType.normalizeToken(attribute);
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Map.Entry entry : this.parameters.entries()) {
            String key = (String)entry.getKey();
            if (normalizedAttribute.equals(key)) continue;
            builder.put(key, (String)entry.getValue());
        }
        for (String value : var2_2) {
            String string = normalizedAttribute;
            builder.put(string, MediaType.normalizeParameterValue(string, value));
        }
        MediaType mediaType = new MediaType(this.type, this.subtype, (ImmutableListMultimap<String, String>)var3_3.build());
        if (!var1_1.equals(CHARSET_ATTRIBUTE)) {
            mediaType.parsedCharset = this.parsedCharset;
        }
        return MoreObjects.firstNonNull(KNOWN_TYPES.get(mediaType), mediaType);
    }

    /*
     * WARNING - void declaration
     */
    public final MediaType withParameter(String attribute, String value) {
        void var2_2;
        void var1_1;
        return this.withParameters((String)var1_1, ImmutableSet.of(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final MediaType withCharset(Charset charset) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(charset);
        MediaType withCharset = this.withParameter(CHARSET_ATTRIBUTE, charset.name());
        this.withParameter(CHARSET_ATTRIBUTE, charset.name()).parsedCharset = Optional.of(var1_1);
        return var2_2;
    }

    public final boolean hasWildcard() {
        return WILDCARD.equals(this.type) || WILDCARD.equals(this.subtype);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean is(MediaType mediaTypeRange) {
        void var1_1;
        return !(!mediaTypeRange.type.equals(WILDCARD) && !mediaTypeRange.type.equals(this.type) || !mediaTypeRange.subtype.equals(WILDCARD) && !mediaTypeRange.subtype.equals(this.subtype) || !((AbstractCollection)this.parameters.entries()).containsAll(var1_1.parameters.entries()));
    }

    /*
     * WARNING - void declaration
     */
    public static MediaType create(String type, String subtype) {
        MediaType mediaType;
        void var1_1;
        MediaType mediaType2 = MediaType.create(type, (String)var1_1, ImmutableListMultimap.of());
        MediaType.create(type, (String)var1_1, ImmutableListMultimap.of()).parsedCharset = Optional.absent();
        return mediaType;
    }

    /*
     * WARNING - void declaration
     */
    private static MediaType create(String type, String subtype, Multimap<String, String> parameters) {
        void var2_2;
        void var3_3;
        void var1_1;
        String string;
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(subtype);
        Preconditions.checkNotNull(parameters);
        String normalizedType = MediaType.normalizeToken(type);
        String normalizedSubtype = MediaType.normalizeToken(subtype);
        Preconditions.checkArgument(!WILDCARD.equals(normalizedType) || WILDCARD.equals(normalizedSubtype), "A wildcard type cannot be used with a non-wildcard subtype");
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Map.Entry entry : parameters.entries()) {
            String attribute;
            String string2 = attribute = MediaType.normalizeToken((String)entry.getKey());
            builder.put(string2, MediaType.normalizeParameterValue(string2, (String)entry.getValue()));
        }
        MediaType mediaType = new MediaType(string, (String)var1_1, (ImmutableListMultimap<String, String>)var3_3.build());
        return (MediaType)MoreObjects.firstNonNull(KNOWN_TYPES.get(mediaType), var2_2);
    }

    static MediaType createApplicationType(String subtype) {
        String string;
        return MediaType.create(APPLICATION_TYPE, string);
    }

    static MediaType createAudioType(String subtype) {
        String string;
        return MediaType.create(AUDIO_TYPE, string);
    }

    static MediaType createFontType(String subtype) {
        String string;
        return MediaType.create(FONT_TYPE, string);
    }

    static MediaType createImageType(String subtype) {
        String string;
        return MediaType.create(IMAGE_TYPE, string);
    }

    static MediaType createTextType(String subtype) {
        String string;
        return MediaType.create(TEXT_TYPE, string);
    }

    static MediaType createVideoType(String subtype) {
        String string;
        return MediaType.create(VIDEO_TYPE, string);
    }

    private static String normalizeToken(String token) {
        String string;
        Preconditions.checkArgument(TOKEN_MATCHER.matchesAllOf(token));
        Preconditions.checkArgument(!token.isEmpty());
        return Ascii.toLowerCase(string);
    }

    /*
     * WARNING - void declaration
     */
    private static String normalizeParameterValue(String attribute, String value) {
        void var1_1;
        String string;
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(CharMatcher.ascii().matchesAllOf(value), "parameter values must be ASCII: %s", (Object)value);
        if (CHARSET_ATTRIBUTE.equals(string)) {
            return Ascii.toLowerCase(value);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static MediaType parse(String input) {
        Preconditions.checkNotNull(input);
        Tokenizer tokenizer = new Tokenizer(input);
        try {
            void var3_4;
            String type = tokenizer.consumeToken(TOKEN_MATCHER);
            tokenizer.consumeCharacter('/');
            String subtype = tokenizer.consumeToken(TOKEN_MATCHER);
            ImmutableListMultimap.Builder parameters = ImmutableListMultimap.builder();
            while (tokenizer.hasMore()) {
                String value;
                tokenizer.consumeTokenIfPresent(LINEAR_WHITE_SPACE);
                tokenizer.consumeCharacter(';');
                tokenizer.consumeTokenIfPresent(LINEAR_WHITE_SPACE);
                String attribute = tokenizer.consumeToken(TOKEN_MATCHER);
                tokenizer.consumeCharacter('=');
                if ('\"' == tokenizer.previewChar()) {
                    tokenizer.consumeCharacter('\"');
                    StringBuilder valueBuilder = new StringBuilder();
                    while ('\"' != tokenizer.previewChar()) {
                        if ('\\' == tokenizer.previewChar()) {
                            tokenizer.consumeCharacter('\\');
                            valueBuilder.append(tokenizer.consumeCharacter(CharMatcher.ascii()));
                            continue;
                        }
                        valueBuilder.append(tokenizer.consumeToken(QUOTED_TEXT_MATCHER));
                    }
                    value = valueBuilder.toString();
                    tokenizer.consumeCharacter('\"');
                } else {
                    value = tokenizer.consumeToken(TOKEN_MATCHER);
                }
                parameters.put(attribute, value);
            }
            return MediaType.create(type, (String)var3_4, parameters.build());
        }
        catch (IllegalStateException e) {
            void var2_3;
            String string;
            throw new IllegalArgumentException(new StringBuilder(18 + String.valueOf(input).length()).append("Could not parse '").append(string).append("'").toString(), (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MediaType) {
            void var1_1;
            MediaType that = (MediaType)obj;
            return this.type.equals(that.type) && this.subtype.equals(that.subtype) && this.parametersAsMap().equals(super.parametersAsMap());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = Objects.hashCode(this.type, this.subtype, this.parametersAsMap());
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        String result = this.toString;
        if (result == null) {
            this.toString = result = this.computeToString();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String computeToString() {
        void var1_1;
        StringBuilder builder = new StringBuilder().append(this.type).append('/').append(this.subtype);
        if (!this.parameters.isEmpty()) {
            void var2_2;
            builder.append("; ");
            ListMultimap quotedParameters = Multimaps.transformValues(this.parameters, value -> {
                String string;
                if (TOKEN_MATCHER.matchesAllOf((CharSequence)value) && !value.isEmpty()) {
                    return value;
                }
                return MediaType.escapeAndQuote(string);
            });
            PARAMETER_JOINER.appendTo(builder, (Iterable<? extends Map.Entry<?, ?>>)var2_2.entries());
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String escapeAndQuote(String value) {
        void var1_1;
        StringBuilder escaped = new StringBuilder(value.length() + 16).append('\"');
        for (int i = 0; i < value.length(); ++i) {
            void var3_3;
            char ch = value.charAt(i);
            if (ch == '\r' || ch == '\\' || ch == '\"') {
                escaped.append('\\');
            }
            escaped.append((char)var3_3);
        }
        return var1_1.append('\"').toString();
    }

    private static final class Tokenizer {
        final String input;
        int position = 0;

        /*
         * WARNING - void declaration
         */
        Tokenizer(String input) {
            void var1_1;
            this.input = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final String consumeTokenIfPresent(CharMatcher matcher) {
            void var2_2;
            void var1_1;
            Preconditions.checkState(this.hasMore());
            int startPosition = this.position;
            this.position = var1_1.negate().indexIn(this.input, startPosition);
            if (this.hasMore()) {
                return this.input.substring(startPosition, this.position);
            }
            return this.input.substring((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        final String consumeToken(CharMatcher matcher) {
            void var1_1;
            void var2_2;
            int startPosition = this.position;
            String token = this.consumeTokenIfPresent(matcher);
            Preconditions.checkState(this.position != var2_2);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final char consumeCharacter(CharMatcher matcher) {
            void var2_2;
            void var1_1;
            Preconditions.checkState(this.hasMore());
            char c = this.previewChar();
            Preconditions.checkState(var1_1.matches(c));
            ++this.position;
            return (char)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        final char consumeCharacter(char c) {
            void var1_1;
            Preconditions.checkState(this.hasMore());
            Preconditions.checkState(this.previewChar() == c);
            ++this.position;
            return (char)var1_1;
        }

        final char previewChar() {
            Preconditions.checkState(this.hasMore());
            return this.input.charAt(this.position);
        }

        final boolean hasMore() {
            return this.position >= 0 && this.position < this.input.length();
        }
    }
}

