/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.net.ElementTypesAreNonnullByDefault;
import com.google.thirdparty.publicsuffix.PublicSuffixPatterns;
import com.google.thirdparty.publicsuffix.PublicSuffixType;
import java.util.List;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class InternetDomainName {
    private static final CharMatcher DOTS_MATCHER = CharMatcher.anyOf(".\u3002\uff0e\uff61");
    private static final Splitter DOT_SPLITTER = Splitter.on('.');
    private static final Joiner DOT_JOINER = Joiner.on('.');
    private static final int NO_SUFFIX_FOUND = -1;
    private static final int MAX_PARTS = 127;
    private static final int MAX_LENGTH = 253;
    private static final int MAX_DOMAIN_PART_LENGTH = 63;
    private final String name;
    private final ImmutableList<String> parts;
    private final int publicSuffixIndex;
    private final int registrySuffixIndex;
    private static final CharMatcher DASH_MATCHER = CharMatcher.anyOf("-_");
    private static final CharMatcher DIGIT_MATCHER = CharMatcher.inRange('0', '9');
    private static final CharMatcher LETTER_MATCHER = CharMatcher.inRange('a', 'z').or(CharMatcher.inRange('A', 'Z'));
    private static final CharMatcher PART_CHAR_MATCHER = DIGIT_MATCHER.or(LETTER_MATCHER).or(DASH_MATCHER);

    /*
     * WARNING - void declaration
     */
    InternetDomainName(String name) {
        void var1_1;
        name = Ascii.toLowerCase(DOTS_MATCHER.replaceFrom((CharSequence)name, '.'));
        if (name.endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        Preconditions.checkArgument(name.length() <= 253, "Domain name too long: '%s':", (Object)name);
        this.name = name;
        this.parts = ImmutableList.copyOf(DOT_SPLITTER.split(name));
        Preconditions.checkArgument(this.parts.size() <= 127, "Domain has too many parts: '%s'", (Object)name);
        Preconditions.checkArgument(InternetDomainName.validateSyntax(this.parts), "Not a valid domain name: '%s'", (Object)var1_1);
        this.publicSuffixIndex = this.findSuffixOfType(Optional.absent());
        this.registrySuffixIndex = this.findSuffixOfType(Optional.of(PublicSuffixType.REGISTRY));
    }

    private int findSuffixOfType(Optional<PublicSuffixType> desiredType) {
        int partsSize = this.parts.size();
        for (int i = 0; i < partsSize; ++i) {
            String ancestorName = DOT_JOINER.join(this.parts.subList(i, partsSize));
            if (InternetDomainName.matchesType(desiredType, Optional.fromNullable(PublicSuffixPatterns.EXACT.get(ancestorName)))) {
                return i;
            }
            if (PublicSuffixPatterns.EXCLUDED.containsKey(ancestorName)) {
                return i + 1;
            }
            if (!InternetDomainName.matchesWildcardSuffixType(desiredType, ancestorName)) continue;
            return i;
        }
        return -1;
    }

    public static InternetDomainName from(String domain) {
        String string;
        return new InternetDomainName(Preconditions.checkNotNull(string));
    }

    private static boolean validateSyntax(List<String> parts) {
        int lastIndex = parts.size() - 1;
        if (!InternetDomainName.validatePart(parts.get(lastIndex), true)) {
            return false;
        }
        for (int i = 0; i < lastIndex; ++i) {
            String string = parts.get(i);
            if (InternetDomainName.validatePart(string, false)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean validatePart(String part, boolean isFinalPart) {
        String string;
        void var1_1;
        block6: {
            block5: {
                void var2_2;
                if (part.length() <= 0 || part.length() > 63) {
                    return false;
                }
                String asciiChars = CharMatcher.ascii().retainFrom(part);
                if (!PART_CHAR_MATCHER.matchesAllOf((CharSequence)var2_2)) {
                    return false;
                }
                if (DASH_MATCHER.matches(part.charAt(0))) break block5;
                String string2 = part;
                if (!DASH_MATCHER.matches(string2.charAt(string2.length() - 1))) break block6;
            }
            return false;
        }
        return var1_1 == false || !DIGIT_MATCHER.matches(string.charAt(0));
    }

    public final ImmutableList<String> parts() {
        return this.parts;
    }

    public final boolean isPublicSuffix() {
        return this.publicSuffixIndex == 0;
    }

    public final boolean hasPublicSuffix() {
        return this.publicSuffixIndex != -1;
    }

    public final InternetDomainName publicSuffix() {
        if (this.hasPublicSuffix()) {
            InternetDomainName internetDomainName = this;
            return internetDomainName.ancestor(internetDomainName.publicSuffixIndex);
        }
        return null;
    }

    public final boolean isUnderPublicSuffix() {
        return this.publicSuffixIndex > 0;
    }

    public final boolean isTopPrivateDomain() {
        return this.publicSuffixIndex == 1;
    }

    public final InternetDomainName topPrivateDomain() {
        if (this.isTopPrivateDomain()) {
            return this;
        }
        Preconditions.checkState(this.isUnderPublicSuffix(), "Not under a public suffix: %s", (Object)this.name);
        InternetDomainName internetDomainName = this;
        return internetDomainName.ancestor(internetDomainName.publicSuffixIndex - 1);
    }

    public final boolean isRegistrySuffix() {
        return this.registrySuffixIndex == 0;
    }

    public final boolean hasRegistrySuffix() {
        return this.registrySuffixIndex != -1;
    }

    public final InternetDomainName registrySuffix() {
        if (this.hasRegistrySuffix()) {
            InternetDomainName internetDomainName = this;
            return internetDomainName.ancestor(internetDomainName.registrySuffixIndex);
        }
        return null;
    }

    public final boolean isUnderRegistrySuffix() {
        return this.registrySuffixIndex > 0;
    }

    public final boolean isTopDomainUnderRegistrySuffix() {
        return this.registrySuffixIndex == 1;
    }

    public final InternetDomainName topDomainUnderRegistrySuffix() {
        if (this.isTopDomainUnderRegistrySuffix()) {
            return this;
        }
        Preconditions.checkState(this.isUnderRegistrySuffix(), "Not under a registry suffix: %s", (Object)this.name);
        InternetDomainName internetDomainName = this;
        return internetDomainName.ancestor(internetDomainName.registrySuffixIndex - 1);
    }

    public final boolean hasParent() {
        return this.parts.size() > 1;
    }

    public final InternetDomainName parent() {
        Preconditions.checkState(this.hasParent(), "Domain '%s' has no parent", (Object)this.name);
        return this.ancestor(1);
    }

    /*
     * WARNING - void declaration
     */
    private InternetDomainName ancestor(int levels) {
        void var1_1;
        ImmutableList<String> immutableList = this.parts;
        return InternetDomainName.from(DOT_JOINER.join(immutableList.subList((int)var1_1, immutableList.size())));
    }

    public final InternetDomainName child(String leftParts) {
        String string = Preconditions.checkNotNull(leftParts);
        String string2 = this.name;
        return InternetDomainName.from(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString());
    }

    public static boolean isValid(String name) {
        try {
            InternetDomainName.from(name);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean matchesWildcardSuffixType(Optional<PublicSuffixType> desiredType, String domain) {
        void var1_1;
        Optional<PublicSuffixType> optional;
        List<String> pieces = DOT_SPLITTER.limit(2).splitToList(domain);
        return pieces.size() == 2 && InternetDomainName.matchesType(optional, Optional.fromNullable(PublicSuffixPatterns.UNDER.get(var1_1.get(1))));
    }

    /*
     * WARNING - void declaration
     */
    private static boolean matchesType(Optional<PublicSuffixType> desiredType, Optional<PublicSuffixType> actualType) {
        void var1_1;
        if (desiredType.isPresent()) {
            Optional<PublicSuffixType> optional;
            return optional.equals(actualType);
        }
        return var1_1.isPresent();
    }

    public final String toString() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof InternetDomainName) {
            void var1_1;
            InternetDomainName that = (InternetDomainName)object;
            return this.name.equals(var1_1.name);
        }
        return false;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }
}

