/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.net.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.Ints;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Locale;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class InetAddresses {
    private static final int IPV4_PART_COUNT = 4;
    private static final int IPV6_PART_COUNT = 8;
    private static final char IPV4_DELIMITER = '.';
    private static final char IPV6_DELIMITER = ':';
    private static final CharMatcher IPV4_DELIMITER_MATCHER = CharMatcher.is('.');
    private static final CharMatcher IPV6_DELIMITER_MATCHER = CharMatcher.is(':');
    private static final Inet4Address LOOPBACK4 = (Inet4Address)InetAddresses.forString("127.0.0.1");
    private static final Inet4Address ANY4 = (Inet4Address)InetAddresses.forString("0.0.0.0");

    private InetAddresses() {
    }

    private static Inet4Address getInet4Address(byte[] bytes) {
        byte[] byArray;
        Preconditions.checkArgument(bytes.length == 4, "Byte array has invalid length for an IPv4 address: %s != 4.", bytes.length);
        return (Inet4Address)InetAddresses.bytesToInetAddress(byArray);
    }

    /*
     * WARNING - void declaration
     */
    public static InetAddress forString(String ipString) {
        void var1_1;
        byte[] addr = InetAddresses.ipStringToBytes(ipString);
        if (addr == null) {
            String string;
            throw InetAddresses.formatIllegalArgumentException("'%s' is not an IP string literal.", string);
        }
        return InetAddresses.bytesToInetAddress((byte[])var1_1);
    }

    public static boolean isInetAddress(String ipString) {
        return InetAddresses.ipStringToBytes(ipString) != null;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] ipStringToBytes(String ipStringParam) {
        void var2_2;
        void var1_1;
        String ipString = ipStringParam;
        boolean hasColon = false;
        boolean hasDot = false;
        int percentIndex = -1;
        for (int i = 0; i < ipString.length(); ++i) {
            char c = ipString.charAt(i);
            if (c == '.') {
                hasDot = true;
                continue;
            }
            if (c == ':') {
                if (hasDot) {
                    return null;
                }
                hasColon = true;
                continue;
            }
            if (c == '%') {
                percentIndex = i;
                break;
            }
            if (Character.digit(c, 16) != -1) continue;
            return null;
        }
        if (var1_1 != false) {
            if (hasDot && (ipString = InetAddresses.convertDottedQuadToHex(ipString)) == null) {
                return null;
            }
            if (percentIndex != -1) {
                ipString = ipString.substring(0, percentIndex);
            }
            return InetAddresses.textToNumericFormatV6(ipString);
        }
        if (var2_2 != false) {
            String string;
            void var3_3;
            if (var3_3 != -1) {
                return null;
            }
            return InetAddresses.textToNumericFormatV4(string);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] textToNumericFormatV4(String ipString) {
        void var1_1;
        if (IPV4_DELIMITER_MATCHER.countIn(ipString) + 1 != 4) {
            return null;
        }
        byte[] bytes = new byte[4];
        int start = 0;
        for (int i = 0; i < 4; ++i) {
            int end = ipString.indexOf(46, start);
            if (end == -1) {
                end = ipString.length();
            }
            try {
                bytes[i] = InetAddresses.parseOctet(ipString, start, end);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            start = end + 1;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] textToNumericFormatV6(String ipString) {
        int delimiterCount = IPV6_DELIMITER_MATCHER.countIn(ipString);
        if (delimiterCount < 2 || delimiterCount > 8) {
            return null;
        }
        int partsSkipped = 8 - (delimiterCount + 1);
        boolean hasSkip = false;
        for (int i = 0; i < ipString.length() - 1; ++i) {
            if (ipString.charAt(i) != ':' || ipString.charAt(i + 1) != ':') continue;
            if (hasSkip) {
                return null;
            }
            hasSkip = true;
            ++partsSkipped;
            if (i == 0) {
                ++partsSkipped;
            }
            if (i != ipString.length() - 2) continue;
            ++partsSkipped;
        }
        if (ipString.charAt(0) == ':' && ipString.charAt(1) != ':') {
            return null;
        }
        String string = ipString;
        if (string.charAt(string.length() - 1) == ':') {
            String string2 = ipString;
            if (string2.charAt(string2.length() - 2) != ':') {
                return null;
            }
        }
        if (hasSkip && partsSkipped <= 0) {
            return null;
        }
        if (!hasSkip && delimiterCount + 1 != 8) {
            return null;
        }
        ByteBuffer rawBytes = ByteBuffer.allocate(16);
        try {
            int start = 0;
            if (ipString.charAt(0) == ':') {
                start = 1;
            }
            while (start < ipString.length()) {
                void var3_3;
                void var1_1;
                int end = ipString.indexOf(58, start);
                if (end == -1) {
                    end = ipString.length();
                }
                if (ipString.charAt(start) == ':') {
                    for (int i = 0; i < partsSkipped; ++i) {
                        rawBytes.putShort((short)0);
                    }
                } else {
                    rawBytes.putShort(InetAddresses.parseHextet(ipString, (int)var1_1, end));
                }
                var1_1 = var3_3 + true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return rawBytes.array();
    }

    /*
     * WARNING - void declaration
     */
    private static String convertDottedQuadToHex(String ipString) {
        String string;
        void var1_2;
        void var2_3;
        int lastColon = ipString.lastIndexOf(58);
        String initialPart = ipString.substring(0, lastColon + 1);
        ipString = ipString.substring(lastColon + 1);
        byte[] byArray = InetAddresses.textToNumericFormatV4(ipString);
        String quad = (String)byArray;
        if (byArray == null) {
            return null;
        }
        String penultimate = Integer.toHexString((quad[0] & 0xFF) << 8 | quad[1] & 0xFF);
        String ultimate = Integer.toHexString((quad[2] & 0xFF) << 8 | quad[3] & 0xFF);
        return new StringBuilder(1 + String.valueOf(initialPart).length() + String.valueOf(penultimate).length() + String.valueOf(ultimate).length()).append((String)var2_3).append((String)var1_2).append(":").append(string).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static byte parseOctet(String ipString, int start, int end) {
        void var3_3;
        void i;
        int length = end - start;
        if (length <= 0 || length > 3) {
            throw new NumberFormatException();
        }
        if (length > 1 && ipString.charAt(start) == '0') {
            throw new NumberFormatException();
        }
        int octet = 0;
        while (i < end) {
            octet *= 10;
            int digit = Character.digit(ipString.charAt((int)i), 10);
            if (digit < 0) {
                throw new NumberFormatException();
            }
            octet += digit;
            ++i;
        }
        if (octet > 255) {
            throw new NumberFormatException();
        }
        return (byte)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static short parseHextet(String ipString, int start, int end) {
        void var3_3;
        void i;
        int length = end - start;
        if (length <= 0 || length > 4) {
            throw new NumberFormatException();
        }
        int hextet = 0;
        while (i < end) {
            hextet <<= 4;
            hextet |= Character.digit(ipString.charAt((int)i), 16);
            ++i;
        }
        return (short)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static InetAddress bytesToInetAddress(byte[] addr) {
        try {
            return InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            void var0_1;
            throw new AssertionError(var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String toAddrString(InetAddress ip) {
        void var1_1;
        Preconditions.checkNotNull(ip);
        if (ip instanceof Inet4Address) {
            return ip.getHostAddress();
        }
        Preconditions.checkArgument(ip instanceof Inet6Address);
        Object bytes = ip.getAddress();
        int[] hextets = new int[8];
        for (int i = 0; i < hextets.length; ++i) {
            hextets[i] = Ints.fromBytes((byte)0, (byte)0, (byte)bytes[2 * i], (byte)bytes[2 * i + 1]);
        }
        InetAddresses.compressLongestRunOfZeroes(hextets);
        return InetAddresses.hextetsToIPv6String((int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void compressLongestRunOfZeroes(int[] hextets) {
        int bestRunStart = -1;
        int bestRunLength = -1;
        int runStart = -1;
        for (int i = 0; i < hextets.length + 1; ++i) {
            if (i < hextets.length && hextets[i] == 0) {
                if (runStart >= 0) continue;
                runStart = i;
                continue;
            }
            if (runStart < 0) continue;
            int runLength = i - runStart;
            if (runLength > bestRunLength) {
                bestRunStart = runStart;
                bestRunLength = runLength;
            }
            runStart = -1;
        }
        if (bestRunLength >= 2) {
            void var2_2;
            int[] nArray;
            void var1_1;
            void v0 = var1_1;
            Arrays.fill(nArray, (int)v0, (int)(v0 + var2_2), -1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String hextetsToIPv6String(int[] hextets) {
        void var1_1;
        StringBuilder buf = new StringBuilder(39);
        boolean lastWasNumber = false;
        for (int i = 0; i < hextets.length; ++i) {
            boolean thisIsNumber = hextets[i] >= 0;
            if (thisIsNumber) {
                if (lastWasNumber) {
                    buf.append(':');
                }
                buf.append(Integer.toHexString(hextets[i]));
            } else if (i == 0 || lastWasNumber) {
                buf.append("::");
            }
            lastWasNumber = thisIsNumber;
        }
        return var1_1.toString();
    }

    public static String toUriString(InetAddress ip) {
        InetAddress inetAddress;
        if (ip instanceof Inet6Address) {
            ip = InetAddresses.toAddrString((InetAddress)ip);
            return new StringBuilder(2 + String.valueOf(ip).length()).append("[").append((String)ip).append("]").toString();
        }
        return InetAddresses.toAddrString(inetAddress);
    }

    /*
     * WARNING - void declaration
     */
    public static InetAddress forUriString(String hostAddr) {
        void var1_1;
        InetAddress addr = InetAddresses.forUriStringNoThrow(hostAddr);
        if (addr == null) {
            String string;
            throw InetAddresses.formatIllegalArgumentException("Not a valid URI IP literal: '%s'", string);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static InetAddress forUriStringNoThrow(String hostAddr) {
        String string;
        void var1_1;
        int expectBytes;
        String ipString;
        Preconditions.checkNotNull(hostAddr);
        if (hostAddr.startsWith("[") && hostAddr.endsWith("]")) {
            ipString = hostAddr.substring(1, hostAddr.length() - 1);
            expectBytes = 16;
        } else {
            expectBytes = 4;
        }
        byte[] byArray = InetAddresses.ipStringToBytes(ipString);
        String addr = (String)byArray;
        if (byArray == null || ((Object)addr).length != var1_1) {
            return null;
        }
        return InetAddresses.bytesToInetAddress((byte[])string);
    }

    public static boolean isUriInetAddress(String ipString) {
        return InetAddresses.forUriStringNoThrow(ipString) != null;
    }

    public static boolean isCompatIPv4Address(Inet6Address ip) {
        Object object;
        if (!ip.isIPv4CompatibleAddress()) {
            return false;
        }
        byte[] byArray = ip.getAddress();
        Object bytes = byArray;
        return byArray[12] != 0 || bytes[13] != false || bytes[14] != false || bytes[15] != false && object[15] != true;
    }

    public static Inet4Address getCompatIPv4Address(Inet6Address ip) {
        Inet6Address inet6Address;
        Preconditions.checkArgument(InetAddresses.isCompatIPv4Address(ip), "Address '%s' is not IPv4-compatible.", (Object)InetAddresses.toAddrString(ip));
        return InetAddresses.getInet4Address(Arrays.copyOfRange(inet6Address.getAddress(), 12, 16));
    }

    public static boolean is6to4Address(Inet6Address ip) {
        Object object;
        byte[] byArray = ip.getAddress();
        Object bytes = byArray;
        return byArray[0] == 32 && object[1] == 2;
    }

    public static Inet4Address get6to4IPv4Address(Inet6Address ip) {
        Inet6Address inet6Address;
        Preconditions.checkArgument(InetAddresses.is6to4Address(ip), "Address '%s' is not a 6to4 address.", (Object)InetAddresses.toAddrString(ip));
        return InetAddresses.getInet4Address(Arrays.copyOfRange(inet6Address.getAddress(), 2, 6));
    }

    public static boolean isTeredoAddress(Inet6Address ip) {
        Object object;
        byte[] byArray = ip.getAddress();
        Object bytes = byArray;
        return byArray[0] == 32 && bytes[1] == true && bytes[2] == false && object[3] == false;
    }

    /*
     * WARNING - void declaration
     */
    public static TeredoInfo getTeredoInfo(Inet6Address ip) {
        void var2_2;
        void var3_3;
        void var1_1;
        Object object;
        Preconditions.checkArgument(InetAddresses.isTeredoAddress(ip), "Address '%s' is not a Teredo address.", (Object)InetAddresses.toAddrString(ip));
        byte[] byArray = ip.getAddress();
        Object bytes = byArray;
        Inet4Address server = InetAddresses.getInet4Address(Arrays.copyOfRange(byArray, 4, 8));
        int flags = ByteStreams.newDataInput((byte[])bytes, 8).readShort() & 0xFFFF;
        int port = ~ByteStreams.newDataInput((byte[])bytes, 10).readShort() & 0xFFFF;
        Object clientBytes = Arrays.copyOfRange((byte[])bytes, 12, 16);
        for (int i = 0; i < ((Object)clientBytes).length; ++i) {
            clientBytes[i] = (byte)(~clientBytes[i]);
        }
        Inet4Address client = InetAddresses.getInet4Address((byte[])object);
        return new TeredoInfo((Inet4Address)var1_1, client, (int)var3_3, (int)var2_2);
    }

    public static boolean isIsatapAddress(Inet6Address ip) {
        Object object;
        if (InetAddresses.isTeredoAddress(ip)) {
            return false;
        }
        byte[] byArray = ip.getAddress();
        Object bytes = byArray;
        if ((byArray[8] | 3) != 3) {
            return false;
        }
        return bytes[9] == false && bytes[10] == 94 && object[11] == -2;
    }

    public static Inet4Address getIsatapIPv4Address(Inet6Address ip) {
        Inet6Address inet6Address;
        Preconditions.checkArgument(InetAddresses.isIsatapAddress(ip), "Address '%s' is not an ISATAP address.", (Object)InetAddresses.toAddrString(ip));
        return InetAddresses.getInet4Address(Arrays.copyOfRange(inet6Address.getAddress(), 12, 16));
    }

    public static boolean hasEmbeddedIPv4ClientAddress(Inet6Address ip) {
        Inet6Address inet6Address;
        return InetAddresses.isCompatIPv4Address(ip) || InetAddresses.is6to4Address(ip) || InetAddresses.isTeredoAddress(inet6Address);
    }

    public static Inet4Address getEmbeddedIPv4ClientAddress(Inet6Address ip) {
        Inet6Address inet6Address;
        if (InetAddresses.isCompatIPv4Address(ip)) {
            return InetAddresses.getCompatIPv4Address(ip);
        }
        if (InetAddresses.is6to4Address(ip)) {
            return InetAddresses.get6to4IPv4Address(ip);
        }
        if (InetAddresses.isTeredoAddress(ip)) {
            return InetAddresses.getTeredoInfo(ip).getClient();
        }
        throw InetAddresses.formatIllegalArgumentException("'%s' has no embedded IPv4 address.", InetAddresses.toAddrString(inet6Address));
    }

    public static boolean isMappedIPv4Address(String ipString) {
        byte[] byArray = InetAddresses.ipStringToBytes(ipString);
        Object bytes = byArray;
        if (byArray != null && ((Object)bytes).length == 16) {
            int i;
            for (i = 0; i < 10; ++i) {
                if (bytes[i] == false) continue;
                return false;
            }
            for (i = 10; i < 12; ++i) {
                if (bytes[i] == -1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static Inet4Address getCoercedIPv4Address(InetAddress ip2) {
        void var0_1;
        void var3_5;
        void var1_2;
        void var2_3;
        if (ip2 instanceof Inet4Address) {
            return (Inet4Address)ip2;
        }
        byte[] bytes = ip2.getAddress();
        boolean leadingBytesOfZero = true;
        for (int i = 0; i < 15; ++i) {
            if (bytes[i] == 0) continue;
            leadingBytesOfZero = false;
            break;
        }
        if (leadingBytesOfZero && bytes[15] == 1) {
            return LOOPBACK4;
        }
        if (var2_3 != false && var1_2[15] == false) {
            return ANY4;
        }
        Inet6Address ip6 = (Inet6Address)ip2;
        long addressAsLong = InetAddresses.hasEmbeddedIPv4ClientAddress(ip6) ? (long)InetAddresses.getEmbeddedIPv4ClientAddress(ip6).hashCode() : ByteBuffer.wrap(var3_5.getAddress(), 0, 8).getLong();
        int ip2 = Hashing.murmur3_32_fixed().hashLong(addressAsLong).asInt();
        int coercedHash = ip2 | 0xE0000000;
        if (coercedHash == -1) {
            coercedHash = -2;
        }
        return InetAddresses.getInet4Address(Ints.toByteArray((int)var0_1));
    }

    public static int coerceToInteger(InetAddress ip) {
        return ByteStreams.newDataInput(InetAddresses.getCoercedIPv4Address(ip).getAddress()).readInt();
    }

    public static BigInteger toBigInteger(InetAddress address) {
        InetAddress inetAddress;
        return new BigInteger(1, inetAddress.getAddress());
    }

    public static Inet4Address fromInteger(int address) {
        return InetAddresses.getInet4Address(Ints.toByteArray(address));
    }

    public static Inet4Address fromIPv4BigInteger(BigInteger address) {
        return (Inet4Address)InetAddresses.fromBigInteger(address, false);
    }

    public static Inet6Address fromIPv6BigInteger(BigInteger address) {
        return (Inet6Address)InetAddresses.fromBigInteger(address, true);
    }

    /*
     * WARNING - void declaration
     */
    private static InetAddress fromBigInteger(BigInteger address, boolean isIpv6) {
        void var2_2;
        Preconditions.checkArgument(address.signum() >= 0, "BigInteger must be greater than or equal to 0");
        int numBytes = isIpv6 ? 16 : 4;
        byte[] addressBytes = address.toByteArray();
        byte[] targetCopyArray = new byte[numBytes];
        int srcPos = Math.max(0, addressBytes.length - numBytes);
        int copyLength = addressBytes.length - srcPos;
        int destPos = numBytes - copyLength;
        for (int i = 0; i < srcPos; ++i) {
            if (addressBytes[i] == 0) continue;
            throw InetAddresses.formatIllegalArgumentException("BigInteger cannot be converted to InetAddress because it has more than %d bytes: %s", numBytes, address);
        }
        System.arraycopy(var2_2, srcPos, targetCopyArray, destPos, copyLength);
        try {
            void var3_3;
            return InetAddress.getByAddress((byte[])var3_3);
        }
        catch (UnknownHostException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static InetAddress fromLittleEndianByteArray(byte[] addr) throws UnknownHostException {
        void var1_1;
        byte[] reversed = new byte[addr.length];
        for (int i = 0; i < addr.length; ++i) {
            reversed[i] = addr[addr.length - i - 1];
        }
        return InetAddress.getByAddress((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static InetAddress decrement(InetAddress address) {
        void var1_1;
        void var2_2;
        InetAddress inetAddress;
        int i;
        byte[] addr = address.getAddress();
        for (i = addr.length - 1; i >= 0 && addr[i] == 0; --i) {
            addr[i] = -1;
        }
        Preconditions.checkArgument(i >= 0, "Decrementing %s would wrap.", (Object)inetAddress);
        void v0 = var2_2;
        addr[v0] = (byte)(addr[v0] - 1);
        return InetAddresses.bytesToInetAddress((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static InetAddress increment(InetAddress address) {
        void var1_1;
        void var2_2;
        InetAddress inetAddress;
        int i;
        byte[] addr = address.getAddress();
        for (i = addr.length - 1; i >= 0 && addr[i] == -1; --i) {
            addr[i] = 0;
        }
        Preconditions.checkArgument(i >= 0, "Incrementing %s would wrap.", (Object)inetAddress);
        void v0 = var2_2;
        addr[v0] = (byte)(addr[v0] + 1);
        return InetAddresses.bytesToInetAddress((byte[])var1_1);
    }

    public static boolean isMaximum(InetAddress address) {
        byte[] byArray = address.getAddress();
        Object object = byArray;
        object = byArray;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = object[i];
            if (object2 == -1) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static IllegalArgumentException formatIllegalArgumentException(String format, Object ... args) {
        void var1_1;
        String string;
        return new IllegalArgumentException(String.format(Locale.ROOT, string, (Object[])var1_1));
    }

    public static final class TeredoInfo {
        private final Inet4Address server;
        private final Inet4Address client;
        private final int port;
        private final int flags;

        /*
         * WARNING - void declaration
         */
        public TeredoInfo(Inet4Address server, Inet4Address client, int port, int flags) {
            void var3_3;
            void var2_2;
            void var1_1;
            Preconditions.checkArgument(port >= 0 && port <= 65535, "port '%s' is out of range (0 <= port <= 0xffff)", port);
            Preconditions.checkArgument(flags >= 0 && flags <= 65535, "flags '%s' is out of range (0 <= flags <= 0xffff)", flags);
            this.server = MoreObjects.firstNonNull(var1_1, ANY4);
            this.client = MoreObjects.firstNonNull(var2_2, ANY4);
            this.port = var3_3;
            this.flags = flags;
        }

        public final Inet4Address getServer() {
            return this.server;
        }

        public final Inet4Address getClient() {
            return this.client;
        }

        public final int getPort() {
            return this.port;
        }

        public final int getFlags() {
            return this.flags;
        }
    }
}

