/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.net.ElementTypesAreNonnullByDefault;
import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import java.net.InetAddress;
import java.text.ParseException;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class HostSpecifier {
    private final String canonicalForm;

    /*
     * WARNING - void declaration
     */
    private HostSpecifier(String canonicalForm) {
        void var1_1;
        this.canonicalForm = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static HostSpecifier fromValid(String specifier) {
        String string;
        String parsedHost = HostAndPort.fromString(specifier);
        Preconditions.checkArgument(!((HostAndPort)((Object)parsedHost)).hasPort());
        String host = ((HostAndPort)((Object)parsedHost)).getHost();
        InetAddress addr = null;
        try {
            addr = InetAddresses.forString(host);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (addr != null) {
            return new HostSpecifier(InetAddresses.toUriString(addr));
        }
        InternetDomainName domain = InternetDomainName.from(host);
        if (domain.hasPublicSuffix()) {
            void var1_1;
            return new HostSpecifier(var1_1.toString());
        }
        String string2 = String.valueOf(string);
        throw new IllegalArgumentException(string2.length() != 0 ? "Domain name does not have a recognized public suffix: ".concat(string2) : new String("Domain name does not have a recognized public suffix: "));
    }

    /*
     * WARNING - void declaration
     */
    public static HostSpecifier from(String specifier) throws ParseException {
        try {
            return HostSpecifier.fromValid(specifier);
        }
        catch (IllegalArgumentException e) {
            ParseException parseException;
            void var1_1;
            String string = String.valueOf(specifier);
            ParseException parseException2 = new ParseException(string.length() != 0 ? "Invalid host specifier: ".concat(string) : new String("Invalid host specifier: "), 0);
            parseException2.initCause((Throwable)var1_1);
            throw parseException;
        }
    }

    public static boolean isValid(String specifier) {
        try {
            HostSpecifier.fromValid(specifier);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HostSpecifier) {
            void var1_1;
            HostSpecifier that = (HostSpecifier)other;
            return this.canonicalForm.equals(var1_1.canonicalForm);
        }
        return false;
    }

    public final int hashCode() {
        return this.canonicalForm.hashCode();
    }

    public final String toString() {
        return this.canonicalForm;
    }
}

