/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.net.ElementTypesAreNonnullByDefault;
import java.io.Serializable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class HostAndPort
implements Serializable {
    private static final int NO_PORT = -1;
    private final String host;
    private final int port;
    private final boolean hasBracketlessColons;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    private HostAndPort(String host, int port, boolean hasBracketlessColons) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.host = var1_1;
        this.port = var2_2;
        this.hasBracketlessColons = var3_3;
    }

    public final String getHost() {
        return this.host;
    }

    public final boolean hasPort() {
        return this.port >= 0;
    }

    public final int getPort() {
        Preconditions.checkState(this.hasPort());
        return this.port;
    }

    /*
     * WARNING - void declaration
     */
    public final int getPortOrDefault(int defaultPort) {
        void var1_1;
        if (this.hasPort()) {
            return this.port;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static HostAndPort fromParts(String host, int port) {
        void var2_2;
        void var1_1;
        String string;
        Preconditions.checkArgument(HostAndPort.isValidPort(port), "Port out of range: %s", port);
        HostAndPort parsedHost = HostAndPort.fromString(host);
        Preconditions.checkArgument(!parsedHost.hasPort(), "Host has a port: %s", (Object)string);
        return new HostAndPort(parsedHost.host, (int)var1_1, var2_2.hasBracketlessColons);
    }

    /*
     * WARNING - void declaration
     */
    public static HostAndPort fromHost(String host) {
        void var1_1;
        String string;
        HostAndPort parsedHost = HostAndPort.fromString(host);
        Preconditions.checkArgument(!parsedHost.hasPort(), "Host has a port: %s", (Object)string);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static HostAndPort fromString(String hostPortString) {
        void var3_2;
        void var1_6;
        String host;
        Preconditions.checkNotNull(hostPortString);
        String portString = null;
        boolean hasBracketlessColons = false;
        if (hostPortString.startsWith("[")) {
            String[] hostAndPort = HostAndPort.getHostAndPortFromBracketedHost(hostPortString);
            host = hostAndPort[0];
            portString = hostAndPort[1];
        } else {
            int colonPos = hostPortString.indexOf(58);
            if (colonPos >= 0 && hostPortString.indexOf(58, colonPos + 1) == -1) {
                host = hostPortString.substring(0, colonPos);
                portString = hostPortString.substring(colonPos + 1);
            } else {
                host = hostPortString;
                hasBracketlessColons = colonPos >= 0;
            }
        }
        int port = -1;
        if (!Strings.isNullOrEmpty(portString)) {
            String string;
            Preconditions.checkArgument(!portString.startsWith("+") && CharMatcher.ascii().matchesAllOf(portString), "Unparseable port number: %s", (Object)hostPortString);
            try {
                void var2_1;
                port = Integer.parseInt((String)var2_1);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(hostPortString);
                throw new IllegalArgumentException(string2.length() != 0 ? "Unparseable port number: ".concat(string2) : new String("Unparseable port number: "));
            }
            Preconditions.checkArgument(HostAndPort.isValidPort(port), "Port number out of range: %s", (Object)string);
        }
        return new HostAndPort((String)var1_6, port, (boolean)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    private static String[] getHostAndPortFromBracketedHost(String hostPortString) {
        void var2_3;
        String string;
        void var1_2;
        Preconditions.checkArgument(hostPortString.charAt(0) == '[', "Bracketed host-port string must start with a bracket: %s", (Object)hostPortString);
        int colonIndex = hostPortString.indexOf(58);
        int closeBracketIndex = hostPortString.lastIndexOf(93);
        Preconditions.checkArgument(colonIndex >= 0 && closeBracketIndex > colonIndex, "Invalid bracketed host/port: %s", (Object)hostPortString);
        String host = hostPortString.substring(1, closeBracketIndex);
        if (closeBracketIndex + 1 == hostPortString.length()) {
            return new String[]{host, ""};
        }
        Preconditions.checkArgument(hostPortString.charAt(closeBracketIndex + 1) == ':', "Only a colon may follow a close bracket: %s", (Object)hostPortString);
        for (int i = closeBracketIndex + 2; i < hostPortString.length(); ++i) {
            Preconditions.checkArgument(Character.isDigit(hostPortString.charAt(i)), "Port must be numeric: %s", (Object)hostPortString);
        }
        return new String[]{var1_2, string.substring((int)(var2_3 + 2))};
    }

    /*
     * WARNING - void declaration
     */
    public final HostAndPort withDefaultPort(int defaultPort) {
        void var1_1;
        Preconditions.checkArgument(HostAndPort.isValidPort(defaultPort));
        if (this.hasPort()) {
            return this;
        }
        return new HostAndPort(this.host, (int)var1_1, this.hasBracketlessColons);
    }

    public final HostAndPort requireBracketsForIPv6() {
        Preconditions.checkArgument(!this.hasBracketlessColons, "Possible bracketless IPv6 literal: %s", (Object)this.host);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HostAndPort) {
            void var1_1;
            HostAndPort that = (HostAndPort)other;
            return Objects.equal(this.host, that.host) && this.port == var1_1.port;
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.host, this.port);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder builder = new StringBuilder(this.host.length() + 8);
        if (this.host.indexOf(58) >= 0) {
            builder.append('[').append(this.host).append(']');
        } else {
            builder.append(this.host);
        }
        if (this.hasPort()) {
            builder.append(':').append(this.port);
        }
        return var1_1.toString();
    }

    private static boolean isValidPort(int port) {
        int n;
        return port >= 0 && n <= 65535;
    }
}

