/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.math.DoubleUtils;
import com.google.common.math.ElementTypesAreNonnullByDefault;
import com.google.common.math.Stats;
import com.google.common.primitives.Doubles;
import java.util.Iterator;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class StatsAccumulator {
    private long count = 0L;
    private double mean = 0.0;
    private double sumOfSquaresOfDeltas = 0.0;
    private double min = Double.NaN;
    private double max = Double.NaN;

    /*
     * WARNING - void declaration
     */
    public final void add(double value) {
        if (this.count == 0L) {
            this.count = 1L;
            this.mean = value;
            this.min = value;
            this.max = value;
            if (!Doubles.isFinite(value)) {
                this.sumOfSquaresOfDeltas = Double.NaN;
                return;
            }
        } else {
            void var1_1;
            ++this.count;
            if (Doubles.isFinite(value) && Doubles.isFinite(this.mean)) {
                void var3_2;
                double delta = value - this.mean;
                this.mean += delta / (double)this.count;
                this.sumOfSquaresOfDeltas += var3_2 * (value - this.mean);
            } else {
                this.mean = StatsAccumulator.calculateNewMeanNonFinite(this.mean, value);
                this.sumOfSquaresOfDeltas = Double.NaN;
            }
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, (double)var1_1);
        }
    }

    public final void addAll(Iterable<? extends Number> values) {
        for (Number number : values) {
            this.add(number.doubleValue());
        }
    }

    public final void addAll(Iterator<? extends Number> values) {
        while (values.hasNext()) {
            this.add(values.next().doubleValue());
        }
    }

    public final void addAll(double ... values) {
        double[] dArray = values;
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            double value = dArray[i];
            this.add(value);
        }
    }

    public final void addAll(int ... values) {
        int[] nArray = values;
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            int value = nArray[i];
            this.add(value);
        }
    }

    public final void addAll(long ... values) {
        long[] lArray = values;
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            long value = lArray[i];
            this.add(value);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addAll(DoubleStream values) {
        void var1_1;
        this.addAll(var1_1.collect(StatsAccumulator::new, StatsAccumulator::add, StatsAccumulator::addAll));
    }

    /*
     * WARNING - void declaration
     */
    public final void addAll(IntStream values) {
        void var1_1;
        this.addAll(var1_1.collect(StatsAccumulator::new, StatsAccumulator::add, StatsAccumulator::addAll));
    }

    /*
     * WARNING - void declaration
     */
    public final void addAll(LongStream values) {
        void var1_1;
        this.addAll(var1_1.collect(StatsAccumulator::new, StatsAccumulator::add, StatsAccumulator::addAll));
    }

    /*
     * WARNING - void declaration
     */
    public final void addAll(Stats values) {
        void var1_1;
        if (values.count() == 0L) {
            return;
        }
        this.merge(values.count(), values.mean(), values.sumOfSquaresOfDeltas(), values.min(), var1_1.max());
    }

    /*
     * WARNING - void declaration
     */
    public final void addAll(StatsAccumulator values) {
        void var1_1;
        if (values.count() == 0L) {
            return;
        }
        this.merge(values.count(), values.mean(), values.sumOfSquaresOfDeltas(), values.min(), var1_1.max());
    }

    /*
     * WARNING - void declaration
     */
    private void merge(long otherCount, double otherMean, double otherSumOfSquaresOfDeltas, double otherMin, double otherMax) {
        if (this.count == 0L) {
            this.count = otherCount;
            this.mean = otherMean;
            this.sumOfSquaresOfDeltas = otherSumOfSquaresOfDeltas;
            this.min = otherMin;
            this.max = otherMax;
            return;
        }
        this.count += otherCount;
        if (Doubles.isFinite(this.mean) && Doubles.isFinite(otherMean)) {
            void var1_1;
            double delta = otherMean - this.mean;
            this.mean += delta * (double)otherCount / (double)this.count;
            this.sumOfSquaresOfDeltas += otherSumOfSquaresOfDeltas + delta * (otherMean - this.mean) * (double)var1_1;
        } else {
            void var3_3;
            this.mean = StatsAccumulator.calculateNewMeanNonFinite(this.mean, (double)var3_3);
            this.sumOfSquaresOfDeltas = Double.NaN;
        }
        this.min = Math.min(this.min, otherMin);
        this.max = Math.max(this.max, otherMax);
    }

    public final Stats snapshot() {
        return new Stats(this.count, this.mean, this.sumOfSquaresOfDeltas, this.min, this.max);
    }

    public final long count() {
        return this.count;
    }

    public final double mean() {
        Preconditions.checkState(this.count != 0L);
        return this.mean;
    }

    public final double sum() {
        return this.mean * (double)this.count;
    }

    public final double populationVariance() {
        Preconditions.checkState(this.count != 0L);
        if (Double.isNaN(this.sumOfSquaresOfDeltas)) {
            return Double.NaN;
        }
        if (this.count == 1L) {
            return 0.0;
        }
        return DoubleUtils.ensureNonNegative(this.sumOfSquaresOfDeltas) / (double)this.count;
    }

    public final double populationStandardDeviation() {
        return Math.sqrt(this.populationVariance());
    }

    public final double sampleVariance() {
        Preconditions.checkState(this.count > 1L);
        if (Double.isNaN(this.sumOfSquaresOfDeltas)) {
            return Double.NaN;
        }
        return DoubleUtils.ensureNonNegative(this.sumOfSquaresOfDeltas) / (double)(this.count - 1L);
    }

    public final double sampleStandardDeviation() {
        return Math.sqrt(this.sampleVariance());
    }

    public final double min() {
        Preconditions.checkState(this.count != 0L);
        return this.min;
    }

    public final double max() {
        Preconditions.checkState(this.count != 0L);
        return this.max;
    }

    final double sumOfSquaresOfDeltas() {
        return this.sumOfSquaresOfDeltas;
    }

    /*
     * WARNING - void declaration
     */
    static double calculateNewMeanNonFinite(double previousMean, double value) {
        void var2_1;
        if (Doubles.isFinite(previousMean)) {
            return value;
        }
        if (Doubles.isFinite(value) || previousMean == var2_1) {
            double d;
            return d;
        }
        return Double.NaN;
    }
}

