/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.math.DoubleUtils;
import com.google.common.math.ElementTypesAreNonnullByDefault;
import com.google.common.math.StatsAccumulator;
import com.google.common.primitives.Doubles;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class Stats
implements Serializable {
    private final long count;
    private final double mean;
    private final double sumOfSquaresOfDeltas;
    private final double min;
    private final double max;
    static final int BYTES = 40;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    Stats(long count, double mean, double sumOfSquaresOfDeltas, double min, double max) {
        void var3_3;
        void var1_1;
        this.count = var1_1;
        this.mean = var3_3;
        this.sumOfSquaresOfDeltas = sumOfSquaresOfDeltas;
        this.min = min;
        this.max = max;
    }

    /*
     * WARNING - void declaration
     */
    public static Stats of(Iterable<? extends Number> values) {
        void var1_1;
        Iterable<? extends Number> iterable;
        StatsAccumulator accumulator = new StatsAccumulator();
        accumulator.addAll(iterable);
        return var1_1.snapshot();
    }

    /*
     * WARNING - void declaration
     */
    public static Stats of(Iterator<? extends Number> values) {
        void var1_1;
        Iterator<? extends Number> iterator;
        StatsAccumulator accumulator = new StatsAccumulator();
        accumulator.addAll(iterator);
        return var1_1.snapshot();
    }

    /*
     * WARNING - void declaration
     */
    public static Stats of(double ... values) {
        void var1_1;
        double[] dArray;
        StatsAccumulator acummulator = new StatsAccumulator();
        acummulator.addAll(dArray);
        return var1_1.snapshot();
    }

    /*
     * WARNING - void declaration
     */
    public static Stats of(int ... values) {
        void var1_1;
        int[] nArray;
        StatsAccumulator acummulator = new StatsAccumulator();
        acummulator.addAll(nArray);
        return var1_1.snapshot();
    }

    /*
     * WARNING - void declaration
     */
    public static Stats of(long ... values) {
        void var1_1;
        long[] lArray;
        StatsAccumulator acummulator = new StatsAccumulator();
        acummulator.addAll(lArray);
        return var1_1.snapshot();
    }

    public static Stats of(DoubleStream values) {
        return values.collect(StatsAccumulator::new, StatsAccumulator::add, StatsAccumulator::addAll).snapshot();
    }

    public static Stats of(IntStream values) {
        return values.collect(StatsAccumulator::new, StatsAccumulator::add, StatsAccumulator::addAll).snapshot();
    }

    public static Stats of(LongStream values) {
        return values.collect(StatsAccumulator::new, StatsAccumulator::add, StatsAccumulator::addAll).snapshot();
    }

    public static Collector<Number, StatsAccumulator, Stats> toStats() {
        return Collector.of(StatsAccumulator::new, (a, x) -> {
            void var1_1;
            a.add(var1_1.doubleValue());
        }, (l, r) -> {
            StatsAccumulator statsAccumulator;
            void var1_1;
            l.addAll((StatsAccumulator)var1_1);
            return statsAccumulator;
        }, StatsAccumulator::snapshot, Collector.Characteristics.UNORDERED);
    }

    public final long count() {
        return this.count;
    }

    public final double mean() {
        Preconditions.checkState(this.count != 0L);
        return this.mean;
    }

    public final double sum() {
        return this.mean * (double)this.count;
    }

    public final double populationVariance() {
        Preconditions.checkState(this.count > 0L);
        if (Double.isNaN(this.sumOfSquaresOfDeltas)) {
            return Double.NaN;
        }
        if (this.count == 1L) {
            return 0.0;
        }
        return DoubleUtils.ensureNonNegative(this.sumOfSquaresOfDeltas) / (double)this.count();
    }

    public final double populationStandardDeviation() {
        return Math.sqrt(this.populationVariance());
    }

    public final double sampleVariance() {
        Preconditions.checkState(this.count > 1L);
        if (Double.isNaN(this.sumOfSquaresOfDeltas)) {
            return Double.NaN;
        }
        return DoubleUtils.ensureNonNegative(this.sumOfSquaresOfDeltas) / (double)(this.count - 1L);
    }

    public final double sampleStandardDeviation() {
        return Math.sqrt(this.sampleVariance());
    }

    public final double min() {
        Preconditions.checkState(this.count != 0L);
        return this.min;
    }

    public final double max() {
        Preconditions.checkState(this.count != 0L);
        return this.max;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Stats other = (Stats)obj;
        return this.count == other.count && Double.doubleToLongBits(this.mean) == Double.doubleToLongBits(other.mean) && Double.doubleToLongBits(this.sumOfSquaresOfDeltas) == Double.doubleToLongBits(other.sumOfSquaresOfDeltas) && Double.doubleToLongBits(this.min) == Double.doubleToLongBits(other.min) && Double.doubleToLongBits(this.max) == Double.doubleToLongBits(var1_1.max);
    }

    public final int hashCode() {
        return Objects.hashCode(this.count, this.mean, this.sumOfSquaresOfDeltas, this.min, this.max);
    }

    public final String toString() {
        if (this.count() > 0L) {
            return MoreObjects.toStringHelper(this).add("count", this.count).add("mean", this.mean).add("populationStandardDeviation", this.populationStandardDeviation()).add("min", this.min).add("max", this.max).toString();
        }
        return MoreObjects.toStringHelper(this).add("count", this.count).toString();
    }

    final double sumOfSquaresOfDeltas() {
        return this.sumOfSquaresOfDeltas;
    }

    public static double meanOf(Iterable<? extends Number> values) {
        return Stats.meanOf(values.iterator());
    }

    /*
     * WARNING - void declaration
     */
    public static double meanOf(Iterator<? extends Number> values) {
        void var3_2;
        Preconditions.checkArgument(values.hasNext());
        long count = 1L;
        double mean = values.next().doubleValue();
        while (values.hasNext()) {
            double value = values.next().doubleValue();
            ++count;
            if (Doubles.isFinite(value) && Doubles.isFinite(mean)) {
                mean += (value - mean) / (double)count;
                continue;
            }
            mean = StatsAccumulator.calculateNewMeanNonFinite(mean, value);
        }
        return (double)var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public static double meanOf(double ... values) {
        void var1_1;
        Preconditions.checkArgument(values.length > 0);
        double mean = values[0];
        for (int index = 1; index < values.length; ++index) {
            double value = values[index];
            if (Doubles.isFinite(value) && Doubles.isFinite(mean)) {
                mean += (value - mean) / (double)(index + 1);
                continue;
            }
            mean = StatsAccumulator.calculateNewMeanNonFinite(mean, value);
        }
        return (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static double meanOf(int ... values) {
        void var1_1;
        Preconditions.checkArgument(values.length > 0);
        double mean = values[0];
        for (int index = 1; index < values.length; ++index) {
            double value = values[index];
            if (Doubles.isFinite(value) && Doubles.isFinite(mean)) {
                mean += (value - mean) / (double)(index + 1);
                continue;
            }
            mean = StatsAccumulator.calculateNewMeanNonFinite(mean, value);
        }
        return (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static double meanOf(long ... values) {
        void var1_1;
        Preconditions.checkArgument(values.length > 0);
        double mean = values[0];
        for (int index = 1; index < values.length; ++index) {
            double value = values[index];
            if (Doubles.isFinite(value) && Doubles.isFinite(mean)) {
                mean += (value - mean) / (double)(index + 1);
                continue;
            }
            mean = StatsAccumulator.calculateNewMeanNonFinite(mean, value);
        }
        return (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] toByteArray() {
        void var1_1;
        ByteBuffer buff = ByteBuffer.allocate(40).order(ByteOrder.LITTLE_ENDIAN);
        this.writeTo(buff);
        return var1_1.array();
    }

    /*
     * WARNING - void declaration
     */
    final void writeTo(ByteBuffer buffer) {
        void var1_1;
        Preconditions.checkNotNull(buffer);
        Preconditions.checkArgument(buffer.remaining() >= 40, "Expected at least Stats.BYTES = %s remaining , got %s", 40, buffer.remaining());
        var1_1.putLong(this.count).putDouble(this.mean).putDouble(this.sumOfSquaresOfDeltas).putDouble(this.min).putDouble(this.max);
    }

    public static Stats fromByteArray(byte[] byteArray) {
        byte[] byArray;
        Preconditions.checkNotNull(byteArray);
        Preconditions.checkArgument(byteArray.length == 40, "Expected Stats.BYTES = %s remaining , got %s", 40, byteArray.length);
        return Stats.readFrom(ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN));
    }

    static Stats readFrom(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        Preconditions.checkNotNull(buffer);
        Preconditions.checkArgument(buffer.remaining() >= 40, "Expected at least Stats.BYTES = %s remaining , got %s", 40, buffer.remaining());
        return new Stats(buffer.getLong(), buffer.getDouble(), buffer.getDouble(), buffer.getDouble(), byteBuffer.getDouble());
    }
}

