/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.math.ElementTypesAreNonnullByDefault;
import com.google.common.math.LongMath;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class Quantiles {
    public static ScaleAndIndex median() {
        return Quantiles.scale(2).index(1);
    }

    public static Scale quartiles() {
        return Quantiles.scale(4);
    }

    public static Scale percentiles() {
        return Quantiles.scale(100);
    }

    public static Scale scale(int scale) {
        int n;
        return new Scale(n);
    }

    private static boolean containsNaN(double ... dataset) {
        double[] dArray = dataset;
        int n = dataset.length;
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            if (!Double.isNaN(d)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static double interpolate(double lower, double upper, double remainder, double scale) {
        double d;
        void var2_1;
        if (lower == Double.NEGATIVE_INFINITY) {
            if (upper == Double.POSITIVE_INFINITY) {
                return Double.NaN;
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (upper == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        return lower + (var2_1 - d) * remainder / scale;
    }

    /*
     * WARNING - void declaration
     */
    private static void checkIndex(int index, int scale) {
        int n;
        if (index < 0 || n > scale) {
            void var1_1;
            throw new IllegalArgumentException(new StringBuilder(70).append("Quantile indexes must be between 0 and the scale, which is ").append((int)var1_1).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static double[] longsToDoubles(long[] longs) {
        void var2_2;
        int len = longs.length;
        double[] doubles = new double[len];
        for (int i = 0; i < len; ++i) {
            doubles[i] = longs[i];
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static double[] intsToDoubles(int[] ints) {
        void var2_2;
        int len = ints.length;
        double[] doubles = new double[len];
        for (int i = 0; i < len; ++i) {
            doubles[i] = ints[i];
        }
        return var2_2;
    }

    private static void selectInPlace(int required, double[] array, int from, int to) {
        if (required == from) {
            int min = from;
            for (int index = from + 1; index <= to; ++index) {
                if (!(array[min] > array[index])) continue;
                min = index;
            }
            if (min != from) {
                Quantiles.swap(array, min, from);
            }
            return;
        }
        while (to > from) {
            int n;
            int partitionPoint = Quantiles.partition(array, from, to);
            if (partitionPoint >= n) {
                to = partitionPoint - 1;
            }
            if (partitionPoint > n) continue;
            from = partitionPoint + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int partition(double[] array, int from, int to) {
        void var1_1;
        double[] dArray;
        void i;
        Quantiles.movePivotToStartOfSlice(array, from, to);
        double pivot = array[from];
        int partitionPoint = to;
        while (i > from) {
            if (array[i] > pivot) {
                Quantiles.swap(array, partitionPoint, (int)i);
                --partitionPoint;
            }
            --i;
        }
        Quantiles.swap(dArray, (int)var1_1, partitionPoint);
        return partitionPoint;
    }

    /*
     * WARNING - void declaration
     */
    private static void movePivotToStartOfSlice(double[] array, int from, int to) {
        boolean toLessThanFrom;
        int mid = from + to >>> 1;
        boolean toLessThanMid = array[to] < array[mid];
        boolean midLessThanFrom = array[mid] < array[from];
        boolean bl = toLessThanFrom = array[to] < array[from];
        if (toLessThanMid == midLessThanFrom) {
            void var3_3;
            Quantiles.swap(array, (int)var3_3, from);
            return;
        }
        if (toLessThanMid != toLessThanFrom) {
            void var2_2;
            void var1_1;
            double[] dArray;
            Quantiles.swap(dArray, (int)var1_1, (int)var2_2);
        }
    }

    private static void selectAllInPlace(int[] allRequired, int requiredFrom, int requiredTo, double[] array, int from, int to) {
        while (true) {
            int requiredAbove;
            int requiredBelow;
            int requiredChosen = Quantiles.chooseNextSelection(allRequired, requiredFrom, requiredTo, from, to);
            int required = allRequired[requiredChosen];
            Quantiles.selectInPlace(required, array, from, to);
            for (requiredBelow = requiredChosen - 1; requiredBelow >= requiredFrom && allRequired[requiredBelow] == required; --requiredBelow) {
            }
            if (requiredBelow >= requiredFrom) {
                Quantiles.selectAllInPlace(allRequired, requiredFrom, requiredBelow, array, from, required - 1);
            }
            for (requiredAbove = requiredChosen + 1; requiredAbove <= requiredTo && allRequired[requiredAbove] == required; ++requiredAbove) {
            }
            if (requiredAbove > requiredTo) break;
            from = required + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int chooseNextSelection(int[] allRequired, int requiredFrom, int requiredTo, int from, int to) {
        void var1_1;
        int[] nArray;
        void var3_3;
        void low;
        void high;
        if (requiredFrom == requiredTo) {
            return requiredFrom;
        }
        int centerFloor = from + to >>> 1;
        while (high > low + true) {
            void mid = low + high >>> 1;
            if (allRequired[mid] > centerFloor) {
                high = mid;
                continue;
            }
            if (allRequired[mid] < centerFloor) {
                low = mid;
                continue;
            }
            return (int)mid;
        }
        if (var3_3 + to - allRequired[low] - nArray[high] > 0) {
            void var2_2;
            return (int)var2_2;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static void swap(double[] array, int i, int j) {
        void var3_3;
        double temp = array[i];
        array[var1_1] = array[j];
        var0[var2_2] = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(int x0, int x1) {
        void var1_1;
        Quantiles.checkIndex(x0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$700(int x0, double[] x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        Quantiles.selectInPlace(x0, (double[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ double access$800(double x0, double x1, double x2, double x3) {
        void var2_1;
        return Quantiles.interpolate(x0, (double)var2_1, x2, x3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$900(int[] x0, int x1, int x2, double[] x3, int x4, int x5) {
        void var3_3;
        void var2_2;
        void var1_1;
        Quantiles.selectAllInPlace(x0, (int)var1_1, (int)var2_2, (double[])var3_3, x4, x5);
    }

    public static final class ScaleAndIndexes {
        private final int scale;
        private final int[] indexes;

        /*
         * WARNING - void declaration
         */
        private ScaleAndIndexes(int scale, int[] indexes) {
            void var2_2;
            void var1_1;
            int[] nArray = indexes;
            int n = indexes.length;
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                Quantiles.access$300(n2, scale);
            }
            Preconditions.checkArgument(indexes.length > 0, "Indexes must be a non empty array");
            this.scale = var1_1;
            this.indexes = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final Map<Integer, Double> compute(Collection<? extends Number> dataset) {
            void var1_1;
            return this.computeInPlace(Doubles.toArray((Collection<? extends Number>)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final Map<Integer, Double> compute(double ... dataset) {
            void var1_1;
            return this.computeInPlace((double[])var1_1.clone());
        }

        /*
         * WARNING - void declaration
         */
        public final Map<Integer, Double> compute(long ... dataset) {
            void var1_1;
            return this.computeInPlace(Quantiles.longsToDoubles((long[])var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final Map<Integer, Double> compute(int ... dataset) {
            void var1_1;
            return this.computeInPlace(Quantiles.intsToDoubles((int[])var1_1));
        }

        public final Map<Integer, Double> computeInPlace(double ... dataset) {
            Preconditions.checkArgument(dataset.length > 0, "Cannot calculate quantiles of an empty dataset");
            if (Quantiles.containsNaN(dataset)) {
                LinkedHashMap<Integer, Double> nanMap = new LinkedHashMap<Integer, Double>();
                int[] nArray = this.indexes;
                int n = this.indexes.length;
                for (int i = 0; i < n; ++i) {
                    int index = nArray[i];
                    nanMap.put(index, Double.NaN);
                }
                return Collections.unmodifiableMap(nanMap);
            }
            int[] quotients = new int[this.indexes.length];
            int[] remainders = new int[this.indexes.length];
            int[] requiredSelections = new int[this.indexes.length << 1];
            int requiredSelectionsCount = 0;
            for (int i = 0; i < this.indexes.length; ++i) {
                long numerator = (long)this.indexes[i] * (long)(dataset.length - 1);
                int quotient = (int)LongMath.divide(numerator, this.scale, RoundingMode.DOWN);
                int remainder = (int)(numerator - (long)quotient * (long)this.scale);
                quotients[i] = quotient;
                remainders[i] = remainder;
                requiredSelections[requiredSelectionsCount] = quotient;
                ++requiredSelectionsCount;
                if (remainder == 0) continue;
                requiredSelections[requiredSelectionsCount] = quotient + 1;
                ++requiredSelectionsCount;
            }
            Arrays.sort(requiredSelections, 0, requiredSelectionsCount);
            Quantiles.access$900(requiredSelections, 0, requiredSelectionsCount - 1, dataset, 0, dataset.length - 1);
            LinkedHashMap<Integer, Double> ret = new LinkedHashMap<Integer, Double>();
            for (int i = 0; i < this.indexes.length; ++i) {
                int quotient = quotients[i];
                int remainder = remainders[i];
                if (remainder == 0) {
                    ret.put(this.indexes[i], dataset[quotient]);
                    continue;
                }
                ret.put(this.indexes[i], Quantiles.access$800(dataset[quotient], dataset[quotient + 1], remainder, this.scale));
            }
            return Collections.unmodifiableMap(ret);
        }
    }

    public static final class ScaleAndIndex {
        private final int scale;
        private final int index;

        /*
         * WARNING - void declaration
         */
        private ScaleAndIndex(int scale, int index) {
            void var2_2;
            void var1_1;
            Quantiles.access$300(index, scale);
            this.scale = var1_1;
            this.index = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final double compute(Collection<? extends Number> dataset) {
            void var1_1;
            return this.computeInPlace(Doubles.toArray((Collection<? extends Number>)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final double compute(double ... dataset) {
            void var1_1;
            return this.computeInPlace((double[])var1_1.clone());
        }

        /*
         * WARNING - void declaration
         */
        public final double compute(long ... dataset) {
            void var1_1;
            return this.computeInPlace(Quantiles.longsToDoubles((long[])var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final double compute(int ... dataset) {
            void var1_1;
            return this.computeInPlace(Quantiles.intsToDoubles((int[])var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final double computeInPlace(double ... dataset) {
            void var2_3;
            void var1_1;
            Preconditions.checkArgument(dataset.length > 0, "Cannot calculate quantiles of an empty dataset");
            if (Quantiles.containsNaN(dataset)) {
                return Double.NaN;
            }
            long numerator = (long)this.index * (long)(dataset.length - 1);
            int quotient = (int)LongMath.divide(numerator, this.scale, RoundingMode.DOWN);
            int remainder = (int)(numerator - (long)quotient * (long)this.scale);
            Quantiles.access$700(quotient, dataset, 0, dataset.length - 1);
            if (remainder == 0) {
                return dataset[quotient];
            }
            Quantiles.access$700(quotient + 1, dataset, quotient + 1, dataset.length - 1);
            return Quantiles.access$800(dataset[quotient], (double)var1_1[quotient + 1], (double)var2_3, this.scale);
        }
    }

    public static final class Scale {
        private final int scale;

        /*
         * WARNING - void declaration
         */
        private Scale(int scale) {
            void var1_1;
            Preconditions.checkArgument(scale > 0, "Quantile scale must be positive");
            this.scale = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final ScaleAndIndex index(int index) {
            void var1_1;
            return new ScaleAndIndex(this.scale, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final ScaleAndIndexes indexes(int ... indexes) {
            void var1_1;
            return new ScaleAndIndexes(this.scale, (int[])var1_1.clone());
        }

        /*
         * WARNING - void declaration
         */
        public final ScaleAndIndexes indexes(Collection<Integer> indexes) {
            void var1_1;
            return new ScaleAndIndexes(this.scale, Ints.toArray((Collection<? extends Number>)var1_1));
        }
    }
}

