/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.math.ElementTypesAreNonnullByDefault;
import com.google.common.math.LinearTransformation;
import com.google.common.math.PairedStats;
import com.google.common.math.Stats;
import com.google.common.math.StatsAccumulator;
import com.google.common.primitives.Doubles;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class PairedStatsAccumulator {
    private final StatsAccumulator xStats = new StatsAccumulator();
    private final StatsAccumulator yStats = new StatsAccumulator();
    private double sumOfProductsOfDeltas = 0.0;

    /*
     * WARNING - void declaration
     */
    public final void add(double x, double y) {
        void var3_2;
        this.xStats.add(x);
        if (Doubles.isFinite(x) && Doubles.isFinite(y)) {
            if (this.xStats.count() > 1L) {
                void var1_1;
                this.sumOfProductsOfDeltas += (var1_1 - this.xStats.mean()) * (y - this.yStats.mean());
            }
        } else {
            this.sumOfProductsOfDeltas = Double.NaN;
        }
        this.yStats.add((double)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void addAll(PairedStats values) {
        void var1_1;
        if (values.count() == 0L) {
            return;
        }
        this.xStats.addAll(values.xStats());
        this.sumOfProductsOfDeltas = this.yStats.count() == 0L ? values.sumOfProductsOfDeltas() : (this.sumOfProductsOfDeltas += values.sumOfProductsOfDeltas() + (values.xStats().mean() - this.xStats.mean()) * (values.yStats().mean() - this.yStats.mean()) * (double)values.count());
        this.yStats.addAll(var1_1.yStats());
    }

    public final PairedStats snapshot() {
        return new PairedStats(this.xStats.snapshot(), this.yStats.snapshot(), this.sumOfProductsOfDeltas);
    }

    public final long count() {
        return this.xStats.count();
    }

    public final Stats xStats() {
        return this.xStats.snapshot();
    }

    public final Stats yStats() {
        return this.yStats.snapshot();
    }

    public final double populationCovariance() {
        Preconditions.checkState(this.count() != 0L);
        return this.sumOfProductsOfDeltas / (double)this.count();
    }

    public final double sampleCovariance() {
        Preconditions.checkState(this.count() > 1L);
        return this.sumOfProductsOfDeltas / (double)(this.count() - 1L);
    }

    /*
     * WARNING - void declaration
     */
    public final double pearsonsCorrelationCoefficient() {
        void var3_2;
        void var1_1;
        Preconditions.checkState(this.count() > 1L);
        if (Double.isNaN(this.sumOfProductsOfDeltas)) {
            return Double.NaN;
        }
        double xSumOfSquaresOfDeltas = this.xStats.sumOfSquaresOfDeltas();
        double ySumOfSquaresOfDeltas = this.yStats.sumOfSquaresOfDeltas();
        Preconditions.checkState(xSumOfSquaresOfDeltas > 0.0);
        Preconditions.checkState(ySumOfSquaresOfDeltas > 0.0);
        double productOfSumsOfSquaresOfDeltas = this.ensurePositive((double)(var1_1 * var3_2));
        return PairedStatsAccumulator.ensureInUnitRange(this.sumOfProductsOfDeltas / Math.sqrt(productOfSumsOfSquaresOfDeltas));
    }

    /*
     * WARNING - void declaration
     */
    public final LinearTransformation leastSquaresFit() {
        double d;
        Preconditions.checkState(this.count() > 1L);
        if (Double.isNaN(this.sumOfProductsOfDeltas)) {
            return LinearTransformation.forNaN();
        }
        double xSumOfSquaresOfDeltas = this.xStats.sumOfSquaresOfDeltas();
        if (d > 0.0) {
            if (this.yStats.sumOfSquaresOfDeltas() > 0.0) {
                void var1_1;
                return LinearTransformation.mapping(this.xStats.mean(), this.yStats.mean()).withSlope(this.sumOfProductsOfDeltas / var1_1);
            }
            return LinearTransformation.horizontal(this.yStats.mean());
        }
        Preconditions.checkState(this.yStats.sumOfSquaresOfDeltas() > 0.0);
        return LinearTransformation.vertical(this.xStats.mean());
    }

    /*
     * WARNING - void declaration
     */
    private double ensurePositive(double value) {
        if (value > 0.0) {
            void var1_1;
            return (double)var1_1;
        }
        return Double.MIN_VALUE;
    }

    private static double ensureInUnitRange(double value) {
        return Doubles.constrainToRange(value, -1.0, 1.0);
    }
}

