/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.math.ElementTypesAreNonnullByDefault;
import com.google.common.math.LinearTransformation;
import com.google.common.math.Stats;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class PairedStats
implements Serializable {
    private final Stats xStats;
    private final Stats yStats;
    private final double sumOfProductsOfDeltas;
    private static final int BYTES = 88;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    PairedStats(Stats xStats, Stats yStats, double sumOfProductsOfDeltas) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.xStats = var1_1;
        this.yStats = var2_2;
        this.sumOfProductsOfDeltas = var3_3;
    }

    public final long count() {
        return this.xStats.count();
    }

    public final Stats xStats() {
        return this.xStats;
    }

    public final Stats yStats() {
        return this.yStats;
    }

    public final double populationCovariance() {
        Preconditions.checkState(this.count() != 0L);
        return this.sumOfProductsOfDeltas / (double)this.count();
    }

    public final double sampleCovariance() {
        Preconditions.checkState(this.count() > 1L);
        return this.sumOfProductsOfDeltas / (double)(this.count() - 1L);
    }

    /*
     * WARNING - void declaration
     */
    public final double pearsonsCorrelationCoefficient() {
        void var3_2;
        void var1_1;
        Preconditions.checkState(this.count() > 1L);
        if (Double.isNaN(this.sumOfProductsOfDeltas)) {
            return Double.NaN;
        }
        double xSumOfSquaresOfDeltas = this.xStats().sumOfSquaresOfDeltas();
        double ySumOfSquaresOfDeltas = this.yStats().sumOfSquaresOfDeltas();
        Preconditions.checkState(xSumOfSquaresOfDeltas > 0.0);
        Preconditions.checkState(ySumOfSquaresOfDeltas > 0.0);
        double productOfSumsOfSquaresOfDeltas = PairedStats.ensurePositive((double)(var1_1 * var3_2));
        return PairedStats.ensureInUnitRange(this.sumOfProductsOfDeltas / Math.sqrt(productOfSumsOfSquaresOfDeltas));
    }

    /*
     * WARNING - void declaration
     */
    public final LinearTransformation leastSquaresFit() {
        double d;
        Preconditions.checkState(this.count() > 1L);
        if (Double.isNaN(this.sumOfProductsOfDeltas)) {
            return LinearTransformation.forNaN();
        }
        double xSumOfSquaresOfDeltas = this.xStats.sumOfSquaresOfDeltas();
        if (d > 0.0) {
            if (this.yStats.sumOfSquaresOfDeltas() > 0.0) {
                void var1_1;
                return LinearTransformation.mapping(this.xStats.mean(), this.yStats.mean()).withSlope(this.sumOfProductsOfDeltas / var1_1);
            }
            return LinearTransformation.horizontal(this.yStats.mean());
        }
        Preconditions.checkState(this.yStats.sumOfSquaresOfDeltas() > 0.0);
        return LinearTransformation.vertical(this.xStats.mean());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PairedStats other = (PairedStats)obj;
        return this.xStats.equals(other.xStats) && this.yStats.equals(other.yStats) && Double.doubleToLongBits(this.sumOfProductsOfDeltas) == Double.doubleToLongBits(var1_1.sumOfProductsOfDeltas);
    }

    public final int hashCode() {
        return Objects.hashCode(this.xStats, this.yStats, this.sumOfProductsOfDeltas);
    }

    public final String toString() {
        if (this.count() > 0L) {
            return MoreObjects.toStringHelper(this).add("xStats", this.xStats).add("yStats", this.yStats).add("populationCovariance", this.populationCovariance()).toString();
        }
        return MoreObjects.toStringHelper(this).add("xStats", this.xStats).add("yStats", this.yStats).toString();
    }

    final double sumOfProductsOfDeltas() {
        return this.sumOfProductsOfDeltas;
    }

    private static double ensurePositive(double value) {
        if (value > 0.0) {
            double d;
            return d;
        }
        return Double.MIN_VALUE;
    }

    private static double ensureInUnitRange(double value) {
        double d;
        if (value >= 1.0) {
            return 1.0;
        }
        if (value <= -1.0) {
            return -1.0;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] toByteArray() {
        void var1_1;
        ByteBuffer buffer = ByteBuffer.allocate(88).order(ByteOrder.LITTLE_ENDIAN);
        this.xStats.writeTo(buffer);
        this.yStats.writeTo(buffer);
        buffer.putDouble(this.sumOfProductsOfDeltas);
        return var1_1.array();
    }

    /*
     * WARNING - void declaration
     */
    public static PairedStats fromByteArray(byte[] byteArray) {
        void var2_2;
        void var1_1;
        Object object;
        Preconditions.checkNotNull(byteArray);
        Preconditions.checkArgument(byteArray.length == 88, "Expected PairedStats.BYTES = %s, got %s", 88, byteArray.length);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray).order(ByteOrder.LITTLE_ENDIAN);
        Object buffer = byteBuffer;
        Stats xStats = Stats.readFrom(byteBuffer);
        Stats yStats = Stats.readFrom((ByteBuffer)buffer);
        double sumOfProductsOfDeltas = ((ByteBuffer)object).getDouble();
        return new PairedStats((Stats)var1_1, (Stats)var2_2, sumOfProductsOfDeltas);
    }
}

