/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.math.ElementTypesAreNonnullByDefault;
import java.math.BigInteger;
import java.math.RoundingMode;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class MathPreconditions {
    /*
     * WARNING - void declaration
     */
    static int checkPositive(String role, int x) {
        void var1_1;
        if (x <= 0) {
            String string;
            throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(role).length()).append(string).append(" (").append(x).append(") must be > 0").toString());
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static long checkPositive(String role, long x) {
        void var1_1;
        if (x <= 0L) {
            String string;
            throw new IllegalArgumentException(new StringBuilder(35 + String.valueOf(role).length()).append(string).append(" (").append(x).append(") must be > 0").toString());
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static BigInteger checkPositive(String role, BigInteger x) {
        void var1_1;
        if (((BigInteger)x).signum() <= 0) {
            String string;
            x = String.valueOf(x);
            throw new IllegalArgumentException(new StringBuilder(15 + String.valueOf(role).length() + String.valueOf(x).length()).append(string).append(" (").append((String)x).append(") must be > 0").toString());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static int checkNonNegative(String role, int x) {
        void var1_1;
        if (x < 0) {
            String string;
            throw new IllegalArgumentException(new StringBuilder(27 + String.valueOf(role).length()).append(string).append(" (").append(x).append(") must be >= 0").toString());
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static long checkNonNegative(String role, long x) {
        void var1_1;
        if (x < 0L) {
            String string;
            throw new IllegalArgumentException(new StringBuilder(36 + String.valueOf(role).length()).append(string).append(" (").append(x).append(") must be >= 0").toString());
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static BigInteger checkNonNegative(String role, BigInteger x) {
        void var1_1;
        if (((BigInteger)x).signum() < 0) {
            String string;
            x = String.valueOf(x);
            throw new IllegalArgumentException(new StringBuilder(16 + String.valueOf(role).length() + String.valueOf(x).length()).append(string).append(" (").append((String)x).append(") must be >= 0").toString());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static double checkNonNegative(String role, double x) {
        void var1_1;
        if (!(x >= 0.0)) {
            String string;
            throw new IllegalArgumentException(new StringBuilder(40 + String.valueOf(role).length()).append(string).append(" (").append(x).append(") must be >= 0").toString());
        }
        return (double)var1_1;
    }

    static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    /*
     * WARNING - void declaration
     */
    static void checkInRangeForRoundingInputs(boolean condition, double input, RoundingMode mode) {
        if (!condition) {
            void var1_2;
            void var3_3;
            String string = String.valueOf(var3_3);
            throw new ArithmeticException(new StringBuilder(83 + String.valueOf(string).length()).append("rounded value is out of range for input ").append((double)var1_2).append(" and rounding mode ").append(string).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    static void checkNoOverflow(boolean condition, String methodName, int a, int b) {
        if (!condition) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw new ArithmeticException(new StringBuilder(36 + String.valueOf(methodName).length()).append("overflow: ").append((String)var1_1).append("(").append((int)var2_2).append(", ").append((int)var3_3).append(")").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    static void checkNoOverflow(boolean condition, String methodName, long a, long b) {
        if (!condition) {
            void var2_2;
            void var1_1;
            throw new ArithmeticException(new StringBuilder(54 + String.valueOf(methodName).length()).append("overflow: ").append((String)var1_1).append("(").append((long)var2_2).append(", ").append(b).append(")").toString());
        }
    }

    private MathPreconditions() {
    }
}

