/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.math.DoubleUtils;
import com.google.common.math.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public abstract class LinearTransformation {
    /*
     * WARNING - void declaration
     */
    public static LinearTransformationBuilder mapping(double x1, double y1) {
        void var2_1;
        double d;
        Preconditions.checkArgument(DoubleUtils.isFinite(x1) && DoubleUtils.isFinite(y1));
        return new LinearTransformationBuilder(d, (double)var2_1);
    }

    public static LinearTransformation vertical(double x) {
        double d;
        Preconditions.checkArgument(DoubleUtils.isFinite(x));
        return new VerticalLinearTransformation(d);
    }

    public static LinearTransformation horizontal(double y) {
        double d;
        Preconditions.checkArgument(DoubleUtils.isFinite(y));
        return new RegularLinearTransformation(0.0, d);
    }

    public static LinearTransformation forNaN() {
        return NaNLinearTransformation.INSTANCE;
    }

    public abstract boolean isVertical();

    public abstract boolean isHorizontal();

    public abstract double slope();

    public abstract double transform(double var1);

    public abstract LinearTransformation inverse();

    private static final class NaNLinearTransformation
    extends LinearTransformation {
        static final NaNLinearTransformation INSTANCE = new NaNLinearTransformation();

        private NaNLinearTransformation() {
        }

        @Override
        public final boolean isVertical() {
            return false;
        }

        @Override
        public final boolean isHorizontal() {
            return false;
        }

        @Override
        public final double slope() {
            return Double.NaN;
        }

        @Override
        public final double transform(double x) {
            return Double.NaN;
        }

        @Override
        public final LinearTransformation inverse() {
            return this;
        }

        public final String toString() {
            return "NaN";
        }
    }

    private static final class VerticalLinearTransformation
    extends LinearTransformation {
        final double x;
        LinearTransformation inverse;

        /*
         * WARNING - void declaration
         */
        VerticalLinearTransformation(double x) {
            void var1_1;
            this.x = var1_1;
            this.inverse = null;
        }

        /*
         * WARNING - void declaration
         */
        VerticalLinearTransformation(double x, LinearTransformation inverse) {
            void var3_2;
            void var1_1;
            this.x = var1_1;
            this.inverse = var3_2;
        }

        @Override
        public final boolean isVertical() {
            return true;
        }

        @Override
        public final boolean isHorizontal() {
            return false;
        }

        @Override
        public final double slope() {
            throw new IllegalStateException();
        }

        @Override
        public final double transform(double x) {
            throw new IllegalStateException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final LinearTransformation inverse() {
            void var1_1;
            LinearTransformation result = this.inverse;
            if (result == null) {
                this.inverse = this.createInverse();
                return this.inverse;
            }
            return var1_1;
        }

        public final String toString() {
            return String.format("x = %g", this.x);
        }

        private LinearTransformation createInverse() {
            return new RegularLinearTransformation(0.0, this.x, this);
        }
    }

    private static final class RegularLinearTransformation
    extends LinearTransformation {
        final double slope;
        final double yIntercept;
        LinearTransformation inverse;

        /*
         * WARNING - void declaration
         */
        RegularLinearTransformation(double slope, double yIntercept) {
            void var3_2;
            void var1_1;
            this.slope = var1_1;
            this.yIntercept = var3_2;
            this.inverse = null;
        }

        /*
         * WARNING - void declaration
         */
        RegularLinearTransformation(double slope, double yIntercept, LinearTransformation inverse) {
            void var3_2;
            void var1_1;
            this.slope = var1_1;
            this.yIntercept = var3_2;
            this.inverse = inverse;
        }

        @Override
        public final boolean isVertical() {
            return false;
        }

        @Override
        public final boolean isHorizontal() {
            return this.slope == 0.0;
        }

        @Override
        public final double slope() {
            return this.slope;
        }

        @Override
        public final double transform(double x) {
            return x * this.slope + this.yIntercept;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final LinearTransformation inverse() {
            void var1_1;
            LinearTransformation result = this.inverse;
            if (result == null) {
                this.inverse = this.createInverse();
                return this.inverse;
            }
            return var1_1;
        }

        public final String toString() {
            return String.format("y = %g * x + %g", this.slope, this.yIntercept);
        }

        private LinearTransformation createInverse() {
            if (this.slope != 0.0) {
                return new RegularLinearTransformation(1.0 / this.slope, -1.0 * this.yIntercept / this.slope, this);
            }
            return new VerticalLinearTransformation(this.yIntercept, this);
        }
    }

    public static final class LinearTransformationBuilder {
        private final double x1;
        private final double y1;

        /*
         * WARNING - void declaration
         */
        private LinearTransformationBuilder(double x1, double y1) {
            void var3_2;
            void var1_1;
            this.x1 = var1_1;
            this.y1 = var3_2;
        }

        /*
         * WARNING - void declaration
         */
        public final LinearTransformation and(double x2, double y2) {
            void var1_1;
            void var3_2;
            Preconditions.checkArgument(DoubleUtils.isFinite(x2) && DoubleUtils.isFinite(y2));
            if (x2 == this.x1) {
                Preconditions.checkArgument(y2 != this.y1);
                return new VerticalLinearTransformation(this.x1);
            }
            return this.withSlope((double)((var3_2 - this.y1) / (var1_1 - this.x1)));
        }

        /*
         * WARNING - void declaration
         */
        public final LinearTransformation withSlope(double slope) {
            Preconditions.checkArgument(!Double.isNaN(slope));
            if (DoubleUtils.isFinite(slope)) {
                void var3_2;
                void var1_1;
                double yIntercept = this.y1 - this.x1 * slope;
                return new RegularLinearTransformation((double)var1_1, (double)var3_2);
            }
            return new VerticalLinearTransformation(this.x1);
        }
    }
}

