/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.math.ElementTypesAreNonnullByDefault;
import com.google.common.math.LongMath;
import com.google.common.math.MathPreconditions;
import com.google.common.primitives.Ints;
import java.math.RoundingMode;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class IntMath {
    @VisibleForTesting
    static final int MAX_SIGNED_POWER_OF_TWO = 0x40000000;
    @VisibleForTesting
    static final int MAX_POWER_OF_SQRT2_UNSIGNED = -1257966797;
    @VisibleForTesting
    static final byte[] maxLog10ForLeadingZeros = new byte[]{9, 9, 9, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 1, 1, 1, 0, 0, 0, 0};
    @VisibleForTesting
    static final int[] powersOf10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    @VisibleForTesting
    static final int[] halfPowersOf10 = new int[]{3, 31, 316, 3162, 31622, 316227, 3162277, 31622776, 316227766, Integer.MAX_VALUE};
    @VisibleForTesting
    static final int FLOOR_SQRT_MAX_INT = 46340;
    private static final int[] factorials = new int[]{1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880, 3628800, 39916800, 479001600};
    @VisibleForTesting
    static int[] biggestBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, 65536, 2345, 477, 193, 110, 75, 58, 49, 43, 39, 37, 35, 34, 34, 33};

    @Beta
    public static int ceilingPowerOfTwo(int x) {
        int n;
        MathPreconditions.checkPositive("x", x);
        if (x > 0x40000000) {
            throw new ArithmeticException(new StringBuilder(58).append("ceilingPowerOfTwo(").append(x).append(") not representable as an int").toString());
        }
        return 1 << -Integer.numberOfLeadingZeros(n - 1);
    }

    @Beta
    public static int floorPowerOfTwo(int x) {
        int n;
        MathPreconditions.checkPositive("x", x);
        return Integer.highestOneBit(n);
    }

    public static boolean isPowerOfTwo(int x) {
        int n;
        int n2 = n;
        return x > 0 & (n2 & n2 - 1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static int lessThanBranchFree(int x, int y) {
        void var1_1;
        return ~(~(x - var1_1)) >>> 31;
    }

    /*
     * WARNING - void declaration
     */
    public static int log2(int x, RoundingMode mode) {
        MathPreconditions.checkPositive("x", x);
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(IntMath.isPowerOfTwo(x));
            }
            case DOWN: 
            case FLOOR: {
                return 31 - Integer.numberOfLeadingZeros(x);
            }
            case UP: 
            case CEILING: {
                return 32 - Integer.numberOfLeadingZeros(x - 1);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int n;
                void var2_3;
                int n2;
                int leadingZeros = Integer.numberOfLeadingZeros(x);
                int cmp = -1257966797 >>> leadingZeros;
                n2 = 31 - n2;
                return n2 + IntMath.lessThanBranchFree((int)var2_3, n);
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static int log10(int x, RoundingMode mode) {
        void var1_1;
        MathPreconditions.checkPositive("x", x);
        int logFloor = IntMath.log10Floor(x);
        int floorPow = powersOf10[logFloor];
        switch (1.$SwitchMap$java$math$RoundingMode[var1_1.ordinal()]) {
            case 1: {
                MathPreconditions.checkRoundingUnnecessary(x == floorPow);
            }
            case 2: 
            case 3: {
                return logFloor;
            }
            case 4: 
            case 5: {
                void var3_3;
                return logFloor + IntMath.lessThanBranchFree((int)var3_3, x);
            }
            case 6: 
            case 7: 
            case 8: {
                int n;
                void var2_2;
                return logFloor + IntMath.lessThanBranchFree(halfPowersOf10[var2_2], n);
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - void declaration
     */
    private static int log10Floor(int x) {
        void var1_1;
        int n;
        byte y = maxLog10ForLeadingZeros[Integer.numberOfLeadingZeros(x)];
        return y - IntMath.lessThanBranchFree(n, powersOf10[var1_1]);
    }

    @GwtIncompatible
    public static int pow(int b, int k) {
        MathPreconditions.checkNonNegative("exponent", k);
        switch (b) {
            case 0: {
                if (k == 0) {
                    return 1;
                }
                return 0;
            }
            case 1: {
                return 1;
            }
            case -1: {
                if ((k & 1) == 0) {
                    return 1;
                }
                return -1;
            }
            case 2: {
                if (k < 32) {
                    return 1 << k;
                }
                return 0;
            }
            case -2: {
                if (k < 32) {
                    if ((k & 1) == 0) {
                        return 1 << k;
                    }
                    return -(1 << k);
                }
                return 0;
            }
        }
        int accum = 1;
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return b * accum;
                }
            }
            accum *= (k & 1) == 0 ? 1 : b;
            int n = b;
            b = n * n;
            k >>= 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static int sqrt(int x, RoundingMode mode) {
        MathPreconditions.checkNonNegative("x", x);
        int sqrtFloor = IntMath.sqrtFloor(x);
        switch (mode) {
            case UNNECESSARY: {
                int n = sqrtFloor;
                MathPreconditions.checkRoundingUnnecessary(n * n == x);
            }
            case DOWN: 
            case FLOOR: {
                return sqrtFloor;
            }
            case UP: 
            case CEILING: {
                int n = sqrtFloor;
                return n + IntMath.lessThanBranchFree(n * sqrtFloor, x);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int n;
                void var1_2;
                void var2_3;
                int n2 = sqrtFloor;
                int halfSquare = n2 * n2 + sqrtFloor;
                return (int)(var2_3 + IntMath.lessThanBranchFree((int)var1_2, n));
            }
        }
        throw new AssertionError();
    }

    private static int sqrtFloor(int x) {
        return (int)Math.sqrt(x);
    }

    /*
     * WARNING - void declaration
     */
    public static int divide(int p, int q, RoundingMode mode) {
        void var3_3;
        void var1_1;
        Preconditions.checkNotNull(mode);
        if (q == 0) {
            throw new ArithmeticException("/ by zero");
        }
        int div = p / q;
        int rem = p - q * div;
        if (rem == 0) {
            return div;
        }
        int signum = 1 | (p ^ q) >> 31;
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(rem == 0);
            }
            case DOWN: {
                int increment = 0;
                break;
            }
            case UP: {
                int increment = 1;
                break;
            }
            case CEILING: {
                int increment = signum > 0 ? 1 : 0;
                break;
            }
            case FLOOR: {
                int increment = signum < 0 ? 1 : 0;
                break;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int increment;
                int absRem = Math.abs(rem);
                int cmpRemToHalfDivisor = absRem - (Math.abs(increment) - absRem);
                if (cmpRemToHalfDivisor == 0) {
                    void var2_2;
                    increment = mode == RoundingMode.HALF_UP || var2_2 == RoundingMode.HALF_EVEN & (div & 1) != 0 ? 1 : 0;
                    break;
                }
                increment = increment > 0 ? 1 : 0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (var1_1 != false) {
            int n;
            return div + n;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static int mod(int x, int m) {
        void var1_1;
        int n;
        if (m <= 0) {
            throw new ArithmeticException(new StringBuilder(31).append("Modulus ").append(m).append(" must be > 0").toString());
        }
        int result = x % m;
        if (result >= 0) {
            return result;
        }
        return n + var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int gcd(int a, int b) {
        void var3_3;
        void var2_2;
        int n;
        MathPreconditions.checkNonNegative("a", a);
        MathPreconditions.checkNonNegative("b", b);
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        int aTwos = Integer.numberOfTrailingZeros(a);
        a >>= aTwos;
        int bTwos = Integer.numberOfTrailingZeros(b);
        b >>= bTwos;
        while (a != b) {
            int delta = a - b;
            int minDeltaOrZero = delta & delta >> 31;
            n = n - minDeltaOrZero - minDeltaOrZero;
            b += minDeltaOrZero;
            int n2 = n;
            n = n2 >> Integer.numberOfTrailingZeros(n2);
        }
        return n << Math.min((int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static int checkedAdd(int a, int b) {
        void var2_2;
        void var1_1;
        int n;
        long result = (long)a + (long)b;
        MathPreconditions.checkNoOverflow(result == (long)((int)result), "checkedAdd", n, (int)var1_1);
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int checkedSubtract(int a, int b) {
        void var2_2;
        void var1_1;
        int n;
        long result = (long)a - (long)b;
        MathPreconditions.checkNoOverflow(result == (long)((int)result), "checkedSubtract", n, (int)var1_1);
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int checkedMultiply(int a, int b) {
        void var2_2;
        void var1_1;
        int n;
        long result = (long)a * (long)b;
        MathPreconditions.checkNoOverflow(result == (long)((int)result), "checkedMultiply", n, (int)var1_1);
        return (int)var2_2;
    }

    public static int checkedPow(int b, int k) {
        MathPreconditions.checkNonNegative("exponent", k);
        switch (b) {
            case 0: {
                if (k == 0) {
                    return 1;
                }
                return 0;
            }
            case 1: {
                return 1;
            }
            case -1: {
                if ((k & 1) == 0) {
                    return 1;
                }
                return -1;
            }
            case 2: {
                MathPreconditions.checkNoOverflow(k < 31, "checkedPow", b, k);
                return 1 << k;
            }
            case -2: {
                MathPreconditions.checkNoOverflow(k < 32, "checkedPow", b, k);
                if ((k & 1) == 0) {
                    return 1 << k;
                }
                return -1 << k;
            }
        }
        int accum = 1;
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return IntMath.checkedMultiply(accum, b);
                }
            }
            if ((k & 1) != 0) {
                accum = IntMath.checkedMultiply(accum, b);
            }
            if ((k >>= 1) <= 0) continue;
            MathPreconditions.checkNoOverflow(-46340 <= b & b <= 46340, "checkedPow", b, k);
            int n = b;
            b = n * n;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static int saturatedAdd(int a, int b) {
        void var1_1;
        return Ints.saturatedCast((long)a + (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static int saturatedSubtract(int a, int b) {
        void var1_1;
        return Ints.saturatedCast((long)a - (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static int saturatedMultiply(int a, int b) {
        void var1_1;
        return Ints.saturatedCast((long)a * (long)var1_1);
    }

    @Beta
    public static int saturatedPow(int b, int k) {
        MathPreconditions.checkNonNegative("exponent", k);
        switch (b) {
            case 0: {
                if (k == 0) {
                    return 1;
                }
                return 0;
            }
            case 1: {
                return 1;
            }
            case -1: {
                if ((k & 1) == 0) {
                    return 1;
                }
                return -1;
            }
            case 2: {
                if (k >= 31) {
                    return Integer.MAX_VALUE;
                }
                return 1 << k;
            }
            case -2: {
                if (k >= 32) {
                    return Integer.MAX_VALUE + (k & 1);
                }
                if ((k & 1) == 0) {
                    return 1 << k;
                }
                return -1 << k;
            }
        }
        int accum = 1;
        int limit = Integer.MAX_VALUE + (b >>> 31 & (k & 1));
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return IntMath.saturatedMultiply(accum, b);
                }
            }
            if ((k & 1) != 0) {
                accum = IntMath.saturatedMultiply(accum, b);
            }
            if ((k >>= 1) <= 0) continue;
            if (-46340 > b | b > 46340) {
                return limit;
            }
            int n = b;
            b = n * n;
        }
    }

    public static int factorial(int n) {
        MathPreconditions.checkNonNegative("n", n);
        if (n < factorials.length) {
            int n2;
            return factorials[n2];
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public static int binomial(int n, int k) {
        void var2_2;
        MathPreconditions.checkNonNegative("n", n);
        MathPreconditions.checkNonNegative("k", k);
        Preconditions.checkArgument(k <= n, "k (%s) > n (%s)", k, n);
        if (k > n >> 1) {
            k = n - k;
        }
        if (k >= biggestBinomials.length || n > biggestBinomials[k]) {
            return Integer.MAX_VALUE;
        }
        switch (k) {
            case 0: {
                return 1;
            }
            case 1: {
                return n;
            }
        }
        long result = 1L;
        for (int i = 0; i < k; ++i) {
            result *= (long)(n - i);
            result /= (long)(i + 1);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int mean(int x, int y) {
        void var1_1;
        int n;
        return (x & y) + ((n ^ var1_1) >> 1);
    }

    @GwtIncompatible
    @Beta
    public static boolean isPrime(int n) {
        return LongMath.isPrime(n);
    }

    private IntMath() {
    }
}

