/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.math.ElementTypesAreNonnullByDefault;
import java.math.BigInteger;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
final class DoubleUtils {
    static final long SIGNIFICAND_MASK = 0xFFFFFFFFFFFFFL;
    static final long EXPONENT_MASK = 0x7FF0000000000000L;
    static final long SIGN_MASK = Long.MIN_VALUE;
    static final int SIGNIFICAND_BITS = 52;
    static final int EXPONENT_BIAS = 1023;
    static final long IMPLICIT_BIT = 0x10000000000000L;
    @VisibleForTesting
    static final long ONE_BITS = 0x3FF0000000000000L;

    private DoubleUtils() {
    }

    static double nextDown(double d) {
        return -Math.nextUp(-d);
    }

    /*
     * WARNING - void declaration
     */
    static long getSignificand(double d) {
        void var2_1;
        double d2;
        Preconditions.checkArgument(DoubleUtils.isFinite(d), "not a normal value");
        int exponent = Math.getExponent(d);
        long l = Double.doubleToRawLongBits(d2);
        long bits = l & 0xFFFFFFFFFFFFFL;
        if (var2_1 == -1023) {
            return bits << 1;
        }
        return l | 0x10000000000000L;
    }

    static boolean isFinite(double d) {
        return Math.getExponent(d) <= 1023;
    }

    static boolean isNormal(double d) {
        return Math.getExponent(d) >= -1022;
    }

    static double scaleNormalize(double x) {
        long l = Double.doubleToRawLongBits(x) & 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(l | 0x3FF0000000000000L);
    }

    /*
     * WARNING - void declaration
     */
    static double bigToDouble(BigInteger x) {
        BigInteger bigInteger;
        void var2_3;
        void var3_4;
        void var1_1;
        BigInteger absX = x.abs();
        int exponent = absX.bitLength() - 1;
        if (exponent < 63) {
            return x.longValue();
        }
        if (exponent > 1023) {
            return (double)x.signum() * Double.POSITIVE_INFINITY;
        }
        int shift = exponent - 52 - 1;
        long twiceSignifFloor = absX.shiftRight(shift).longValue();
        long l = twiceSignifFloor >> 1;
        long signifFloor = l & 0xFFFFFFFFFFFFFL;
        boolean bl = (twiceSignifFloor & 1L) != 0L && ((signifFloor & 1L) != 0L || var1_1.getLowestSetBit() < var3_4);
        long signifRounded = bl ? signifFloor + 1L : signifFloor;
        long l2 = (long)(var2_3 + 1023) << 52;
        l2 += signifRounded;
        return Double.longBitsToDouble(l2 |= (long)bigInteger.signum() & Long.MIN_VALUE);
    }

    static double ensureNonNegative(double value) {
        double d;
        Preconditions.checkArgument(!Double.isNaN(value));
        return Math.max(d, 0.0);
    }
}

