/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.math.DoubleUtils;
import com.google.common.math.ElementTypesAreNonnullByDefault;
import com.google.common.math.MathPreconditions;
import com.google.common.primitives.Booleans;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Iterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class DoubleMath {
    private static final double MIN_INT_AS_DOUBLE = -2.147483648E9;
    private static final double MAX_INT_AS_DOUBLE = 2.147483647E9;
    private static final double MIN_LONG_AS_DOUBLE = -9.223372036854776E18;
    private static final double MAX_LONG_AS_DOUBLE_PLUS_ONE = 9.223372036854776E18;
    private static final double LN_2 = Math.log(2.0);
    @VisibleForTesting
    static final int MAX_FACTORIAL = 170;
    @VisibleForTesting
    static final double[] everySixteenthFactorial = new double[]{1.0, 2.0922789888E13, 2.631308369336935E35, 1.2413915592536073E61, 1.2688693218588417E89, 7.156945704626381E118, 9.916779348709496E149, 1.974506857221074E182, 3.856204823625804E215, 5.5502938327393044E249, 4.7147236359920616E284};

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    static double roundIntermediate(double x, RoundingMode mode) {
        void var2_1;
        if (!DoubleUtils.isFinite(x)) {
            throw new ArithmeticException("input is infinite or NaN");
        }
        switch (1.$SwitchMap$java$math$RoundingMode[var2_1.ordinal()]) {
            case 1: {
                MathPreconditions.checkRoundingUnnecessary(DoubleMath.isMathematicalInteger(x));
                return x;
            }
            case 2: {
                if (x >= 0.0 || DoubleMath.isMathematicalInteger(x)) {
                    return x;
                }
                return (long)x - 1L;
            }
            case 3: {
                if (x <= 0.0 || DoubleMath.isMathematicalInteger(x)) {
                    return x;
                }
                return (long)x + 1L;
            }
            case 4: {
                return x;
            }
            case 5: {
                if (DoubleMath.isMathematicalInteger(x)) {
                    return x;
                }
                return (long)x + (long)(x > 0.0 ? 1 : -1);
            }
            case 6: {
                return Math.rint(x);
            }
            case 7: {
                double z = Math.rint(x);
                if (Math.abs(x - z) == 0.5) {
                    return x + Math.copySign(0.5, x);
                }
                return z;
            }
            case 8: {
                void var3_3;
                double z = Math.rint(x);
                if (Math.abs(x - z) == 0.5) {
                    double d;
                    return d;
                }
                return (double)var3_3;
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static int roundToInt(double x, RoundingMode mode) {
        void var3_2;
        void var2_1;
        double d;
        double d2;
        double z = DoubleMath.roundIntermediate(x, mode);
        MathPreconditions.checkInRangeForRoundingInputs(d2 > -2.147483649E9 & z < 2.147483648E9, d, (RoundingMode)var2_1);
        return (int)var3_2;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static long roundToLong(double x, RoundingMode mode) {
        void var3_2;
        void var2_1;
        double d;
        double z = DoubleMath.roundIntermediate(x, mode);
        MathPreconditions.checkInRangeForRoundingInputs(-9.223372036854776E18 - z < 1.0 & z < 9.223372036854776E18, d, (RoundingMode)var2_1);
        return (long)var3_2;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static BigInteger roundToBigInteger(double x, RoundingMode mode) {
        void var2_3;
        double d;
        if (-9.223372036854776E18 - (x = DoubleMath.roundIntermediate(x, mode)) < 1.0 & x < 9.223372036854776E18) {
            return BigInteger.valueOf((long)x);
        }
        int exponent = Math.getExponent(x);
        long l = DoubleUtils.getSignificand(x);
        BigInteger result = BigInteger.valueOf(l).shiftLeft(exponent - 52);
        if (d < 0.0) {
            return result.negate();
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static boolean isPowerOfTwo(double x) {
        if (x > 0.0 && DoubleUtils.isFinite(x)) {
            void var2_1;
            double d;
            long significand = DoubleUtils.getSignificand(d);
            return (significand & var2_1 - 1L) == 0L;
        }
        return false;
    }

    public static double log2(double x) {
        return Math.log(x) / LN_2;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static int log2(double x, RoundingMode mode) {
        void var3_3;
        void var0_1;
        void var2_2;
        Preconditions.checkArgument(x > 0.0 && DoubleUtils.isFinite(x), "x must be positive and finite");
        int exponent = Math.getExponent(x);
        if (!DoubleUtils.isNormal(x)) {
            return DoubleMath.log2(x * 4.503599627370496E15, mode) - 52;
        }
        switch (1.$SwitchMap$java$math$RoundingMode[var2_2.ordinal()]) {
            case 1: {
                MathPreconditions.checkRoundingUnnecessary(DoubleMath.isPowerOfTwo(x));
            }
            case 2: {
                boolean increment52222 = false;
                break;
            }
            case 3: {
                double increment52222;
                boolean increment52222 = !DoubleMath.isPowerOfTwo(increment52222);
                break;
            }
            case 4: {
                double increment52222;
                boolean increment52222 = exponent < 0 & !DoubleMath.isPowerOfTwo(increment52222);
                break;
            }
            case 5: {
                double increment52222;
                boolean increment52222 = exponent >= 0 & !DoubleMath.isPowerOfTwo(increment52222);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                double d;
                double increment52222;
                double xScaled = DoubleUtils.scaleNormalize(increment52222);
                boolean increment52222 = d * xScaled > 2.0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (var0_1 != false) {
            return exponent + 1;
        }
        return (int)var3_3;
    }

    @GwtIncompatible
    public static boolean isMathematicalInteger(double x) {
        double d;
        return DoubleUtils.isFinite(x) && (x == 0.0 || 52 - Long.numberOfTrailingZeros(DoubleUtils.getSignificand(x)) <= Math.getExponent(d));
    }

    /*
     * WARNING - void declaration
     */
    public static double factorial(int n) {
        int n2;
        void var1_1;
        MathPreconditions.checkNonNegative("n", n);
        if (n > 170) {
            return Double.POSITIVE_INFINITY;
        }
        double accum = 1.0;
        for (int i = 1 + (n & 0xFFFFFFF0); i <= n; ++i) {
            accum *= (double)i;
        }
        return (double)(var1_1 * everySixteenthFactorial[n2 >> 4]);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean fuzzyEquals(double a, double b, double tolerance) {
        void var2_2;
        double d;
        MathPreconditions.checkNonNegative("tolerance", tolerance);
        return Math.copySign(a - b, 1.0) <= tolerance || a == b || Double.isNaN(d) && Double.isNaN((double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int fuzzyCompare(double a, double b, double tolerance) {
        void var2_2;
        double d;
        if (DoubleMath.fuzzyEquals(a, b, tolerance)) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return Booleans.compare(Double.isNaN(d), Double.isNaN((double)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @GwtIncompatible
    public static double mean(double ... values) {
        void var3_2;
        Preconditions.checkArgument(values.length > 0, "Cannot take mean of 0 values");
        long count = 1L;
        double mean = DoubleMath.checkFinite(values[0]);
        for (int index = 1; index < values.length; ++index) {
            DoubleMath.checkFinite(values[index]);
            mean += (values[index] - mean) / (double)(++count);
        }
        return (double)var3_2;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static double mean(int ... values) {
        int[] nArray;
        void var1_1;
        Preconditions.checkArgument(values.length > 0, "Cannot take mean of 0 values");
        long sum = 0L;
        for (int index = 0; index < values.length; ++index) {
            sum += (long)values[index];
        }
        return (double)var1_1 / (double)nArray.length;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static double mean(long ... values) {
        void var3_2;
        Preconditions.checkArgument(values.length > 0, "Cannot take mean of 0 values");
        long count = 1L;
        double mean = values[0];
        for (int index = 1; index < values.length; ++index) {
            mean += ((double)values[index] - mean) / (double)(++count);
        }
        return (double)var3_2;
    }

    @Deprecated
    @GwtIncompatible
    public static double mean(Iterable<? extends Number> values) {
        return DoubleMath.mean(values.iterator());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @GwtIncompatible
    public static double mean(Iterator<? extends Number> values) {
        void var3_2;
        Preconditions.checkArgument(values.hasNext(), "Cannot take mean of 0 values");
        long count = 1L;
        double mean = DoubleMath.checkFinite(values.next().doubleValue());
        while (values.hasNext()) {
            double value = DoubleMath.checkFinite(values.next().doubleValue());
            mean += (value - mean) / (double)(++count);
        }
        return (double)var3_2;
    }

    @GwtIncompatible
    private static double checkFinite(double argument) {
        double d;
        Preconditions.checkArgument(DoubleUtils.isFinite(argument));
        return d;
    }

    private DoubleMath() {
    }
}

