/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.io.LineProcessor;
import com.google.common.io.ParametricNullness;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class Resources {
    private Resources() {
    }

    public static ByteSource asByteSource(URL url) {
        URL uRL;
        return new UrlByteSource(uRL);
    }

    /*
     * WARNING - void declaration
     */
    public static CharSource asCharSource(URL url, Charset charset) {
        void var1_1;
        return Resources.asByteSource(url).asCharSource((Charset)var1_1);
    }

    public static byte[] toByteArray(URL url) throws IOException {
        return Resources.asByteSource(url).read();
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(URL url, Charset charset) throws IOException {
        void var1_1;
        return Resources.asCharSource(url, (Charset)var1_1).read();
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public static <T> T readLines(URL url, Charset charset, LineProcessor<T> callback) throws IOException {
        void var2_2;
        void var1_1;
        return Resources.asCharSource(url, (Charset)var1_1).readLines(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> readLines(URL url, Charset charset) throws IOException {
        void var1_1;
        return Resources.readLines(url, (Charset)var1_1, new LineProcessor<List<String>>(){
            final List<String> result = Lists.newArrayList();

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean processLine(String line) {
                void var1_1;
                this.result.add((String)var1_1);
                return true;
            }

            @Override
            public List<String> getResult() {
                return this.result;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void copy(URL from, OutputStream to) throws IOException {
        void var1_1;
        Resources.asByteSource(from).copyTo((OutputStream)var1_1);
    }

    public static URL getResource(String resourceName) {
        String string;
        ClassLoader classLoader = MoreObjects.firstNonNull(Thread.currentThread().getContextClassLoader(), Resources.class.getClassLoader());
        URL url = classLoader.getResource(resourceName);
        Preconditions.checkArgument(url != null, "resource %s not found.", (Object)string);
        return classLoader;
    }

    /*
     * WARNING - void declaration
     */
    public static URL getResource(Class<?> contextClass, String resourceName) {
        void var2_2;
        Class<?> clazz;
        void var1_1;
        URL url = contextClass.getResource(resourceName);
        Preconditions.checkArgument(url != null, "resource %s relative to %s not found.", (Object)var1_1, (Object)clazz.getName());
        return var2_2;
    }

    private static final class UrlByteSource
    extends ByteSource {
        private final URL url;

        /*
         * WARNING - void declaration
         */
        private UrlByteSource(URL url) {
            void var1_1;
            this.url = (URL)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public final InputStream openStream() throws IOException {
            return this.url.openStream();
        }

        public final String toString() {
            String string = String.valueOf(this.url);
            return new StringBuilder(24 + String.valueOf(string).length()).append("Resources.asByteSource(").append(string).append(")").toString();
        }
    }
}

