/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.io.Java8Compatibility;
import com.google.common.primitives.UnsignedBytes;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
final class ReaderInputStream
extends InputStream {
    private final Reader reader;
    private final CharsetEncoder encoder;
    private final byte[] singleByte = new byte[1];
    private CharBuffer charBuffer;
    private ByteBuffer byteBuffer;
    private boolean endOfInput;
    private boolean draining;
    private boolean doneFlushing;

    /*
     * WARNING - void declaration
     */
    ReaderInputStream(Reader reader, Charset charset, int bufferSize) {
        this((Reader)var1_1, var2_2.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE), (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    ReaderInputStream(Reader reader, CharsetEncoder encoder, int bufferSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.reader = (Reader)Preconditions.checkNotNull(var1_1);
        this.encoder = Preconditions.checkNotNull(encoder);
        Preconditions.checkArgument(bufferSize > 0, "bufferSize must be positive: %s", bufferSize);
        var2_2.reset();
        this.charBuffer = CharBuffer.allocate(bufferSize);
        Java8Compatibility.flip(this.charBuffer);
        this.byteBuffer = ByteBuffer.allocate((int)var3_3);
    }

    @Override
    public final void close() throws IOException {
        this.reader.close();
    }

    @Override
    public final int read() throws IOException {
        ReaderInputStream readerInputStream = this;
        if (readerInputStream.read(readerInputStream.singleByte) == 1) {
            return UnsignedBytes.toInt(this.singleByte[0]);
        }
        return -1;
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        CoderResult result;
        int n = off;
        Preconditions.checkPositionIndexes(n, n + len, b.length);
        if (len == 0) {
            return 0;
        }
        int totalBytesRead = 0;
        boolean doneEncoding = this.endOfInput;
        block0: while (true) {
            if (this.draining) {
                if ((totalBytesRead += this.drain(b, off + totalBytesRead, len - totalBytesRead)) == len || this.doneFlushing) {
                    if (totalBytesRead > 0) {
                        return totalBytesRead;
                    }
                    return -1;
                }
                this.draining = false;
                Java8Compatibility.clear(this.byteBuffer);
            }
            while (true) {
                if ((result = this.doneFlushing ? CoderResult.UNDERFLOW : (doneEncoding ? this.encoder.flush(this.byteBuffer) : this.encoder.encode(this.charBuffer, this.byteBuffer, this.endOfInput))).isOverflow()) {
                    this.startDraining(true);
                    continue block0;
                }
                if (result.isUnderflow()) {
                    if (doneEncoding) {
                        this.doneFlushing = true;
                        this.startDraining(false);
                        continue block0;
                    }
                    if (this.endOfInput) {
                        doneEncoding = true;
                        continue;
                    }
                    this.readMoreChars();
                    continue;
                }
                if (result.isError()) break block0;
            }
            break;
        }
        result.throwException();
        return 0;
    }

    private static CharBuffer grow(CharBuffer buf) {
        CharBuffer charBuffer;
        char[] cArray = Arrays.copyOf(buf.array(), buf.capacity() << 1);
        CharBuffer bigger = CharBuffer.wrap(cArray);
        Java8Compatibility.position(bigger, buf.position());
        Java8Compatibility.limit(bigger, charBuffer.limit());
        return cArray;
    }

    /*
     * WARNING - void declaration
     */
    private void readMoreChars() throws IOException {
        void var2_2;
        void var1_1;
        if (ReaderInputStream.availableCapacity(this.charBuffer) == 0) {
            if (this.charBuffer.position() > 0) {
                Java8Compatibility.flip(this.charBuffer.compact());
            } else {
                this.charBuffer = ReaderInputStream.grow(this.charBuffer);
            }
        }
        int limit = this.charBuffer.limit();
        int numChars = this.reader.read(this.charBuffer.array(), limit, ReaderInputStream.availableCapacity(this.charBuffer));
        if (numChars == -1) {
            this.endOfInput = true;
            return;
        }
        Java8Compatibility.limit(this.charBuffer, (int)(var1_1 + var2_2));
    }

    private static int availableCapacity(Buffer buffer) {
        Buffer buffer2;
        return buffer.capacity() - buffer2.limit();
    }

    /*
     * WARNING - void declaration
     */
    private void startDraining(boolean overflow) {
        void var1_1;
        Java8Compatibility.flip(this.byteBuffer);
        if (var1_1 != false && this.byteBuffer.remaining() == 0) {
            this.byteBuffer = ByteBuffer.allocate(this.byteBuffer.capacity() << 1);
            return;
        }
        this.draining = true;
    }

    /*
     * WARNING - void declaration
     */
    private int drain(byte[] b, int off, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        int remaining = Math.min(len, this.byteBuffer.remaining());
        this.byteBuffer.get((byte[])var1_1, (int)var2_2, remaining);
        return (int)var3_3;
    }
}

