/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.CharSource;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
class MultiReader
extends Reader {
    private final Iterator<? extends CharSource> it;
    private Reader current;

    /*
     * WARNING - void declaration
     */
    MultiReader(Iterator<? extends CharSource> readers) throws IOException {
        void var1_1;
        this.it = var1_1;
        this.advance();
    }

    private void advance() throws IOException {
        this.close();
        if (this.it.hasNext()) {
            this.current = this.it.next().openStream();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Preconditions.checkNotNull(cbuf);
        if (this.current == null) {
            return -1;
        }
        int result = this.current.read(cbuf, off, len);
        if (result == -1) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.advance();
            return this.read((char[])var1_1, (int)var2_2, (int)var3_3);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long skip(long n) throws IOException {
        Preconditions.checkArgument(n >= 0L, "n is negative");
        if (n > 0L) {
            while (this.current != null) {
                long result = this.current.skip(n);
                if (result > 0L) {
                    void var3_2;
                    return (long)var3_2;
                }
                this.advance();
            }
        }
        return 0L;
    }

    @Override
    public boolean ready() throws IOException {
        return this.current != null && this.current.ready();
    }

    @Override
    public void close() throws IOException {
        if (this.current != null) {
            try {
                this.current.close();
                return;
            }
            finally {
                this.current = null;
            }
        }
    }
}

