/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
final class MultiInputStream
extends InputStream {
    private Iterator<? extends ByteSource> it;
    private InputStream in;

    /*
     * WARNING - void declaration
     */
    public MultiInputStream(Iterator<? extends ByteSource> it) throws IOException {
        void var1_1;
        this.it = (Iterator)Preconditions.checkNotNull(var1_1);
        this.advance();
    }

    @Override
    public final void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
                return;
            }
            finally {
                this.in = null;
            }
        }
    }

    private void advance() throws IOException {
        this.close();
        if (this.it.hasNext()) {
            this.in = this.it.next().openStream();
        }
    }

    @Override
    public final int available() throws IOException {
        if (this.in == null) {
            return 0;
        }
        return this.in.available();
    }

    @Override
    public final boolean markSupported() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int read() throws IOException {
        while (this.in != null) {
            int result = this.in.read();
            if (result != -1) {
                void var1_1;
                return (int)var1_1;
            }
            this.advance();
        }
        return -1;
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        Preconditions.checkNotNull(b);
        while (this.in != null) {
            int result = this.in.read(b, off, len);
            if (result != -1) {
                return result;
            }
            this.advance();
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long skip(long n) throws IOException {
        void var1_1;
        if (this.in == null || n <= 0L) {
            return 0L;
        }
        long result = this.in.skip(n);
        if (result != 0L) {
            void var3_2;
            return (long)var3_2;
        }
        if (this.read() == -1) {
            return 0L;
        }
        return 1L + this.in.skip((long)(var1_1 - 1L));
    }
}

