/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.io.InsecureRecursiveDeleteException;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class MoreFiles {
    private static final SuccessorsFunction<Path> FILE_TREE = new SuccessorsFunction<Path>(){

        @Override
        public Iterable<Path> successors(Path path) {
            return MoreFiles.fileTreeChildren(path);
        }
    };

    private MoreFiles() {
    }

    /*
     * WARNING - void declaration
     */
    public static ByteSource asByteSource(Path path, OpenOption ... options) {
        void var1_1;
        Path path2;
        return new PathByteSource(path2, (OpenOption[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteSink asByteSink(Path path, OpenOption ... options) {
        void var1_1;
        Path path2;
        return new PathByteSink(path2, (OpenOption[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static CharSource asCharSource(Path path, Charset charset, OpenOption ... options) {
        void var1_1;
        void var2_2;
        return MoreFiles.asByteSource(path, (OpenOption[])var2_2).asCharSource((Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static CharSink asCharSink(Path path, Charset charset, OpenOption ... options) {
        void var1_1;
        void var2_2;
        return MoreFiles.asByteSink(path, (OpenOption[])var2_2).asCharSink((Charset)var1_1);
    }

    public static ImmutableList<Path> listFiles(Path dir) throws IOException {
        ImmutableList<Path> immutableList;
        block8: {
            DirectoryStream<Path> stream = Files.newDirectoryStream(dir);
            try {
                immutableList = ImmutableList.copyOf(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                DirectoryStream<Path> directoryStream;
                try {
                    if (stream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DirectoryIteratorException directoryIteratorException) {
                    directoryStream = directoryIteratorException;
                    throw directoryIteratorException.getCause();
                }
            }
            stream.close();
        }
        return immutableList;
    }

    public static Traverser<Path> fileTraverser() {
        return Traverser.forTree(FILE_TREE);
    }

    /*
     * WARNING - void declaration
     */
    private static Iterable<Path> fileTreeChildren(Path dir) {
        if (Files.isDirectory(dir, LinkOption.NOFOLLOW_LINKS)) {
            try {
                return MoreFiles.listFiles(dir);
            }
            catch (IOException e) {
                void var0_1;
                throw new DirectoryIteratorException((IOException)var0_1);
            }
        }
        return ImmutableList.of();
    }

    public static Predicate<Path> isDirectory(LinkOption ... options) {
        LinkOption[] linkOptionArray;
        LinkOption[] optionsCopy = (LinkOption[])options.clone();
        return new Predicate<Path>(){

            @Override
            public boolean apply(Path input) {
                return Files.isDirectory(input, linkOptionArray);
            }

            public String toString() {
                String string = Arrays.toString(linkOptionArray);
                return new StringBuilder(23 + String.valueOf(string).length()).append("MoreFiles.isDirectory(").append(string).append(")").toString();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isDirectory(SecureDirectoryStream<Path> dir, Path name, LinkOption ... options) throws IOException {
        void var2_2;
        void var1_1;
        return dir.getFileAttributeView((Path)var1_1, BasicFileAttributeView.class, (LinkOption[])var2_2).readAttributes().isDirectory();
    }

    public static Predicate<Path> isRegularFile(LinkOption ... options) {
        LinkOption[] linkOptionArray;
        LinkOption[] optionsCopy = (LinkOption[])options.clone();
        return new Predicate<Path>(){

            @Override
            public boolean apply(Path input) {
                return Files.isRegularFile(input, linkOptionArray);
            }

            public String toString() {
                String string = Arrays.toString(linkOptionArray);
                return new StringBuilder(25 + String.valueOf(string).length()).append("MoreFiles.isRegularFile(").append(string).append(")").toString();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equal(Path path1, Path path2) throws IOException {
        void var1_1;
        ByteSource byteSource;
        Preconditions.checkNotNull(path1);
        Preconditions.checkNotNull(path2);
        if (Files.isSameFile(path1, path2)) {
            return true;
        }
        ByteSource source1 = MoreFiles.asByteSource(path1, new OpenOption[0]);
        ByteSource source2 = MoreFiles.asByteSource(path2, new OpenOption[0]);
        long len1 = source1.sizeIfKnown().or(0L);
        long len2 = source2.sizeIfKnown().or(0L);
        if (len1 != 0L && len2 != 0L && len1 != len2) {
            return false;
        }
        return byteSource.contentEquals((ByteSource)var1_1);
    }

    public static void touch(Path path) throws IOException {
        Preconditions.checkNotNull(path);
        try {
            Files.setLastModifiedTime(path, FileTime.fromMillis(System.currentTimeMillis()));
            return;
        }
        catch (NoSuchFileException noSuchFileException) {
            try {
                Path path2;
                Files.createFile(path2, new FileAttribute[0]);
                return;
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void createParentDirectories(Path path, FileAttribute<?> ... attrs) throws IOException {
        Path path2 = path.toAbsolutePath().normalize();
        Path parent = path2.getParent();
        if (parent == null) {
            return;
        }
        if (!Files.isDirectory(parent, new LinkOption[0])) {
            void var1_1;
            Files.createDirectories(parent, var1_1);
            if (!Files.isDirectory(path2, new LinkOption[0])) {
                String string;
                string = String.valueOf(string);
                throw new IOException(new StringBuilder(39 + String.valueOf(string).length()).append("Unable to create parent directories of ").append(string).toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getFileExtension(Path path) {
        void var1_1;
        Path path2;
        Path name = path.getFileName();
        if (name == null) {
            return "";
        }
        Path fileName = name.toString();
        int dotIndex = ((String)((Object)fileName)).lastIndexOf(46);
        if (dotIndex == -1) {
            return "";
        }
        return ((String)((Object)path2)).substring((int)(var1_1 + true));
    }

    /*
     * WARNING - void declaration
     */
    public static String getNameWithoutExtension(Path path) {
        void var1_1;
        Path path2;
        Path name = path.getFileName();
        if (name == null) {
            return "";
        }
        Path fileName = name.toString();
        int dotIndex = ((String)((Object)fileName)).lastIndexOf(46);
        if (dotIndex == -1) {
            return fileName;
        }
        return ((String)((Object)path2)).substring(0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteRecursively(Path path, RecursiveDeleteOption ... options2) throws IOException {
        void var3_5;
        Path path2;
        Path parentPath = MoreFiles.getParentPath(path);
        if (parentPath == null) {
            throw new FileSystemException(path.toString(), null, "can't delete recursively");
        }
        Collection<IOException> exceptions = null;
        try {
            boolean sdsSupported;
            block10: {
                sdsSupported = false;
                DirectoryStream<Path> parent = Files.newDirectoryStream(parentPath);
                try {
                    if (parent instanceof SecureDirectoryStream) {
                        sdsSupported = true;
                        exceptions = MoreFiles.deleteRecursivelySecure((SecureDirectoryStream)parent, Objects.requireNonNull(path.getFileName()));
                    }
                    if (parent == null) break block10;
                }
                catch (Throwable options2) {
                    if (parent == null) throw options2;
                    try {
                        void var2_3;
                        var2_3.close();
                        throw options2;
                    }
                    catch (Throwable throwable) {
                        options2.addSuppressed(throwable);
                    }
                    throw options2;
                }
                parent.close();
            }
            if (!sdsSupported) {
                void var1_1;
                MoreFiles.checkAllowsInsecure(path, (RecursiveDeleteOption[])var1_1);
                exceptions = MoreFiles.deleteRecursivelyInsecure(path);
            }
        }
        catch (IOException e) {
            if (exceptions == null) {
                throw e;
            }
            exceptions.add(e);
        }
        if (exceptions == null) return;
        MoreFiles.throwDeleteFailed(path2, (Collection<IOException>)var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public static void deleteDirectoryContents(Path path, RecursiveDeleteOption ... options) throws IOException {
        Collection<IOException> exceptions = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            if (stream instanceof SecureDirectoryStream) {
                options = (SecureDirectoryStream)stream;
                exceptions = MoreFiles.deleteDirectoryContentsSecure((SecureDirectoryStream<Path>)options);
            } else {
                void var1_1;
                MoreFiles.checkAllowsInsecure(path, (RecursiveDeleteOption[])var1_1);
                exceptions = MoreFiles.deleteDirectoryContentsInsecure(stream);
            }
        }
        catch (IOException e) {
            void var3_6;
            if (exceptions == null) {
                throw e;
            }
            exceptions.add((IOException)var3_6);
        }
        if (exceptions != null) {
            void var2_3;
            Path path2;
            MoreFiles.throwDeleteFailed(path2, (Collection<IOException>)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<IOException> deleteRecursivelySecure(SecureDirectoryStream<Path> dir, Path path) {
        Collection<IOException> exceptions = null;
        try {
            if (MoreFiles.isDirectory(dir, path, LinkOption.NOFOLLOW_LINKS)) {
                try (SecureDirectoryStream<Path> childDir = dir.newDirectoryStream(path, LinkOption.NOFOLLOW_LINKS);){
                    exceptions = MoreFiles.deleteDirectoryContentsSecure(childDir);
                }
                if (exceptions == null) {
                    dir.deleteDirectory(path);
                }
            } else {
                void var1_2;
                SecureDirectoryStream<Path> secureDirectoryStream;
                secureDirectoryStream.deleteFile((Path)var1_2);
            }
            return exceptions;
        }
        catch (IOException e) {
            void var3_6;
            void var2_4;
            return MoreFiles.addException((Collection<IOException>)var2_4, (IOException)var3_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<IOException> deleteDirectoryContentsSecure(SecureDirectoryStream<Path> dir) {
        Collection<IOException> exceptions = null;
        try {
            for (Path path : dir) {
                void var3_4;
                exceptions = MoreFiles.concat(exceptions, MoreFiles.deleteRecursivelySecure(dir, var3_4.getFileName()));
            }
            return exceptions;
        }
        catch (DirectoryIteratorException e) {
            void var2_3;
            void var1_1;
            return MoreFiles.addException((Collection<IOException>)var1_1, var2_3.getCause());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<IOException> deleteRecursivelyInsecure(Path path) {
        Collection<IOException> exceptions = null;
        try {
            if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                    exceptions = MoreFiles.deleteDirectoryContentsInsecure(stream);
                }
            }
            if (exceptions == null) {
                Path path2;
                Files.delete(path2);
            }
            return exceptions;
        }
        catch (IOException e) {
            void var2_5;
            void var1_2;
            return MoreFiles.addException((Collection<IOException>)var1_2, (IOException)var2_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<IOException> deleteDirectoryContentsInsecure(DirectoryStream<Path> dir) {
        Collection<IOException> exceptions = null;
        try {
            dir = dir.iterator();
            while (dir.hasNext()) {
                void var2_3;
                Path entry = (Path)dir.next();
                exceptions = MoreFiles.concat(exceptions, MoreFiles.deleteRecursivelyInsecure((Path)var2_3));
            }
            return exceptions;
        }
        catch (DirectoryIteratorException e) {
            void var0_1;
            void var1_2;
            return MoreFiles.addException((Collection<IOException>)var1_2, var0_1.getCause());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Path getParentPath(Path path) {
        Path path2;
        Path parent = path.getParent();
        if (parent != null) {
            void var1_1;
            return var1_1;
        }
        if (path.getNameCount() == 0) {
            return null;
        }
        return path2.getFileSystem().getPath(".", new String[0]);
    }

    private static void checkAllowsInsecure(Path path, RecursiveDeleteOption[] options) throws InsecureRecursiveDeleteException {
        if (!Arrays.asList(options).contains((Object)RecursiveDeleteOption.ALLOW_INSECURE)) {
            Path path2;
            throw new InsecureRecursiveDeleteException(path2.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<IOException> addException(Collection<IOException> exceptions, IOException e) {
        Collection<IOException> collection;
        void var1_1;
        if (exceptions == null) {
            exceptions = new ArrayList<IOException>();
        }
        exceptions.add((IOException)var1_1);
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<IOException> concat(Collection<IOException> exceptions, Collection<IOException> other) {
        Collection<IOException> collection;
        if (exceptions == null) {
            return other;
        }
        if (other != null) {
            void var1_1;
            exceptions.addAll((Collection<IOException>)var1_1);
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private static void throwDeleteFailed(Path path, Collection<IOException> exceptions) throws FileSystemException {
        FileSystemException fileSystemException;
        Iterator iterator;
        NoSuchFileException pathNotFound = MoreFiles.pathNotFound(path, exceptions);
        if (pathNotFound != null) {
            throw pathNotFound;
        }
        FileSystemException deleteFailed = new FileSystemException(path.toString(), null, "failed to delete one or more files; see suppressed exceptions for details");
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            IOException e = (IOException)iterator.next();
            deleteFailed.addSuppressed((Throwable)var2_2);
        }
        throw fileSystemException;
    }

    /*
     * WARNING - void declaration
     */
    private static NoSuchFileException pathNotFound(Path path, Collection<IOException> exceptions) {
        Path path2;
        void var2_2;
        void var3_3;
        if (exceptions.size() != 1) {
            return null;
        }
        IOException exception = Iterables.getOnlyElement(exceptions);
        if (!(exception instanceof NoSuchFileException)) {
            return null;
        }
        NoSuchFileException noSuchFileException = (NoSuchFileException)exception;
        String exceptionFile = noSuchFileException.getFile();
        if (exceptionFile == null) {
            return null;
        }
        Path parentPath = MoreFiles.getParentPath(path);
        if (parentPath == null) {
            return null;
        }
        Path pathResolvedFromParent = var3_3.resolve(Objects.requireNonNull(path.getFileName()));
        if (var2_2.equals(path2.toString())) {
            void var1_1;
            return var1_1;
        }
        return null;
    }

    private static final class PathByteSink
    extends ByteSink {
        private final Path path;
        private final OpenOption[] options;

        /*
         * WARNING - void declaration
         */
        private PathByteSink(Path path, OpenOption ... options) {
            void var2_2;
            void var1_1;
            this.path = (Path)Preconditions.checkNotNull(var1_1);
            this.options = (OpenOption[])var2_2.clone();
        }

        @Override
        public final OutputStream openStream() throws IOException {
            return Files.newOutputStream(this.path, this.options);
        }

        public final String toString() {
            String string = String.valueOf(this.path);
            String string2 = Arrays.toString(this.options);
            return new StringBuilder(24 + String.valueOf(string).length() + String.valueOf(string2).length()).append("MoreFiles.asByteSink(").append(string).append(", ").append(string2).append(")").toString();
        }
    }

    private static final class PathByteSource
    extends ByteSource {
        private static final LinkOption[] FOLLOW_LINKS = new LinkOption[0];
        private final Path path;
        private final OpenOption[] options;
        private final boolean followLinks;

        /*
         * WARNING - void declaration
         */
        private PathByteSource(Path path, OpenOption ... options) {
            void var2_2;
            void var1_1;
            this.path = (Path)Preconditions.checkNotNull(var1_1);
            this.options = (OpenOption[])var2_2.clone();
            this.followLinks = PathByteSource.followLinks(this.options);
        }

        private static boolean followLinks(OpenOption[] options) {
            OpenOption[] openOptionArray = options;
            int n = options.length;
            for (int i = 0; i < n; ++i) {
                OpenOption openOption = openOptionArray[i];
                if (openOption != LinkOption.NOFOLLOW_LINKS) continue;
                return false;
            }
            return true;
        }

        @Override
        public final InputStream openStream() throws IOException {
            return Files.newInputStream(this.path, this.options);
        }

        private BasicFileAttributes readAttributes() throws IOException {
            LinkOption[] linkOptionArray;
            if (this.followLinks) {
                linkOptionArray = FOLLOW_LINKS;
            } else {
                LinkOption[] linkOptionArray2 = new LinkOption[1];
                linkOptionArray = linkOptionArray2;
                linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
            }
            return Files.readAttributes(this.path, BasicFileAttributes.class, linkOptionArray);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Optional<Long> sizeIfKnown() {
            void var1_1;
            BasicFileAttributes attrs;
            try {
                attrs = this.readAttributes();
            }
            catch (IOException iOException) {
                return Optional.absent();
            }
            if (attrs.isDirectory() || attrs.isSymbolicLink()) {
                return Optional.absent();
            }
            return Optional.of(var1_1.size());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long size() throws IOException {
            void var1_1;
            BasicFileAttributes attrs = this.readAttributes();
            if (attrs.isDirectory()) {
                throw new IOException("can't read: is a directory");
            }
            if (attrs.isSymbolicLink()) {
                throw new IOException("can't read: is a symbolic link");
            }
            return var1_1.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] read() throws IOException {
            byte[] byArray;
            block5: {
                SeekableByteChannel channel = Files.newByteChannel(this.path, this.options);
                try {
                    byArray = ByteStreams.toByteArray(Channels.newInputStream(channel), channel.size());
                    if (channel == null) break block5;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            void var1_1;
                            var1_1.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return byArray;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final CharSource asCharSource(Charset charset) {
            void var1_1;
            if (this.options.length == 0) {
                return new ByteSource.AsCharSource(charset){
                    {
                        void var2_2;
                        void var1_1;
                        super((ByteSource)var1_1, (Charset)var2_2);
                    }

                    @Override
                    public Stream<String> lines() throws IOException {
                        return Files.lines(path, this.charset);
                    }
                };
            }
            return super.asCharSource((Charset)var1_1);
        }

        public final String toString() {
            String string = String.valueOf(this.path);
            String string2 = Arrays.toString(this.options);
            return new StringBuilder(26 + String.valueOf(string).length() + String.valueOf(string2).length()).append("MoreFiles.asByteSource(").append(string).append(", ").append(string2).append(")").toString();
        }
    }
}

