/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.Longs;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class LittleEndianDataOutputStream
extends FilterOutputStream
implements DataOutput {
    /*
     * WARNING - void declaration
     */
    public LittleEndianDataOutputStream(OutputStream out) {
        super(new DataOutputStream((OutputStream)Preconditions.checkNotNull(var1_1)));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.out.write((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeBoolean(boolean v) throws IOException {
        void var1_1;
        ((DataOutputStream)this.out).writeBoolean((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeByte(int v) throws IOException {
        void var1_1;
        ((DataOutputStream)this.out).writeByte((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final void writeBytes(String s) throws IOException {
        void var1_1;
        ((DataOutputStream)this.out).writeBytes((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeChar(int v) throws IOException {
        void var1_1;
        this.writeShort((int)var1_1);
    }

    @Override
    public final void writeChars(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeDouble(double v) throws IOException {
        void var1_1;
        this.writeLong(Double.doubleToLongBits((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeFloat(float v) throws IOException {
        void var1_1;
        this.writeInt(Float.floatToIntBits((float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeInt(int v) throws IOException {
        void var1_1;
        this.out.write(0xFF & v);
        this.out.write(0xFF & v >> 8);
        this.out.write(0xFF & v >> 16);
        this.out.write(0xFF & var1_1 >> 24);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeLong(long v) throws IOException {
        void var1_2;
        byte[] bytes = Longs.toByteArray(Long.reverseBytes(v));
        this.write(bytes, 0, ((void)var1_2).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeShort(int v) throws IOException {
        void var1_1;
        this.out.write(0xFF & v);
        this.out.write(0xFF & var1_1 >> 8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeUTF(String str) throws IOException {
        void var1_1;
        ((DataOutputStream)this.out).writeUTF((String)var1_1);
    }

    @Override
    public final void close() throws IOException {
        this.out.close();
    }
}

