/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class LittleEndianDataInputStream
extends FilterInputStream
implements DataInput {
    /*
     * WARNING - void declaration
     */
    public LittleEndianDataInputStream(InputStream in) {
        super((InputStream)Preconditions.checkNotNull(var1_1));
        void var1_1;
    }

    @Override
    public final String readLine() {
        throw new UnsupportedOperationException("readLine is not supported");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readFully(byte[] b) throws IOException {
        void var1_1;
        ByteStreams.readFully(this, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteStreams.readFully(this, (byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int skipBytes(int n) throws IOException {
        void var1_1;
        return (int)this.in.skip((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int readUnsignedByte() throws IOException {
        void var1_1;
        int b1 = this.in.read();
        if (b1 < 0) {
            throw new EOFException();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int readUnsignedShort() throws IOException {
        void var1_1;
        void var2_2;
        byte b1 = this.readAndCheckByte();
        byte b2 = this.readAndCheckByte();
        return Ints.fromBytes((byte)0, (byte)0, (byte)var2_2, (byte)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int readInt() throws IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        byte b1 = this.readAndCheckByte();
        byte b2 = this.readAndCheckByte();
        byte b3 = this.readAndCheckByte();
        byte by = this.readAndCheckByte();
        return Ints.fromBytes(by, (byte)var3_3, (byte)var2_2, (byte)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long readLong() throws IOException {
        void var1_1;
        void var2_2;
        void var3_3;
        byte b1 = this.readAndCheckByte();
        byte b2 = this.readAndCheckByte();
        byte b3 = this.readAndCheckByte();
        byte b4 = this.readAndCheckByte();
        byte b5 = this.readAndCheckByte();
        byte b6 = this.readAndCheckByte();
        byte b7 = this.readAndCheckByte();
        byte by = this.readAndCheckByte();
        return Longs.fromBytes(by, b7, b6, b5, b4, (byte)var3_3, (byte)var2_2, (byte)var1_1);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readUTF() throws IOException {
        return new DataInputStream(this.in).readUTF();
    }

    @Override
    public final short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    public final char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public final byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    /*
     * WARNING - void declaration
     */
    private byte readAndCheckByte() throws IOException, EOFException {
        void var1_1;
        int b1 = this.in.read();
        if (-1 == b1) {
            throw new EOFException();
        }
        return (byte)var1_1;
    }
}

