/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.io.Java8Compatibility;
import com.google.common.io.LineBuffer;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.ArrayDeque;
import java.util.Queue;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class LineReader {
    private final Readable readable;
    private final Reader reader;
    private final CharBuffer cbuf = CharStreams.createBuffer();
    private final char[] buf = this.cbuf.array();
    private final Queue<String> lines = new ArrayDeque<String>();
    private final LineBuffer lineBuf = new LineBuffer(this){
        final /* synthetic */ LineReader this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void handleLine(String line, String end) {
            void var1_1;
            this.this$0.lines.add(var1_1);
        }
    };

    /*
     * WARNING - void declaration
     */
    public LineReader(Readable readable) {
        void var1_1;
        this.readable = Preconditions.checkNotNull(readable);
        this.reader = readable instanceof Reader ? (Reader)var1_1 : null;
    }

    /*
     * WARNING - void declaration
     */
    public final String readLine() throws IOException {
        while (this.lines.peek() == null) {
            void var1_1;
            Java8Compatibility.clear(this.cbuf);
            int read = this.reader != null ? this.reader.read(this.buf, 0, this.buf.length) : this.readable.read(this.cbuf);
            if (read == -1) {
                this.lineBuf.finish();
                break;
            }
            this.lineBuf.add(this.buf, 0, (int)var1_1);
        }
        return this.lines.poll();
    }
}

