/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import java.io.IOException;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
abstract class LineBuffer {
    private StringBuilder line = new StringBuilder();
    private boolean sawReturn;

    LineBuffer() {
    }

    /*
     * WARNING - void declaration
     */
    protected void add(char[] cbuf, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        int pos = off;
        if (this.sawReturn && len > 0 && this.finishLine(cbuf[pos] == '\n')) {
            ++pos;
        }
        int start = pos;
        int end = off + len;
        while (pos < end) {
            switch (cbuf[pos]) {
                case '\r': {
                    this.line.append(cbuf, start, pos - start);
                    this.sawReturn = true;
                    if (pos + 1 < end && this.finishLine(cbuf[pos + 1] == '\n')) {
                        ++pos;
                    }
                    start = pos + 1;
                    break;
                }
                case '\n': {
                    this.line.append(cbuf, start, pos - start);
                    this.finishLine(true);
                    start = pos + 1;
                }
            }
            ++pos;
        }
        this.line.append((char[])var1_1, start, (int)(var2_2 + var3_3 - start));
    }

    /*
     * WARNING - void declaration
     */
    private boolean finishLine(boolean sawNewline) throws IOException {
        void var1_1;
        void var2_2;
        String separator = this.sawReturn ? (sawNewline ? "\r\n" : "\r") : (sawNewline ? "\n" : "");
        LineBuffer lineBuffer = this;
        lineBuffer.handleLine(lineBuffer.line.toString(), (String)var2_2);
        this.line = new StringBuilder();
        this.sawReturn = false;
        return (boolean)var1_1;
    }

    protected void finish() throws IOException {
        if (this.sawReturn || this.line.length() > 0) {
            this.finishLine(false);
        }
    }

    protected abstract void handleLine(String var1, String var2) throws IOException;
}

