/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import java.io.Flushable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class Flushables {
    private static final Logger logger = Logger.getLogger(Flushables.class.getName());

    private Flushables() {
    }

    /*
     * WARNING - void declaration
     */
    public static void flush(Flushable flushable, boolean swallowIOException) throws IOException {
        try {
            flushable.flush();
            return;
        }
        catch (IOException e) {
            void var0_1;
            void var1_2;
            if (var1_2 != false) {
                logger.log(Level.WARNING, "IOException thrown while flushing Flushable.", e);
                return;
            }
            throw var0_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void flushQuietly(Flushable flushable) {
        try {
            Flushables.flush(flushable, true);
            return;
        }
        catch (IOException e) {
            void var0_1;
            logger.log(Level.SEVERE, "IOException should not have been thrown.", (Throwable)var0_1);
            return;
        }
    }
}

