/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.Closer;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.io.FileWriteMode;
import com.google.common.io.LineProcessor;
import com.google.common.io.ParametricNullness;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class Files {
    private static final int TEMP_DIR_ATTEMPTS = 10000;
    private static final SuccessorsFunction<File> FILE_TREE = new SuccessorsFunction<File>(){

        /*
         * WARNING - void declaration
         */
        @Override
        public Iterable<File> successors(File file) {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                void var1_1;
                return Collections.unmodifiableList(Arrays.asList(var1_1));
            }
            return ImmutableList.of();
        }
    };

    private Files() {
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedReader newReader(File file, Charset charset) throws FileNotFoundException {
        void var1_1;
        File file2;
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(charset);
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), (Charset)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedWriter newWriter(File file, Charset charset) throws FileNotFoundException {
        void var1_1;
        File file2;
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(charset);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), (Charset)var1_1));
    }

    public static ByteSource asByteSource(File file) {
        File file2;
        return new FileByteSource(file2);
    }

    /*
     * WARNING - void declaration
     */
    public static ByteSink asByteSink(File file, FileWriteMode ... modes) {
        void var1_1;
        File file2;
        return new FileByteSink(file2, (FileWriteMode[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static CharSource asCharSource(File file, Charset charset) {
        void var1_1;
        return Files.asByteSource(file).asCharSource((Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static CharSink asCharSink(File file, Charset charset, FileWriteMode ... modes) {
        void var1_1;
        void var2_2;
        return Files.asByteSink(file, (FileWriteMode[])var2_2).asCharSink((Charset)var1_1);
    }

    public static byte[] toByteArray(File file) throws IOException {
        return Files.asByteSource(file).read();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String toString(File file, Charset charset) throws IOException {
        void var1_1;
        return Files.asCharSource(file, (Charset)var1_1).read();
    }

    public static void write(byte[] from, File to) throws IOException {
        byte[] byArray;
        Files.asByteSink(to, new FileWriteMode[0]).write(byArray);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void write(CharSequence from, File to, Charset charset) throws IOException {
        CharSequence charSequence;
        void var2_2;
        Files.asCharSink(to, (Charset)var2_2, new FileWriteMode[0]).write(charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static void copy(File from, OutputStream to) throws IOException {
        void var1_1;
        Files.asByteSource(from).copyTo((OutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void copy(File from, File to) throws IOException {
        void var1_1;
        File file;
        Preconditions.checkArgument(!from.equals(to), "Source %s and destination %s must be different", (Object)from, (Object)to);
        Files.asByteSource(file).copyTo(Files.asByteSink((File)var1_1, new FileWriteMode[0]));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void copy(File from, Charset charset, Appendable to) throws IOException {
        void var2_2;
        void var1_1;
        Files.asCharSource(from, (Charset)var1_1).copyTo((Appendable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void append(CharSequence from, File to, Charset charset) throws IOException {
        CharSequence charSequence;
        void var2_2;
        Files.asCharSink(to, (Charset)var2_2, FileWriteMode.APPEND).write(charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equal(File file1, File file2) throws IOException {
        void var1_1;
        File file;
        void var2_2;
        Preconditions.checkNotNull(file1);
        Preconditions.checkNotNull(file2);
        if (file1 == file2 || file1.equals(file2)) {
            return true;
        }
        long len1 = file1.length();
        long len2 = file2.length();
        if (len1 != 0L && len2 != 0L && var2_2 != len2) {
            return false;
        }
        return Files.asByteSource(file).contentEquals(Files.asByteSource((File)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Beta
    public static File createTempDir() {
        void var1_3;
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        long l = System.currentTimeMillis();
        String baseName = new StringBuilder(21).append(l).append("-").toString();
        int counter = 0;
        while (counter < 10000) {
            void var3_4;
            int n = counter++;
            File tempDir = new File(baseDir, new StringBuilder(11 + String.valueOf(baseName).length()).append(baseName).append(n).toString());
            if (!tempDir.mkdir()) continue;
            return var3_4;
        }
        throw new IllegalStateException(new StringBuilder(66 + String.valueOf(baseName).length() + String.valueOf(baseName).length()).append("Failed to create directory within 10000 attempts (tried ").append(baseName).append("0 to ").append((String)var1_3).append(9999).append(')').toString());
    }

    public static void touch(File file) throws IOException {
        Preconditions.checkNotNull(file);
        if (!file.createNewFile() && !file.setLastModified(System.currentTimeMillis())) {
            String string;
            string = String.valueOf(string);
            throw new IOException(new StringBuilder(38 + String.valueOf(string).length()).append("Unable to update modification time of ").append(string).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void createParentDirs(File file) throws IOException {
        void var1_1;
        Preconditions.checkNotNull(file);
        File parent = file.getCanonicalFile().getParentFile();
        if (parent == null) {
            return;
        }
        parent.mkdirs();
        if (!var1_1.isDirectory()) {
            String string;
            string = String.valueOf(string);
            throw new IOException(new StringBuilder(39 + String.valueOf(string).length()).append("Unable to create parent directories of ").append(string).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void move(File from, File to) throws IOException {
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        Preconditions.checkArgument(!((File)from).equals(to), "Source %s and destination %s must be different", from, (Object)to);
        if (!((File)from).renameTo(to)) {
            Files.copy((File)from, to);
            if (!((File)from).delete()) {
                String string;
                if (!to.delete()) {
                    void var1_1;
                    from = String.valueOf(var1_1);
                    throw new IOException(new StringBuilder(17 + String.valueOf(from).length()).append("Unable to delete ").append((String)from).toString());
                }
                string = String.valueOf(string);
                throw new IOException(new StringBuilder(17 + String.valueOf(string).length()).append("Unable to delete ").append(string).toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String readFirstLine(File file, Charset charset) throws IOException {
        void var1_1;
        return Files.asCharSource(file, (Charset)var1_1).readFirstLine();
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> readLines(File file, Charset charset) throws IOException {
        void var1_1;
        return Files.asCharSource(file, (Charset)var1_1).readLines(new LineProcessor<List<String>>(){
            final List<String> result = Lists.newArrayList();

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean processLine(String line) {
                void var1_1;
                this.result.add((String)var1_1);
                return true;
            }

            @Override
            public List<String> getResult() {
                return this.result;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @ParametricNullness
    public static <T> T readLines(File file, Charset charset, LineProcessor<T> callback) throws IOException {
        void var2_2;
        void var1_1;
        return Files.asCharSource(file, (Charset)var1_1).readLines(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @ParametricNullness
    public static <T> T readBytes(File file, ByteProcessor<T> processor) throws IOException {
        void var1_1;
        return Files.asByteSource(file).read(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static HashCode hash(File file, HashFunction hashFunction) throws IOException {
        void var1_1;
        return Files.asByteSource(file).hash((HashFunction)var1_1);
    }

    public static MappedByteBuffer map(File file) throws IOException {
        File file2;
        Preconditions.checkNotNull(file);
        return Files.map(file2, FileChannel.MapMode.READ_ONLY);
    }

    /*
     * WARNING - void declaration
     */
    public static MappedByteBuffer map(File file, FileChannel.MapMode mode) throws IOException {
        void var1_1;
        return Files.mapInternal(file, (FileChannel.MapMode)var1_1, -1L);
    }

    /*
     * WARNING - void declaration
     */
    public static MappedByteBuffer map(File file, FileChannel.MapMode mode, long size) throws IOException {
        void var2_2;
        void var1_1;
        File file2;
        Preconditions.checkArgument(size >= 0L, "size (%s) may not be negative", size);
        return Files.mapInternal(file2, (FileChannel.MapMode)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static MappedByteBuffer mapInternal(File file, FileChannel.MapMode mode, long size) throws IOException {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(mode);
        try (Closer closer = Closer.create();){
            void var2_4;
            void var1_3;
            RandomAccessFile raf = closer.register(new RandomAccessFile(file, mode == FileChannel.MapMode.READ_ONLY ? "r" : "rw"));
            RandomAccessFile channel = closer.register(raf.getChannel());
            channel = ((FileChannel)((Object)channel)).map((FileChannel.MapMode)var1_3, 0L, size == -1L ? ((FileChannel)((Object)channel)).size() : var2_4);
            return channel;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String simplifyPath(String pathname) {
        void var1_1;
        String string;
        String string2;
        void var2_2;
        Preconditions.checkNotNull(pathname);
        if (pathname.length() == 0) {
            return ".";
        }
        Object components = Splitter.on('/').omitEmptyStrings().split(pathname);
        ArrayList<Object> path = new ArrayList<Object>();
        components = components.iterator();
        block8: while (components.hasNext()) {
            void var3_3;
            String component;
            switch (component = (String)components.next()) {
                case ".": {
                    continue block8;
                }
                case "..": {
                    if (path.size() > 0) {
                        ArrayList<Object> arrayList = path;
                        if (!((String)arrayList.get(arrayList.size() - 1)).equals("..")) {
                            ArrayList<Object> arrayList2 = path;
                            arrayList2.remove(arrayList2.size() - 1);
                            continue block8;
                        }
                    }
                    path.add("..");
                    continue block8;
                }
            }
            path.add(var3_3);
        }
        String result = Joiner.on('/').join((Iterable<? extends Object>)var2_2);
        if (string2.charAt(0) == '/') {
            String string3 = String.valueOf(result);
            string = result = string3.length() != 0 ? "/".concat(string3) : new String("/");
        }
        while (result.startsWith("/../")) {
            string = result.substring(3);
        }
        if (result.equals("/..")) {
            result = "/";
        } else if ("".equals(result)) {
            result = ".";
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String getFileExtension(String fullName) {
        void var1_1;
        String string;
        Preconditions.checkNotNull(fullName);
        String fileName = new File(fullName).getName();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex == -1) {
            return "";
        }
        return string.substring((int)(var1_1 + true));
    }

    /*
     * WARNING - void declaration
     */
    public static String getNameWithoutExtension(String file) {
        void var1_1;
        String string;
        Preconditions.checkNotNull(file);
        String fileName = new File(file).getName();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex == -1) {
            return fileName;
        }
        return string.substring(0, (int)var1_1);
    }

    @Beta
    public static Traverser<File> fileTraverser() {
        return Traverser.forTree(FILE_TREE);
    }

    public static Predicate<File> isDirectory() {
        return FilePredicate.IS_DIRECTORY;
    }

    public static Predicate<File> isFile() {
        return FilePredicate.IS_FILE;
    }

    private static enum FilePredicate implements Predicate<File>
    {
        IS_DIRECTORY{

            @Override
            public final boolean apply(File file) {
                return file.isDirectory();
            }

            public final String toString() {
                return "Files.isDirectory()";
            }
        }
        ,
        IS_FILE{

            @Override
            public final boolean apply(File file) {
                return file.isFile();
            }

            public final String toString() {
                return "Files.isFile()";
            }
        };

    }

    private static final class FileByteSink
    extends ByteSink {
        private final File file;
        private final ImmutableSet<FileWriteMode> modes;

        /*
         * WARNING - void declaration
         */
        private FileByteSink(File file, FileWriteMode ... modes) {
            void var2_2;
            void var1_1;
            this.file = (File)Preconditions.checkNotNull(var1_1);
            this.modes = ImmutableSet.copyOf(var2_2);
        }

        @Override
        public final FileOutputStream openStream() throws IOException {
            return new FileOutputStream(this.file, this.modes.contains((Object)FileWriteMode.APPEND));
        }

        public final String toString() {
            String string = String.valueOf(this.file);
            String string2 = String.valueOf(this.modes);
            return new StringBuilder(20 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Files.asByteSink(").append(string).append(", ").append(string2).append(")").toString();
        }
    }

    private static final class FileByteSource
    extends ByteSource {
        private final File file;

        /*
         * WARNING - void declaration
         */
        private FileByteSource(File file) {
            void var1_1;
            this.file = (File)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public final FileInputStream openStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public final Optional<Long> sizeIfKnown() {
            if (this.file.isFile()) {
                return Optional.of(this.file.length());
            }
            return Optional.absent();
        }

        @Override
        public final long size() throws IOException {
            if (!this.file.isFile()) {
                throw new FileNotFoundException(this.file.toString());
            }
            return this.file.length();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final byte[] read() throws IOException {
            Object in;
            Closer closer = Closer.create();
            try {
                in = closer.register(this.openStream());
                in = ByteStreams.toByteArray((InputStream)in, ((FileInputStream)in).getChannel().size());
            }
            catch (Throwable e) {
                try {
                    void var2_3;
                    throw closer.rethrow((Throwable)var2_3);
                }
                catch (Throwable throwable) {
                    void var1_1;
                    var1_1.close();
                    throw throwable;
                }
            }
            closer.close();
            return in;
        }

        public final String toString() {
            String string = String.valueOf(this.file);
            return new StringBuilder(20 + String.valueOf(string).length()).append("Files.asByteSource(").append(string).append(")").toString();
        }
    }
}

