/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteSource;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class FileBackedOutputStream
extends OutputStream {
    private final int fileThreshold;
    private final boolean resetOnFinalize;
    private final ByteSource source;
    private final File parentDirectory;
    private OutputStream out;
    private MemoryOutput memory;
    private File file;

    @VisibleForTesting
    final synchronized File getFile() {
        return this.file;
    }

    /*
     * WARNING - void declaration
     */
    public FileBackedOutputStream(int fileThreshold) {
        this((int)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FileBackedOutputStream(int fileThreshold, boolean resetOnFinalize) {
        this((int)var1_1, (boolean)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private FileBackedOutputStream(int fileThreshold, boolean resetOnFinalize, File parentDirectory) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.fileThreshold = var1_1;
        this.resetOnFinalize = resetOnFinalize;
        this.parentDirectory = var3_3;
        this.memory = new MemoryOutput();
        this.out = this.memory;
        if (var2_2 != false) {
            this.source = new ByteSource(this){
                final /* synthetic */ FileBackedOutputStream this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public InputStream openStream() throws IOException {
                    return this.this$0.openInputStream();
                }

                protected void finalize() {
                    try {
                        this.this$0.reset();
                        return;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        throwable.printStackTrace(System.err);
                        return;
                    }
                }
            };
            return;
        }
        this.source = new ByteSource(this){
            final /* synthetic */ FileBackedOutputStream this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public InputStream openStream() throws IOException {
                return this.this$0.openInputStream();
            }
        };
    }

    public final ByteSource asByteSource() {
        return this.source;
    }

    private synchronized InputStream openInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        Objects.requireNonNull(this.memory);
        return new ByteArrayInputStream(this.memory.getBuffer(), 0, this.memory.getCount());
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void reset() throws IOException {
        block8: {
            try {
                this.close();
                if (this.memory != null) break block8;
                this.memory = new MemoryOutput();
            }
            catch (Throwable throwable) {
                if (this.memory == null) {
                    this.memory = new MemoryOutput();
                } else {
                    this.memory.reset();
                }
                this.out = this.memory;
                if (this.file != null) {
                    File deleteMe = this.file;
                    this.file = null;
                    if (!deleteMe.delete()) {
                        void var2_4;
                        String string = String.valueOf(var2_4);
                        throw new IOException(new StringBuilder(18 + String.valueOf(string).length()).append("Could not delete: ").append(string).toString());
                    }
                }
                throw throwable;
            }
        }
        this.memory.reset();
        this.out = this.memory;
        if (this.file != null) {
            File deleteMe = this.file;
            this.file = null;
            if (!deleteMe.delete()) {
                String string;
                string = String.valueOf(string);
                throw new IOException(new StringBuilder(18 + String.valueOf(string).length()).append("Could not delete: ").append(string).toString());
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void write(int b) throws IOException {
        void var1_1;
        this.update(1);
        this.out.write((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void write(byte[] b) throws IOException {
        void var1_1;
        this.write(b, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void write(byte[] b, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.update(len);
        this.out.write((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    @Override
    public final synchronized void close() throws IOException {
        this.out.close();
    }

    @Override
    public final synchronized void flush() throws IOException {
        this.out.flush();
    }

    /*
     * WARNING - void declaration
     */
    private void update(int len) throws IOException {
        if (this.memory != null && this.memory.getCount() + len > this.fileThreshold) {
            void var1_2;
            File temp = File.createTempFile("FileBackedOutputStream", null, this.parentDirectory);
            if (this.resetOnFinalize) {
                temp.deleteOnExit();
            }
            try {
                FileOutputStream transfer = new FileOutputStream(temp);
                transfer.write(this.memory.getBuffer(), 0, this.memory.getCount());
                transfer.flush();
                this.out = transfer;
            }
            catch (IOException e) {
                void var2_4;
                temp.delete();
                throw var2_4;
            }
            this.file = var1_2;
            this.memory = null;
        }
    }

    private static class MemoryOutput
    extends ByteArrayOutputStream {
        private MemoryOutput() {
        }

        byte[] getBuffer() {
            return this.buf;
        }

        int getCount() {
            return this.count;
        }
    }
}

