/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class CountingInputStream
extends FilterInputStream {
    private long count;
    private long mark = -1L;

    /*
     * WARNING - void declaration
     */
    public CountingInputStream(InputStream in) {
        super((InputStream)Preconditions.checkNotNull(var1_1));
        void var1_1;
    }

    public final long getCount() {
        return this.count;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int read() throws IOException {
        void var1_1;
        int result = this.in.read();
        if (result != -1) {
            ++this.count;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        int result = this.in.read(b, (int)var2_3, (int)var3_4);
        if (result != -1) {
            this.count += (long)result;
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long skip(long n) throws IOException {
        void var3_2;
        void var1_1;
        long result = this.in.skip((long)var1_1);
        this.count += result;
        return (long)var3_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void mark(int readlimit) {
        void var1_1;
        this.in.mark((int)var1_1);
        this.mark = this.count;
    }

    @Override
    public final synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.count = this.mark;
    }
}

