/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.io.ParametricNullness;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.logging.Level;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class Closer
implements Closeable {
    private static final Suppressor SUPPRESSOR;
    @VisibleForTesting
    final Suppressor suppressor;
    private final Deque<Closeable> stack = new ArrayDeque<Closeable>(4);
    private Throwable thrown;

    public static Closer create() {
        return new Closer(SUPPRESSOR);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    Closer(Suppressor suppressor) {
        void var1_1;
        this.suppressor = (Suppressor)Preconditions.checkNotNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public final <C extends Closeable> C register(@ParametricNullness C closeable) {
        void var1_1;
        if (closeable != null) {
            this.stack.addFirst(closeable);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final RuntimeException rethrow(Throwable e) throws IOException {
        void var1_1;
        Preconditions.checkNotNull(e);
        this.thrown = e;
        Throwables.propagateIfPossible(e, IOException.class);
        throw new RuntimeException((Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final <X extends Exception> RuntimeException rethrow(Throwable e, Class<X> declaredType) throws IOException, X {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(e);
        this.thrown = e;
        Throwables.propagateIfPossible(e, IOException.class);
        Throwables.propagateIfPossible(e, var2_2);
        throw new RuntimeException((Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final <X1 extends Exception, X2 extends Exception> RuntimeException rethrow(Throwable e, Class<X1> declaredType1, Class<X2> declaredType2) throws IOException, X1, X2 {
        void var1_1;
        void var3_3;
        void var2_2;
        Preconditions.checkNotNull(e);
        this.thrown = e;
        Throwables.propagateIfPossible(e, IOException.class);
        Throwables.propagateIfPossible(e, var2_2, var3_3);
        throw new RuntimeException((Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close() throws IOException {
        Throwable throwable = this.thrown;
        while (!this.stack.isEmpty()) {
            Closeable closeable = this.stack.removeFirst();
            try {
                closeable.close();
            }
            catch (Throwable e) {
                void var3_3;
                void var2_2;
                if (throwable == null) {
                    throwable = e;
                    continue;
                }
                this.suppressor.suppress((Closeable)var2_2, throwable, (Throwable)var3_3);
            }
        }
        if (this.thrown == null && throwable != null) {
            void var1_1;
            Throwables.propagateIfPossible(throwable, IOException.class);
            throw new AssertionError(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        SuppressingSuppressor suppressingSuppressor = SuppressingSuppressor.tryCreate();
        SUPPRESSOR = suppressingSuppressor == null ? LoggingSuppressor.INSTANCE : var0;
    }

    @VisibleForTesting
    static final class SuppressingSuppressor
    implements Suppressor {
        private final Method addSuppressed;

        /*
         * WARNING - void declaration
         */
        static SuppressingSuppressor tryCreate() {
            void var0;
            try {
                Method addSuppressed = Throwable.class.getMethod("addSuppressed", Throwable.class);
            }
            catch (Throwable throwable) {
                return null;
            }
            return new SuppressingSuppressor((Method)var0);
        }

        /*
         * WARNING - void declaration
         */
        private SuppressingSuppressor(Method addSuppressed) {
            void var1_1;
            this.addSuppressed = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void suppress(Closeable closeable, Throwable thrown, Throwable suppressed) {
            if (thrown == suppressed) {
                return;
            }
            try {
                this.addSuppressed.invoke((Object)thrown, suppressed);
                return;
            }
            catch (Throwable throwable) {
                void var3_3;
                void var2_2;
                void var1_1;
                LoggingSuppressor.INSTANCE.suppress((Closeable)var1_1, (Throwable)var2_2, (Throwable)var3_3);
                return;
            }
        }
    }

    @VisibleForTesting
    static final class LoggingSuppressor
    implements Suppressor {
        static final LoggingSuppressor INSTANCE = new LoggingSuppressor();

        LoggingSuppressor() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void suppress(Closeable closeable, Throwable thrown, Throwable suppressed) {
            void var3_3;
            String string;
            string = String.valueOf(string);
            Closeables.logger.log(Level.WARNING, new StringBuilder(42 + String.valueOf(string).length()).append("Suppressing exception thrown when closing ").append(string).toString(), (Throwable)var3_3);
        }
    }

    @VisibleForTesting
    static interface Suppressor {
        public void suppress(Closeable var1, Throwable var2, Throwable var3);
    }
}

