/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class Closeables {
    @VisibleForTesting
    static final Logger logger = Logger.getLogger(Closeables.class.getName());

    private Closeables() {
    }

    /*
     * WARNING - void declaration
     */
    public static void close(Closeable closeable, boolean swallowIOException) throws IOException {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
            return;
        }
        catch (IOException e) {
            void var0_1;
            void var1_2;
            if (var1_2 != false) {
                logger.log(Level.WARNING, "IOException thrown while closing Closeable.", e);
                return;
            }
            throw var0_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void closeQuietly(InputStream inputStream) {
        try {
            Closeables.close(inputStream, true);
            return;
        }
        catch (IOException impossible) {
            void var0_1;
            throw new AssertionError(var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void closeQuietly(Reader reader) {
        try {
            Closeables.close(reader, true);
            return;
        }
        catch (IOException impossible) {
            void var0_1;
            throw new AssertionError(var0_1);
        }
    }
}

