/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.AppendableWriter;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.io.Java8Compatibility;
import com.google.common.io.LineProcessor;
import com.google.common.io.LineReader;
import com.google.common.io.ParametricNullness;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class CharStreams {
    private static final int DEFAULT_BUF_SIZE = 2048;

    static CharBuffer createBuffer() {
        return CharBuffer.allocate(2048);
    }

    private CharStreams() {
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(Readable from, Appendable to) throws IOException {
        void var2_2;
        if (from instanceof Reader) {
            if (to instanceof StringBuilder) {
                return CharStreams.copyReaderToBuilder((Reader)from, (StringBuilder)to);
            }
            return CharStreams.copyReaderToWriter((Reader)from, CharStreams.asWriter(to));
        }
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        long total = 0L;
        CharBuffer buf = CharStreams.createBuffer();
        while (from.read(buf) != -1) {
            Java8Compatibility.flip(buf);
            to.append(buf);
            total += (long)buf.remaining();
            Java8Compatibility.clear(buf);
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static long copyReaderToBuilder(Reader from, StringBuilder to) throws IOException {
        int nRead;
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        char[] buf = new char[2048];
        long total = 0L;
        while ((nRead = from.read(buf)) != -1) {
            void var3_4;
            to.append(buf, 0, nRead);
            total += (long)var3_4;
        }
        return total;
    }

    /*
     * WARNING - void declaration
     */
    static long copyReaderToWriter(Reader from, Writer to) throws IOException {
        int nRead;
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        char[] buf = new char[2048];
        long total = 0L;
        while ((nRead = from.read(buf)) != -1) {
            void var3_4;
            to.write(buf, 0, nRead);
            total += (long)var3_4;
        }
        return total;
    }

    public static String toString(Readable r) throws IOException {
        return CharStreams.toStringBuilder(r).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static StringBuilder toStringBuilder(Readable r) throws IOException {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        if (r instanceof Reader) {
            CharStreams.copyReaderToBuilder((Reader)r, sb);
        } else {
            Readable readable;
            CharStreams.copy(readable, sb);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static List<String> readLines(Readable r) throws IOException {
        void var1_1;
        String line;
        ArrayList<void> result = new ArrayList<void>();
        LineReader lineReader = new LineReader(r);
        while ((line = lineReader.readLine()) != null) {
            void var2_2;
            result.add(var2_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    @Beta
    public static <T> T readLines(Readable readable, LineProcessor<T> processor) throws IOException {
        void var1_1;
        void var2_2;
        String line;
        Preconditions.checkNotNull(readable);
        Preconditions.checkNotNull(processor);
        LineReader lineReader = new LineReader(readable);
        while ((line = lineReader.readLine()) != null && processor.processLine((String)var2_2)) {
        }
        return var1_1.getResult();
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static long exhaust(Readable readable) throws IOException {
        void var1_1;
        long read;
        long total = 0L;
        CharBuffer buf = CharStreams.createBuffer();
        while ((read = (long)readable.read(buf)) != -1L) {
            void var3_3;
            total += var3_3;
            Java8Compatibility.clear(buf);
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static void skipFully(Reader reader, long n) throws IOException {
        Preconditions.checkNotNull(reader);
        while (n > 0L) {
            void var3_2;
            long amt = reader.skip(n);
            if (amt == 0L) {
                throw new EOFException();
            }
            n -= var3_2;
        }
    }

    @Beta
    public static Writer nullWriter() {
        return NullWriter.INSTANCE;
    }

    @Beta
    public static Writer asWriter(Appendable target) {
        Appendable appendable;
        if (target instanceof Writer) {
            return (Writer)target;
        }
        return new AppendableWriter(appendable);
    }

    private static final class NullWriter
    extends Writer {
        private static final NullWriter INSTANCE = new NullWriter();

        private NullWriter() {
        }

        @Override
        public final void write(int c) {
        }

        @Override
        public final void write(char[] cbuf) {
            Preconditions.checkNotNull(cbuf);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(char[] cbuf, int off, int len) {
            void var1_1;
            void var3_3;
            int n = off;
            Preconditions.checkPositionIndexes(n, n + var3_3, ((void)var1_1).length);
        }

        @Override
        public final void write(String str) {
            Preconditions.checkNotNull(str);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(String str, int off, int len) {
            void var1_1;
            void var3_3;
            int n = off;
            Preconditions.checkPositionIndexes(n, n + var3_3, var1_1.length());
        }

        @Override
        public final Writer append(CharSequence csq) {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Writer append(CharSequence csq, int start, int end) {
            void var1_1;
            void var3_3;
            Preconditions.checkPositionIndexes(start, (int)var3_3, csq == null ? 4 : var1_1.length());
            return this;
        }

        @Override
        public final Writer append(char c) {
            return this;
        }

        @Override
        public final void flush() {
        }

        @Override
        public final void close() {
        }

        public final String toString() {
            return "CharStreams.nullWriter()";
        }
    }
}

