/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Ascii;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSequenceReader;
import com.google.common.io.CharSink;
import com.google.common.io.CharStreams;
import com.google.common.io.Closer;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.io.LineProcessor;
import com.google.common.io.MultiReader;
import com.google.common.io.ParametricNullness;
import com.google.common.io.ReaderInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class CharSource {
    protected CharSource() {
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public ByteSource asByteSource(Charset charset) {
        void var1_1;
        return new AsByteSource((Charset)var1_1);
    }

    public abstract Reader openStream() throws IOException;

    /*
     * WARNING - void declaration
     */
    public BufferedReader openBufferedStream() throws IOException {
        void var1_1;
        Reader reader = this.openStream();
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader((Reader)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public Stream<String> lines() throws IOException {
        void var1_1;
        BufferedReader reader = this.openBufferedStream();
        return (Stream)reader.lines().onClose(() -> CharSource.lambda$lines$0((BufferedReader)var1_1));
    }

    @Beta
    public Optional<Long> lengthIfKnown() {
        return Optional.absent();
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public long length() throws IOException {
        long l;
        Optional<Long> lengthIfKnown = this.lengthIfKnown();
        if (lengthIfKnown.isPresent()) {
            return lengthIfKnown.get();
        }
        Closer closer = Closer.create();
        try {
            Reader reader = closer.register(this.openStream());
            l = this.countBySkipping(reader);
        }
        catch (Throwable e) {
            try {
                void var2_3;
                throw closer.rethrow((Throwable)var2_3);
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
        }
        closer.close();
        return l;
    }

    /*
     * WARNING - void declaration
     */
    private long countBySkipping(Reader reader) throws IOException {
        void var2_2;
        long read;
        long count = 0L;
        while ((read = reader.skip(Long.MAX_VALUE)) != 0L) {
            count += read;
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public long copyTo(Appendable appendable) throws IOException {
        long l;
        Preconditions.checkNotNull(appendable);
        Closer closer = Closer.create();
        try {
            void var1_1;
            Reader reader = closer.register(this.openStream());
            l = CharStreams.copy(reader, (Appendable)var1_1);
        }
        catch (Throwable e) {
            try {
                void var3_5;
                throw closer.rethrow((Throwable)var3_5);
            }
            catch (Throwable throwable) {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
        }
        closer.close();
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public long copyTo(CharSink sink) throws IOException {
        long l;
        Preconditions.checkNotNull(sink);
        Closer closer = Closer.create();
        try {
            void var1_1;
            Reader reader = closer.register(this.openStream());
            Writer writer = closer.register(sink.openStream());
            l = CharStreams.copy(reader, (Appendable)var1_1);
        }
        catch (Throwable e) {
            try {
                void var3_5;
                throw closer.rethrow((Throwable)var3_5);
            }
            catch (Throwable throwable) {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
        }
        closer.close();
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public String read() throws IOException {
        Object object;
        Closer closer = Closer.create();
        try {
            object = closer.register(this.openStream());
            object = CharStreams.toString((Readable)object);
        }
        catch (Throwable e) {
            try {
                void var2_3;
                throw closer.rethrow((Throwable)var2_3);
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
        }
        closer.close();
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public String readFirstLine() throws IOException {
        Object object;
        Closer closer = Closer.create();
        try {
            object = closer.register(this.openBufferedStream());
            object = ((BufferedReader)object).readLine();
        }
        catch (Throwable e) {
            try {
                void var2_3;
                throw closer.rethrow((Throwable)var2_3);
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
        }
        closer.close();
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public ImmutableList<String> readLines() throws IOException {
        Object reader;
        Closer closer = Closer.create();
        try {
            void var3_5;
            String line;
            reader = closer.register(this.openBufferedStream());
            ArrayList<String> result = Lists.newArrayList();
            while ((line = ((BufferedReader)reader).readLine()) != null) {
                result.add(line);
            }
            reader = ImmutableList.copyOf(var3_5);
        }
        catch (Throwable e) {
            try {
                void var2_3;
                throw closer.rethrow((Throwable)var2_3);
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
        }
        closer.close();
        return reader;
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    @Beta
    public <T> T readLines(LineProcessor<T> processor) throws IOException {
        Object t;
        Preconditions.checkNotNull(processor);
        Closer closer = Closer.create();
        try {
            Reader reader = closer.register(this.openStream());
            t = CharStreams.readLines(reader, t);
        }
        catch (Throwable e) {
            try {
                void var3_5;
                throw closer.rethrow((Throwable)var3_5);
            }
            catch (Throwable throwable) {
                void var2_3;
                var2_3.close();
                throw throwable;
            }
        }
        closer.close();
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public void forEachLine(Consumer<? super String> action) throws IOException {
        try {
            Stream<String> lines;
            block8: {
                block7: {
                    lines = this.lines();
                    try {
                        void var1_1;
                        lines.forEachOrdered((Consumer<String>)var1_1);
                        if (lines == null) break block7;
                    }
                    catch (Throwable throwable) {
                        if (lines != null) {
                            try {
                                void var2_3;
                                var2_3.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    break block8;
                }
                return;
            }
            lines.close();
        }
        catch (UncheckedIOException uncheckedIOException) {
            UncheckedIOException uncheckedIOException2 = uncheckedIOException;
            throw uncheckedIOException.getCause();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEmpty() throws IOException {
        boolean bl;
        Optional<Long> lengthIfKnown = this.lengthIfKnown();
        if (lengthIfKnown.isPresent()) {
            return lengthIfKnown.get() == 0L;
        }
        Closer closer = Closer.create();
        try {
            Reader reader = closer.register(this.openStream());
            bl = reader.read() == -1;
        }
        catch (Throwable e) {
            try {
                void var2_4;
                throw closer.rethrow((Throwable)var2_4);
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
        }
        closer.close();
        return bl;
    }

    public static CharSource concat(Iterable<? extends CharSource> sources) {
        Iterable<? extends CharSource> iterable;
        return new ConcatenatedCharSource(iterable);
    }

    public static CharSource concat(Iterator<? extends CharSource> sources) {
        return CharSource.concat(ImmutableList.copyOf(sources));
    }

    public static CharSource concat(CharSource ... sources) {
        return CharSource.concat(ImmutableList.copyOf(sources));
    }

    public static CharSource wrap(CharSequence charSequence) {
        CharSequence charSequence2;
        if (charSequence instanceof String) {
            return new StringCharSource((String)charSequence);
        }
        return new CharSequenceCharSource(charSequence2);
    }

    public static CharSource empty() {
        return EmptyCharSource.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$lines$0(BufferedReader reader) {
        try {
            reader.close();
            return;
        }
        catch (IOException e) {
            void var0_1;
            throw new UncheckedIOException((IOException)var0_1);
        }
    }

    private static final class ConcatenatedCharSource
    extends CharSource {
        private final Iterable<? extends CharSource> sources;

        /*
         * WARNING - void declaration
         */
        ConcatenatedCharSource(Iterable<? extends CharSource> sources) {
            void var1_1;
            this.sources = (Iterable)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public final Reader openStream() throws IOException {
            return new MultiReader(this.sources.iterator());
        }

        @Override
        public final boolean isEmpty() throws IOException {
            for (CharSource charSource : this.sources) {
                if (charSource.isEmpty()) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Optional<Long> lengthIfKnown() {
            void var1_1;
            long result = 0L;
            for (CharSource charSource : this.sources) {
                Optional<Long> charSource2 = charSource.lengthIfKnown();
                if (!charSource2.isPresent()) {
                    return Optional.absent();
                }
                result += charSource2.get().longValue();
            }
            return Optional.of((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long length() throws IOException {
            void var1_1;
            long result = 0L;
            for (CharSource charSource : this.sources) {
                result += charSource.length();
            }
            return (long)var1_1;
        }

        public final String toString() {
            String string = String.valueOf(this.sources);
            return new StringBuilder(19 + String.valueOf(string).length()).append("CharSource.concat(").append(string).append(")").toString();
        }
    }

    private static final class EmptyCharSource
    extends StringCharSource {
        private static final EmptyCharSource INSTANCE = new EmptyCharSource();

        private EmptyCharSource() {
            super("");
        }

        @Override
        public final String toString() {
            return "CharSource.empty()";
        }
    }

    private static class StringCharSource
    extends CharSequenceCharSource {
        /*
         * WARNING - void declaration
         */
        protected StringCharSource(String seq) {
            super((CharSequence)var1_1);
            void var1_1;
        }

        @Override
        public Reader openStream() {
            return new StringReader((String)this.seq);
        }

        @Override
        public long copyTo(Appendable appendable) throws IOException {
            appendable.append(this.seq);
            return this.seq.length();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long copyTo(CharSink sink) throws IOException {
            long l;
            Preconditions.checkNotNull(sink);
            Closer closer = Closer.create();
            try {
                sink = closer.register(((CharSink)sink).openStream());
                ((Writer)sink).write((String)this.seq);
                l = this.seq.length();
            }
            catch (Throwable e) {
                try {
                    void var1_2;
                    throw closer.rethrow((Throwable)var1_2);
                }
                catch (Throwable throwable) {
                    void var2_4;
                    var2_4.close();
                    throw throwable;
                }
            }
            closer.close();
            return l;
        }
    }

    private static class CharSequenceCharSource
    extends CharSource {
        private static final Splitter LINE_SPLITTER = Splitter.onPattern("\r\n|\n|\r");
        protected final CharSequence seq;

        /*
         * WARNING - void declaration
         */
        protected CharSequenceCharSource(CharSequence seq) {
            void var1_1;
            this.seq = (CharSequence)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public Reader openStream() {
            return new CharSequenceReader(this.seq);
        }

        @Override
        public String read() {
            return this.seq.toString();
        }

        @Override
        public boolean isEmpty() {
            return this.seq.length() == 0;
        }

        @Override
        public long length() {
            return this.seq.length();
        }

        @Override
        public Optional<Long> lengthIfKnown() {
            return Optional.of(Long.valueOf(this.seq.length()));
        }

        private Iterator<String> linesIterator() {
            return new AbstractIterator<String>(this){
                Iterator<String> lines;
                final /* synthetic */ CharSequenceCharSource this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.lines = LINE_SPLITTER.split(this.this$0.seq).iterator();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected String computeNext() {
                    if (this.lines.hasNext()) {
                        String next = this.lines.next();
                        if (this.lines.hasNext() || !next.isEmpty()) {
                            void var1_1;
                            return var1_1;
                        }
                    }
                    return (String)this.endOfData();
                }
            };
        }

        @Override
        public Stream<String> lines() {
            return Streams.stream(this.linesIterator());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String readFirstLine() {
            Iterator<String> lines = this.linesIterator();
            if (lines.hasNext()) {
                void var1_1;
                return (String)var1_1.next();
            }
            return null;
        }

        @Override
        public ImmutableList<String> readLines() {
            return ImmutableList.copyOf(this.linesIterator());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public <T> T readLines(LineProcessor<T> processor) throws IOException {
            void var1_1;
            Iterator<String> lines = this.linesIterator();
            while (lines.hasNext() && processor.processLine(lines.next())) {
            }
            return var1_1.getResult();
        }

        public String toString() {
            String string = Ascii.truncate(this.seq, 30, "...");
            return new StringBuilder(17 + String.valueOf(string).length()).append("CharSource.wrap(").append(string).append(")").toString();
        }
    }

    private final class AsByteSource
    extends ByteSource {
        final Charset charset;

        /*
         * WARNING - void declaration
         */
        AsByteSource(Charset charset) {
            void var2_2;
            this.charset = (Charset)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final CharSource asCharSource(Charset charset) {
            void var1_1;
            if (charset.equals(this.charset)) {
                return CharSource.this;
            }
            return super.asCharSource((Charset)var1_1);
        }

        @Override
        public final InputStream openStream() throws IOException {
            return new ReaderInputStream(CharSource.this.openStream(), this.charset, 8192);
        }

        public final String toString() {
            String string = CharSource.this.toString();
            String string2 = String.valueOf(this.charset);
            return new StringBuilder(15 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".asByteSource(").append(string2).append(")").toString();
        }
    }
}

