/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Objects;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
final class CharSequenceReader
extends Reader {
    private CharSequence seq;
    private int pos;
    private int mark;

    /*
     * WARNING - void declaration
     */
    public CharSequenceReader(CharSequence seq) {
        void var1_1;
        this.seq = (CharSequence)Preconditions.checkNotNull(var1_1);
    }

    private void checkOpen() throws IOException {
        if (this.seq == null) {
            throw new IOException("reader closed");
        }
    }

    private boolean hasRemaining() {
        return this.remaining() > 0;
    }

    private int remaining() {
        Objects.requireNonNull(this.seq);
        return this.seq.length() - this.pos;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized int read(CharBuffer target) throws IOException {
        void var2_2;
        Preconditions.checkNotNull(target);
        this.checkOpen();
        Objects.requireNonNull(this.seq);
        if (!this.hasRemaining()) {
            return -1;
        }
        int charsToRead = Math.min(target.remaining(), this.remaining());
        for (int i = 0; i < charsToRead; ++i) {
            target.put(this.seq.charAt(this.pos++));
        }
        return (int)var2_2;
    }

    @Override
    public final synchronized int read() throws IOException {
        this.checkOpen();
        Objects.requireNonNull(this.seq);
        if (this.hasRemaining()) {
            return this.seq.charAt(this.pos++);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized int read(char[] cbuf, int off, int len) throws IOException {
        void var3_3;
        int n = off;
        Preconditions.checkPositionIndexes(n, n + len, cbuf.length);
        this.checkOpen();
        Objects.requireNonNull(this.seq);
        if (!this.hasRemaining()) {
            return -1;
        }
        int charsToRead = Math.min(len, this.remaining());
        for (int i = 0; i < charsToRead; ++i) {
            cbuf[off + i] = this.seq.charAt(this.pos++);
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized long skip(long n) throws IOException {
        void var1_2;
        Preconditions.checkArgument(n >= 0L, "n (%s) may not be negative", n);
        this.checkOpen();
        int charsToSkip = (int)Math.min((long)this.remaining(), n);
        this.pos += charsToSkip;
        return (long)var1_2;
    }

    @Override
    public final synchronized boolean ready() throws IOException {
        this.checkOpen();
        return true;
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void mark(int readAheadLimit) throws IOException {
        void var1_1;
        Preconditions.checkArgument(readAheadLimit >= 0, "readAheadLimit (%s) may not be negative", (int)var1_1);
        this.checkOpen();
        this.mark = this.pos;
    }

    @Override
    public final synchronized void reset() throws IOException {
        this.checkOpen();
        this.pos = this.mark;
    }

    @Override
    public final synchronized void close() throws IOException {
        this.seq = null;
    }
}

