/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ElementTypesAreNonnullByDefault;
import com.google.common.io.Java8Compatibility;
import com.google.common.io.ParametricNullness;
import com.google.common.math.IntMath;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class ByteStreams {
    private static final int BUFFER_SIZE = 8192;
    private static final int ZERO_COPY_CHUNK_SIZE = 524288;
    private static final int MAX_ARRAY_LEN = 0x7FFFFFF7;
    private static final int TO_BYTE_ARRAY_DEQUE_SIZE = 20;
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) {
            Preconditions.checkNotNull(b);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(byte[] b, int off, int len) {
            void var1_1;
            void var3_3;
            void var2_2;
            Preconditions.checkNotNull(b);
            void v0 = var2_2;
            Preconditions.checkPositionIndexes((int)v0, (int)(v0 + var3_3), ((void)var1_1).length);
        }

        public String toString() {
            return "ByteStreams.nullOutputStream()";
        }
    };

    static byte[] createBuffer() {
        return new byte[8192];
    }

    private ByteStreams() {
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(InputStream from, OutputStream to) throws IOException {
        void var3_3;
        int r;
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        byte[] buf = ByteStreams.createBuffer();
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(ReadableByteChannel from, WritableByteChannel to) throws IOException {
        void var3_5;
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        if (from instanceof FileChannel) {
            long copied;
            long oldPosition;
            FileChannel sourceChannel = (FileChannel)from;
            long position = oldPosition = sourceChannel.position();
            do {
                copied = sourceChannel.transferTo(position, 524288L, to);
                sourceChannel.position(position += copied);
            } while (copied > 0L || position < sourceChannel.size());
            return position - oldPosition;
        }
        ByteBuffer buf = ByteBuffer.wrap(ByteStreams.createBuffer());
        long total = 0L;
        while (from.read(buf) != -1) {
            Java8Compatibility.flip(buf);
            while (buf.hasRemaining()) {
                total += (long)to.write(buf);
            }
            Java8Compatibility.clear(buf);
        }
        return (long)var3_5;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] toByteArrayInternal(InputStream in, Queue<byte[]> bufs, int totalLen) throws IOException {
        InputStream inputStream;
        int bufSize = Math.min(8192, Math.max(128, Integer.highestOneBit(totalLen) << 1));
        while (totalLen < 0x7FFFFFF7) {
            byte[] buf = new byte[Math.min(bufSize, 0x7FFFFFF7 - totalLen)];
            bufs.add(buf);
            int off = 0;
            while (off < buf.length) {
                int r = in.read(buf, off, buf.length - off);
                if (r == -1) {
                    return ByteStreams.combineBuffers(bufs, totalLen);
                }
                off += r;
                totalLen += r;
            }
            int n = bufSize;
            bufSize = IntMath.saturatedMultiply(n, n < 4096 ? 4 : 2);
        }
        if (inputStream.read() == -1) {
            void var1_1;
            return ByteStreams.combineBuffers((Queue<byte[]>)var1_1, 0x7FFFFFF7);
        }
        throw new OutOfMemoryError("input is too large to fit in a byte array");
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] combineBuffers(Queue<byte[]> bufs, int totalLen) {
        void var2_2;
        if (bufs.isEmpty()) {
            return new byte[0];
        }
        byte[] result = bufs.remove();
        if (result.length == totalLen) {
            return result;
        }
        int remaining = totalLen - result.length;
        result = Arrays.copyOf(result, totalLen);
        while (remaining > 0) {
            byte[] buf = bufs.remove();
            int bytesToCopy = Math.min(remaining, buf.length);
            int resultOffset = totalLen - remaining;
            System.arraycopy(buf, 0, result, resultOffset, bytesToCopy);
            remaining -= bytesToCopy;
        }
        return var2_2;
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        InputStream inputStream;
        Preconditions.checkNotNull(in);
        return ByteStreams.toByteArrayInternal(inputStream, new ArrayDeque<byte[]>(20), 0);
    }

    /*
     * WARNING - void declaration
     */
    static byte[] toByteArray(InputStream in, long expectedSize) throws IOException {
        void var3_2;
        InputStream inputStream;
        int read;
        Preconditions.checkArgument(expectedSize >= 0L, "expectedSize (%s) must be non-negative", expectedSize);
        if (expectedSize > 0x7FFFFFF7L) {
            throw new OutOfMemoryError(new StringBuilder(62).append(expectedSize).append(" bytes is too large to fit in a byte array").toString());
        }
        byte[] bytes = new byte[(int)expectedSize];
        for (int remaining = (int)expectedSize; remaining > 0; remaining -= read) {
            int off = (int)expectedSize - remaining;
            read = in.read(bytes, off, remaining);
            if (read != -1) continue;
            return Arrays.copyOf(bytes, off);
        }
        int b = in.read();
        if (b == -1) {
            return bytes;
        }
        ArrayDeque<byte[]> bufs = new ArrayDeque<byte[]>(22);
        bufs.add(bytes);
        bufs.add(new byte[]{(byte)b});
        return ByteStreams.toByteArrayInternal(inputStream, bufs, ((void)var3_2).length + 1);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static long exhaust(InputStream in) throws IOException {
        void var1_1;
        long read;
        long total = 0L;
        byte[] buf = ByteStreams.createBuffer();
        while ((read = (long)in.read(buf)) != -1L) {
            void var3_3;
            total += var3_3;
        }
        return (long)var1_1;
    }

    @Beta
    public static ByteArrayDataInput newDataInput(byte[] bytes) {
        byte[] byArray;
        return ByteStreams.newDataInput(new ByteArrayInputStream(byArray));
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static ByteArrayDataInput newDataInput(byte[] bytes, int start) {
        void var1_1;
        byte[] byArray;
        Preconditions.checkPositionIndex(start, bytes.length);
        return ByteStreams.newDataInput(new ByteArrayInputStream(bytes, start, byArray.length - var1_1));
    }

    @Beta
    public static ByteArrayDataInput newDataInput(ByteArrayInputStream byteArrayInputStream) {
        ByteArrayInputStream byteArrayInputStream2;
        return new ByteArrayDataInputStream(Preconditions.checkNotNull(byteArrayInputStream2));
    }

    @Beta
    public static ByteArrayDataOutput newDataOutput() {
        return ByteStreams.newDataOutput(new ByteArrayOutputStream());
    }

    @Beta
    public static ByteArrayDataOutput newDataOutput(int size) {
        int n;
        if (size < 0) {
            throw new IllegalArgumentException(String.format("Invalid size: %s", size));
        }
        return ByteStreams.newDataOutput(new ByteArrayOutputStream(n));
    }

    @Beta
    public static ByteArrayDataOutput newDataOutput(ByteArrayOutputStream byteArrayOutputStream) {
        ByteArrayOutputStream byteArrayOutputStream2;
        return new ByteArrayDataOutputStream(Preconditions.checkNotNull(byteArrayOutputStream2));
    }

    @Beta
    public static OutputStream nullOutputStream() {
        return NULL_OUTPUT_STREAM;
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static InputStream limit(InputStream in, long limit) {
        void var1_1;
        InputStream inputStream;
        return new LimitedInputStream(inputStream, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static void readFully(InputStream in, byte[] b) throws IOException {
        void var1_1;
        ByteStreams.readFully(in, b, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        void var2_3;
        void var1_2;
        int read = ByteStreams.read(in, (byte[])var1_2, (int)var2_3, len);
        if (read != len) {
            void var3_4;
            void var0_1;
            throw new EOFException(new StringBuilder(81).append("reached end of stream after reading ").append((int)var0_1).append(" bytes; ").append((int)var3_4).append(" bytes expected").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static void skipFully(InputStream in, long n) throws IOException {
        long skipped = ByteStreams.skipUpTo(in, n);
        if (skipped < n) {
            void var1_1;
            void var3_2;
            throw new EOFException(new StringBuilder(100).append("reached end of stream after skipping ").append((long)var3_2).append(" bytes; ").append((long)var1_1).append(" bytes expected").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    static long skipUpTo(InputStream in, long n) throws IOException {
        void var3_2;
        long skipped;
        byte[] buf = null;
        for (long totalSkipped = 0L; totalSkipped < n; totalSkipped += skipped) {
            long remaining = n - totalSkipped;
            skipped = ByteStreams.skipSafely(in, remaining);
            if (skipped != 0L) continue;
            int skip = (int)Math.min(remaining, 8192L);
            if (buf == null) {
                buf = new byte[skip];
            }
            if ((skipped = (long)in.read(buf, 0, skip)) == -1L) break;
        }
        return (long)var3_2;
    }

    /*
     * WARNING - void declaration
     */
    private static long skipSafely(InputStream in, long n) throws IOException {
        void var1_1;
        void var3_2;
        InputStream inputStream;
        int available = in.available();
        if (available == 0) {
            return 0L;
        }
        return inputStream.skip(Math.min((long)var3_2, (long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    @Beta
    public static <T> T readBytes(InputStream input, ByteProcessor<T> processor) throws IOException {
        void var1_1;
        void var3_3;
        int read;
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull(processor);
        byte[] buf = ByteStreams.createBuffer();
        while ((read = input.read(buf)) != -1 && processor.processBytes(buf, 0, (int)var3_3)) {
        }
        return var1_1.getResult();
    }

    @Beta
    public static int read(InputStream in, byte[] b, int off, int len) throws IOException {
        int total;
        int result;
        Preconditions.checkNotNull(in);
        Preconditions.checkNotNull(b);
        if (len < 0) {
            throw new IndexOutOfBoundsException(String.format("len (%s) cannot be negative", len));
        }
        int n = off;
        Preconditions.checkPositionIndexes(n, n + len, b.length);
        for (total = 0; total < len && (result = in.read(b, off + total, len - total)) != -1; total += result) {
        }
        return total;
    }

    private static final class LimitedInputStream
    extends FilterInputStream {
        private long left;
        private long mark = -1L;

        /*
         * WARNING - void declaration
         */
        LimitedInputStream(InputStream in, long limit) {
            super(in);
            void var2_2;
            void var1_1;
            Preconditions.checkNotNull(var1_1);
            Preconditions.checkArgument(limit >= 0L, "limit must be non-negative");
            this.left = var2_2;
        }

        @Override
        public final int available() throws IOException {
            return (int)Math.min((long)this.in.available(), this.left);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final synchronized void mark(int readLimit) {
            void var1_1;
            this.in.mark((int)var1_1);
            this.mark = this.left;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int read() throws IOException {
            void var1_1;
            if (this.left == 0L) {
                return -1;
            }
            int result = this.in.read();
            if (result != -1) {
                --this.left;
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int read(byte[] b, int off, int len) throws IOException {
            void var1_2;
            void var3_4;
            void var2_3;
            if (this.left == 0L) {
                return -1;
            }
            len = (int)Math.min((long)len, this.left);
            int result = this.in.read(b, (int)var2_3, (int)var3_4);
            if (result != -1) {
                this.left -= (long)result;
            }
            return (int)var1_2;
        }

        @Override
        public final synchronized void reset() throws IOException {
            if (!this.in.markSupported()) {
                throw new IOException("Mark not supported");
            }
            if (this.mark == -1L) {
                throw new IOException("Mark not set");
            }
            this.in.reset();
            this.left = this.mark;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long skip(long n) throws IOException {
            void var3_2;
            void var1_1;
            n = Math.min(n, this.left);
            long skipped = this.in.skip((long)var1_1);
            this.left -= skipped;
            return (long)var3_2;
        }
    }

    private static class ByteArrayDataOutputStream
    implements ByteArrayDataOutput {
        final DataOutput output;
        final ByteArrayOutputStream byteArrayOutputStream;

        /*
         * WARNING - void declaration
         */
        ByteArrayDataOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
            void var1_1;
            this.byteArrayOutputStream = byteArrayOutputStream;
            this.output = new DataOutputStream((OutputStream)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(int b) {
            try {
                this.output.write(b);
                return;
            }
            catch (IOException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(byte[] b) {
            try {
                this.output.write(b);
                return;
            }
            catch (IOException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(byte[] b, int off, int len) {
            try {
                void var3_4;
                void var2_3;
                this.output.write(b, (int)var2_3, (int)var3_4);
                return;
            }
            catch (IOException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeBoolean(boolean v) {
            try {
                this.output.writeBoolean(v);
                return;
            }
            catch (IOException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeByte(int v) {
            try {
                this.output.writeByte(v);
                return;
            }
            catch (IOException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeBytes(String s) {
            try {
                this.output.writeBytes(s);
                return;
            }
            catch (IOException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeChar(int v) {
            try {
                this.output.writeChar(v);
                return;
            }
            catch (IOException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeChars(String s) {
            try {
                this.output.writeChars(s);
                return;
            }
            catch (IOException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeDouble(double v) {
            try {
                this.output.writeDouble(v);
                return;
            }
            catch (IOException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeFloat(float v) {
            try {
                this.output.writeFloat(v);
                return;
            }
            catch (IOException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeInt(int v) {
            try {
                this.output.writeInt(v);
                return;
            }
            catch (IOException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeLong(long v) {
            try {
                this.output.writeLong(v);
                return;
            }
            catch (IOException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeShort(int v) {
            try {
                this.output.writeShort(v);
                return;
            }
            catch (IOException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeUTF(String s) {
            try {
                this.output.writeUTF(s);
                return;
            }
            catch (IOException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }

        @Override
        public byte[] toByteArray() {
            return this.byteArrayOutputStream.toByteArray();
        }
    }

    private static class ByteArrayDataInputStream
    implements ByteArrayDataInput {
        final DataInput input;

        /*
         * WARNING - void declaration
         */
        ByteArrayDataInputStream(ByteArrayInputStream byteArrayInputStream) {
            void var1_1;
            this.input = new DataInputStream((InputStream)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void readFully(byte[] b) {
            try {
                this.input.readFully(b);
                return;
            }
            catch (IOException e) {
                void var1_2;
                throw new IllegalStateException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void readFully(byte[] b, int off, int len) {
            try {
                void var3_4;
                void var2_3;
                this.input.readFully(b, (int)var2_3, (int)var3_4);
                return;
            }
            catch (IOException e) {
                void var1_2;
                throw new IllegalStateException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int skipBytes(int n) {
            try {
                return this.input.skipBytes(n);
            }
            catch (IOException e) {
                void var1_2;
                throw new IllegalStateException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean readBoolean() {
            try {
                return this.input.readBoolean();
            }
            catch (IOException e) {
                void var1_1;
                throw new IllegalStateException((Throwable)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte readByte() {
            try {
                return this.input.readByte();
            }
            catch (EOFException e) {
                throw new IllegalStateException(e);
            }
            catch (IOException impossible) {
                void var1_2;
                throw new AssertionError(var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int readUnsignedByte() {
            try {
                return this.input.readUnsignedByte();
            }
            catch (IOException e) {
                void var1_1;
                throw new IllegalStateException((Throwable)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public short readShort() {
            try {
                return this.input.readShort();
            }
            catch (IOException e) {
                void var1_1;
                throw new IllegalStateException((Throwable)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int readUnsignedShort() {
            try {
                return this.input.readUnsignedShort();
            }
            catch (IOException e) {
                void var1_1;
                throw new IllegalStateException((Throwable)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public char readChar() {
            try {
                return this.input.readChar();
            }
            catch (IOException e) {
                void var1_1;
                throw new IllegalStateException((Throwable)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int readInt() {
            try {
                return this.input.readInt();
            }
            catch (IOException e) {
                void var1_1;
                throw new IllegalStateException((Throwable)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long readLong() {
            try {
                return this.input.readLong();
            }
            catch (IOException e) {
                void var1_1;
                throw new IllegalStateException((Throwable)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public float readFloat() {
            try {
                return this.input.readFloat();
            }
            catch (IOException e) {
                void var1_1;
                throw new IllegalStateException((Throwable)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public double readDouble() {
            try {
                return this.input.readDouble();
            }
            catch (IOException e) {
                void var1_1;
                throw new IllegalStateException((Throwable)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String readLine() {
            try {
                return this.input.readLine();
            }
            catch (IOException e) {
                void var1_1;
                throw new IllegalStateException((Throwable)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String readUTF() {
            try {
                return this.input.readUTF();
            }
            catch (IOException e) {
                void var1_1;
                throw new IllegalStateException((Throwable)var1_1);
            }
        }
    }
}

